/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.kobra.topicmodels;

import cc.mallet.optimize.Optimizable;
import gnu.trove.list.array.TIntArrayList;
import org.apache.commons.math3.special.Gamma;

public class MyWordSimilarityOptimizableOld2
implements Optimizable.ByGradientValue {
    double bias = 0.0;
    int k = 10;
    int v = 1928;
    double[][] parameters = null;
    double[][] b = null;
    double[][] documentFeatures = null;
    public TIntArrayList[] Phi;
    double lambda = 1.0;
    public int[] n_k;
    public int[] n_kv;

    public MyWordSimilarityOptimizableOld2(int k, int v) {
        this.k = k;
        this.v = v;
        this.parameters = new double[k + 1][v];
        for (int i = 0; i < k; ++i) {
            for (int j = 0; j < v; ++j) {
                this.parameters[i][j] = 2.0 * Math.random() - 1.0;
            }
        }
    }

    @Override
    public int getNumParameters() {
        return this.k * this.v + this.v + 1;
    }

    @Override
    public void getParameters(double[] buffer) {
        for (int i = 0; i < this.k + 1; ++i) {
            for (int j = 0; j < this.v; ++j) {
                buffer[i * this.v + j] = this.parameters[i][j];
            }
        }
    }

    @Override
    public double getParameter(int index) {
        return this.parameters[index / this.v][index % this.v];
    }

    @Override
    public void setParameters(double[] params) {
        for (int i = 0; i < this.k + 1; ++i) {
            for (int j = 0; j < this.v; ++j) {
                this.parameters[i][j] = params[i * this.v + j];
            }
        }
    }

    @Override
    public void setParameter(int index, double value) {
        this.parameters[index / this.v][index % this.v] = value;
    }

    @Override
    public void getValueGradient(double[] buffer) {
        double tmp;
        int j;
        int i;
        double L = 0.0;
        for (i = 0; i < buffer.length; ++i) {
            buffer[i] = 0.0;
        }
        this.b = new double[this.k][this.v];
        for (i = 0; i < this.k; ++i) {
            for (j = 0; j < this.v; ++j) {
                tmp = 0.0;
                if (this.Phi != null && this.Phi[i] != null) {
                    for (int v = 0; v < this.Phi[j].size(); ++v) {
                        tmp += this.parameters[i][this.Phi[j].get(v)];
                    }
                }
                this.b[i][j] = Math.exp(tmp + this.parameters[this.k][j] + this.bias);
            }
        }
        for (i = 0; i < this.k; ++i) {
            for (j = 0; j < this.v; ++j) {
                buffer[i * this.v + j] = 1.0 / (this.lambda * this.lambda) * this.parameters[i][j];
            }
        }
        for (int j2 = 0; j2 < this.v; ++j2) {
            buffer[this.k * this.v + j2] = 1.0 / (this.lambda * this.lambda) * this.parameters[this.k][j2];
        }
        buffer[this.k * this.v + this.v] = this.bias * (1.0 / (this.lambda * this.lambda));
        double[] sumBetas = new double[this.k];
        j = 0;
        while (j < this.k) {
            tmp = 0.0;
            for (int i2 = 0; i2 < this.v; ++i2) {
                tmp += this.b[j][i2];
            }
            int n = j++;
            sumBetas[n] = sumBetas[n] + tmp;
        }
        double res = 0.0;
        for (int j3 = 0; j3 < this.v; ++j3) {
            double tmp2 = 0.0;
            for (int i3 = 0; i3 < this.k; ++i3) {
                int v;
                double tmp3 = 0.0;
                if (this.Phi != null && this.Phi[j3] != null) {
                    for (v = 0; v < this.Phi[j3].size(); ++v) {
                        tmp3 += this.b[i3][this.Phi[j3].get(v)];
                    }
                }
                int n = i3 * this.v + j3;
                buffer[n] = buffer[n] + tmp3 * (Gamma.digamma(sumBetas[i3] + (double)this.n_k[i3]) - Gamma.digamma(sumBetas[i3]));
                tmp3 = 0.0;
                if (this.Phi != null && this.Phi[j3] != null) {
                    for (v = 0; v < this.Phi[j3].size(); ++v) {
                        tmp3 += (Gamma.digamma(this.b[i3][v]) - Gamma.digamma(this.b[i3][v] + (double)this.n_kv[v * this.k + i3])) * this.b[i3][this.Phi[j3].get(v)];
                    }
                }
                int n2 = i3 * this.v + j3;
                buffer[n2] = buffer[n2] + tmp3;
                int n3 = this.k * this.v + j3;
                buffer[n3] = buffer[n3] + (Gamma.digamma(this.b[i3][this.v]) - Gamma.digamma(this.b[i3][this.v] + (double)this.n_kv[this.v * this.k + i3])) * this.b[i3][j3];
            }
        }
    }

    @Override
    public double getValue() {
        double res = 0.0;
        for (int j = 0; j < this.k; ++j) {
            for (int i = 0; i < this.v; ++i) {
                res += Math.pow(this.parameters[j][i], 2.0);
            }
        }
        res = (double)(this.k * this.v) / Math.sqrt(Math.PI * this.lambda * this.lambda) - res / (2.0 * this.lambda * this.lambda);
        double[] sumBetas = new double[this.k];
        double L = 0.0;
        for (int j = 0; j < this.k; ++j) {
            double tmp = 0.0;
            for (int i = 0; i < this.v; ++i) {
                if (this.Phi != null && this.Phi[i] != null) {
                    for (int v = 0; v < this.Phi[i].size(); ++v) {
                        tmp += this.parameters[j][this.Phi[i].get(v)];
                    }
                }
                int n = j;
                sumBetas[n] = sumBetas[n] + Math.exp(tmp);
            }
            L += Gamma.logGamma(sumBetas[j] + (double)this.n_k[j]) - Gamma.logGamma(sumBetas[j]);
        }
        double sumProd = 0.0;
        for (int i = 0; i < this.k; ++i) {
            for (int j = 0; j < this.v; ++j) {
                double tmp = 0.0;
                if (this.n_kv[j * this.k + i] <= 0 || this.Phi == null) continue;
                double tmp2 = 0.0;
                if (this.Phi[j] != null) {
                    for (int h = 0; h < this.Phi[j].size(); ++h) {
                        tmp2 += this.parameters[i][this.Phi[j].get(h)];
                    }
                }
                sumProd += (tmp += Gamma.logGamma(Math.exp(tmp2)) - Gamma.logGamma(Math.exp(tmp2) + (double)this.n_kv[j * this.k + i]));
            }
        }
        return L + sumProd - res;
    }
}

