/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.kobra.topicmodels;

import cc.mallet.optimize.Optimizable;
import gnu.trove.list.array.TIntArrayList;
import java.util.Random;
import org.apache.commons.math3.special.Gamma;

public class MyWordSimilarityOptimizable
implements Optimizable.ByGradientValue {
    double bias = 0.0;
    int k = 10;
    int v = 1928;
    int f = 1928;
    double[][] parameters = null;
    double[][] b = null;
    double[][] documentFeatures = null;
    public TIntArrayList[] Phi;
    public double lambda = 0.1;
    public int[] n_k;
    public int[] n_kv;

    public MyWordSimilarityOptimizable(int k, int v) {
        this.k = k;
        this.v = v;
        this.f = v;
        this.parameters = new double[k][v];
        for (int i = 0; i < k; ++i) {
            for (int j = 0; j < v; ++j) {
                this.parameters[i][j] = 2.0 * Math.random() * this.lambda - this.lambda;
            }
        }
    }

    public MyWordSimilarityOptimizable(int k, int v, Random rn) {
        this.k = k;
        this.v = v;
        this.f = v;
        this.parameters = new double[k][v];
        for (int i = 0; i < k; ++i) {
            for (int j = 0; j < v; ++j) {
                this.parameters[i][j] = 2.0 * rn.nextDouble() * this.lambda - this.lambda;
            }
        }
    }

    @Override
    public int getNumParameters() {
        return this.k * this.f;
    }

    @Override
    public void getParameters(double[] buffer) {
        for (int i = 0; i < this.k; ++i) {
            for (int j = 0; j < this.f; ++j) {
                buffer[i * this.f + j] = this.parameters[i][j];
            }
        }
    }

    @Override
    public double getParameter(int index) {
        return this.parameters[index / this.f][index % this.f];
    }

    @Override
    public void setParameters(double[] params) {
        for (int i = 0; i < this.k; ++i) {
            for (int j = 0; j < this.f; ++j) {
                this.parameters[i][j] = params[i * this.f + j];
            }
        }
    }

    @Override
    public void setParameter(int index, double value) {
        this.parameters[index / this.f][index % this.f] = value;
    }

    @Override
    public void getValueGradient(double[] buffer) {
        double tmp;
        int i;
        double L = 0.0;
        for (int i2 = 0; i2 < buffer.length; ++i2) {
            buffer[i2] = 0.0;
        }
        for (int j = 0; j < this.v; ++j) {
            for (i = 0; i < this.k; ++i) {
            }
        }
        this.b = new double[this.k][this.v];
        for (int to = 0; to < this.k; ++to) {
            for (int wo = 0; wo < this.v; ++wo) {
                tmp = 0.0;
                if (this.Phi == null || this.Phi[wo] == null) continue;
                for (int feat2 = 0; feat2 < this.Phi[wo].size(); ++feat2) {
                    int n = to * this.v + wo;
                    buffer[n] = buffer[n] + (this.parameters[to][wo] - this.parameters[to][this.Phi[wo].get(feat2)]) / (this.lambda * this.lambda);
                }
            }
        }
        double[] sumBetas = new double[this.k];
        int j = 0;
        while (j < this.k) {
            tmp = 0.0;
            for (int i3 = 0; i3 < this.v; ++i3) {
                tmp += Math.exp(this.parameters[j][i3]);
            }
            int n = j++;
            sumBetas[n] = sumBetas[n] + tmp;
        }
        for (j = 0; j < this.v; ++j) {
            for (int i4 = 0; i4 < this.k; ++i4) {
                int n = i4 * this.v + j;
                buffer[n] = buffer[n] + (Gamma.digamma(sumBetas[i4] + (double)this.n_k[i4]) - Gamma.digamma(sumBetas[i4])) * Math.exp(this.parameters[i4][j]);
                if (this.n_kv[j * this.k + i4] <= 0) continue;
                int n2 = i4 * this.v + j;
                buffer[n2] = buffer[n2] + (Gamma.digamma(Math.exp(this.parameters[i4][j])) - Gamma.digamma(Math.exp(this.parameters[i4][j]) + (double)this.n_kv[j * this.k + i4])) * Math.exp(this.parameters[i4][j]);
            }
        }
        for (i = 0; i < buffer.length; ++i) {
            buffer[i] = -buffer[i];
        }
    }

    @Override
    public double getValue() {
        int j;
        int j2;
        double res = 0.0;
        for (int i = 0; i < this.k; ++i) {
            for (j2 = 0; j2 < this.v; ++j2) {
            }
        }
        double[] sumBetas = new double[this.k];
        j2 = 0;
        while (j2 < this.k) {
            double tmp = 0.0;
            for (int i = 0; i < this.v; ++i) {
                tmp += Math.exp(this.parameters[j2][i]);
            }
            int n = j2++;
            sumBetas[n] = sumBetas[n] + tmp;
        }
        for (j2 = 0; j2 < this.k; ++j2) {
            for (int i = 0; i < this.v; ++i) {
                if (this.Phi[i] == null) continue;
                for (int feat2 = 0; feat2 < this.Phi[i].size(); ++feat2) {
                    res += Math.pow(this.parameters[j2][i] - this.parameters[j2][this.Phi[i].get(feat2)], 2.0) / (2.0 * this.lambda * this.lambda);
                }
            }
        }
        double L = 0.0;
        for (int i = 0; i < this.k; ++i) {
            double tmp = 0.0;
            for (j = 0; j < this.v; ++j) {
                tmp += Math.exp(this.parameters[i][j]);
            }
            L += Gamma.logGamma(tmp + (double)this.n_k[i]) - Gamma.logGamma(tmp);
        }
        double sumProd = 0.0;
        for (int i = 0; i < this.k; ++i) {
            for (j = 0; j < this.v; ++j) {
                double tmp = 0.0;
                if (this.n_kv[j * this.k + i] > 0) {
                    tmp += Gamma.logGamma(Math.exp(this.parameters[i][j])) - Gamma.logGamma(Math.exp(this.parameters[i][j]) + (double)this.n_kv[j * this.k + i]);
                }
                sumProd += tmp;
            }
        }
        return -1.0 * (L + sumProd + res);
    }
}

