/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.kobra.topicmodels;

import cc.mallet.optimize.Optimizable;
import gnu.trove.list.array.TIntArrayList;
import java.util.Random;
import org.apache.commons.math3.special.Gamma;

public class MyWordFeatOptimizable
implements Optimizable.ByGradientValue {
    int k = 10;
    int v = 1928;
    double[][] parameters = null;
    double[] m = null;
    double[] b = null;
    double[][] documentFeatures = null;
    public TIntArrayList[] Phi;
    public double[] p_v;
    public double lambda = 1.0;
    public double sigma = 2.0;
    public int[] n_k;
    public int[] n_kv;

    public MyWordFeatOptimizable(int k, int v) {
        this.k = k;
        this.v = v;
        this.parameters = new double[k][v];
        this.p_v = new double[v];
        for (int j = 0; j < v; ++j) {
            this.p_v[j] = 1.0 / (double)v;
        }
        for (int i = 0; i < k; ++i) {
            for (int j = 0; j < v; ++j) {
                this.parameters[i][j] = 2.0 * Math.random() * this.sigma - this.sigma;
            }
        }
    }

    public MyWordFeatOptimizable(int k, int v, Random rn) {
        this.k = k;
        this.v = v;
        this.parameters = new double[k][v];
        this.p_v = new double[v];
        for (int j = 0; j < v; ++j) {
            this.p_v[j] = 1.0 / (double)v;
        }
        for (int i = 0; i < k; ++i) {
            for (int j = 0; j < v; ++j) {
                this.parameters[i][j] = 2.0 * rn.nextDouble() * this.sigma - this.sigma;
            }
        }
    }

    @Override
    public int getNumParameters() {
        return this.k * this.v;
    }

    @Override
    public void getParameters(double[] buffer) {
        for (int i = 0; i < this.k; ++i) {
            for (int j = 0; j < this.v; ++j) {
                buffer[i * this.v + j] = this.parameters[i][j];
            }
        }
    }

    @Override
    public double getParameter(int index) {
        return this.parameters[index / this.v][index % this.v];
    }

    @Override
    public void setParameters(double[] params) {
        for (int i = 0; i < this.k; ++i) {
            for (int j = 0; j < this.v; ++j) {
                this.parameters[i][j] = params[i * this.v + j];
            }
        }
    }

    @Override
    public void setParameter(int index, double value) {
        this.parameters[index / this.v][index % this.v] = value;
    }

    @Override
    public void getValueGradient(double[] buffer) {
        int i;
        double L = 0.0;
        for (int i2 = 0; i2 < buffer.length; ++i2) {
            buffer[i2] = 0.0;
        }
        for (int j = 0; j < this.v; ++j) {
            for (i = 0; i < this.k; ++i) {
                buffer[i * this.v + j] = this.parameters[i][j] / (this.lambda * this.lambda);
            }
        }
        double[] sumBetas = new double[this.k];
        for (i = 0; i < this.k; ++i) {
            for (int j = 0; j < this.v; ++j) {
                int n = i;
                sumBetas[n] = sumBetas[n] + Math.exp(this.parameters[i][j]) * this.p_v[j];
            }
        }
        for (int j = 0; j < this.v; ++j) {
            for (int i3 = 0; i3 < this.k; ++i3) {
                int n = i3 * this.v + j;
                buffer[n] = buffer[n] + (Gamma.digamma(sumBetas[i3] + (double)this.n_k[i3]) - Gamma.digamma(sumBetas[i3])) * Math.exp(this.parameters[i3][j]) * this.p_v[j];
                if (this.n_kv[j * this.k + i3] <= 0) continue;
                int n2 = i3 * this.v + j;
                buffer[n2] = buffer[n2] + (Gamma.digamma(Math.exp(this.parameters[i3][j]) * this.p_v[j]) - Gamma.digamma(Math.exp(this.parameters[i3][j]) * this.p_v[j] + (double)this.n_kv[j * this.k + i3])) * Math.exp(this.parameters[i3][j]) * this.p_v[j];
            }
        }
        for (i = 0; i < buffer.length; ++i) {
            buffer[i] = buffer[i];
        }
    }

    @Override
    public double getValue() {
        int j;
        double res = 0.0;
        for (int i = 0; i < this.k; ++i) {
            for (int j2 = 0; j2 < this.v; ++j2) {
                res += this.parameters[i][j2] * this.parameters[i][j2] / (2.0 * this.sigma * this.sigma);
            }
        }
        double L = 0.0;
        for (int i = 0; i < this.k; ++i) {
            double tmp = 0.0;
            for (j = 0; j < this.v; ++j) {
                tmp += Math.exp(this.parameters[i][j]) * this.p_v[j];
            }
            L += Gamma.logGamma(tmp + (double)this.n_k[i]) - Gamma.logGamma(tmp);
        }
        double sumProd = 0.0;
        for (int i = 0; i < this.k; ++i) {
            for (j = 0; j < this.v; ++j) {
                double tmp = 0.0;
                if (this.n_kv[j * this.k + i] > 0) {
                    tmp += Gamma.logGamma(Math.exp(this.parameters[i][j]) * this.p_v[j]) - Gamma.logGamma(Math.exp(this.parameters[i][j]) * this.p_v[j] + (double)this.n_kv[j * this.k + i]);
                }
                sumProd += tmp;
            }
        }
        return -1.0 * (L + sumProd + res);
    }
}

