/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.kobra.topicmodels;

import cc.mallet.types.Dirichlet;
import com.rapidminer.kobra.topicmodels.MySparseGroupWordFeatOptimizable;
import java.util.Random;
import org.apache.commons.math3.special.Gamma;

public class MySparseGroupOptimizable
extends MySparseGroupWordFeatOptimizable {
    double[] paras;

    public MySparseGroupOptimizable(int k, int v) {
        super(k, v);
        this.k = k;
        this.v = v;
        this.currentGroup = 0;
    }

    public MySparseGroupOptimizable(int k, int v, int num) {
        super(k, v);
        this.k = k;
        this.v = v;
        this.currentGroup = 0;
        this.numTokens = num;
    }

    @Override
    public void init(int group, int topic) {
        int[] ids = this.groups[group];
        this.paras = new double[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            this.paras[i] = 2.0 * Math.random() * this.sigma - this.sigma;
        }
    }

    @Override
    public void init(int group, int topic, Random rn) {
        int[] ids = this.groups[group];
        this.paras = new double[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            this.paras[i] = 2.0 * rn.nextDouble() * this.sigma - this.sigma;
        }
    }

    @Override
    public int getNumParameters() {
        return this.groups[this.currentGroup].length;
    }

    @Override
    public void getParameters(double[] buffer) {
        int i = this.currentK;
        int[] ids = this.groups[this.currentGroup];
        for (int j = 0; j < this.groups[this.currentGroup].length; ++j) {
            buffer[j] = this.paras[j];
        }
    }

    @Override
    public double getParameter(int index) {
        return this.paras[index];
    }

    @Override
    public void setParameters(double[] params) {
        for (int j = 0; j < params.length; ++j) {
            this.paras[j] = params[j];
        }
        int[] ids = this.groups[this.currentGroup];
        for (int j = 0; j < ids.length; ++j) {
            int i = this.currentK;
            this.parameters[i][ids[j]] = this.paras[j];
        }
    }

    @Override
    public void setParameter(int index, double value) {
        this.paras[index] = value;
        int[] ids = this.groups[this.currentGroup];
        for (int j = 0; j < ids.length; ++j) {
            int i = this.currentK;
            this.parameters[i][ids[j]] = this.paras[j];
        }
    }

    @Override
    public void getValueGradient(double[] buffer) {
        int i;
        int j;
        double L = 0.0;
        int[] ids = null;
        ids = this.currentGroup == -1 ? this.all : this.groups[this.currentGroup];
        for (int i2 = 0; i2 < buffer.length; ++i2) {
            buffer[i2] = 0.0;
        }
        double[] sumBetas = new double[this.k];
        for (int i3 = 0; i3 < this.k; ++i3) {
            for (int j2 = 0; j2 < this.v; ++j2) {
                int n = i3;
                sumBetas[n] = sumBetas[n] + Math.exp(this.parameters[i3][j2]) * this.p_v[j2];
            }
        }
        double tmp = 0.0;
        for (j = 0; j < ids.length; ++j) {
            tmp += this.parameters[this.currentK][ids[j]] * this.parameters[this.currentK][ids[j]];
        }
        if (tmp == 0.0) {
            buffer = this.lastBuffer;
            return;
        }
        for (j = 0; j < ids.length; ++j) {
            i = this.currentK;
            int n = j;
            buffer[n] = buffer[n] + 2.0 * this.parameters[i][ids[j]] / (this.lambda * this.lambda);
        }
        for (j = 0; j < ids.length; ++j) {
            i = this.currentK;
            int n = j;
            buffer[n] = buffer[n] + (Dirichlet.digamma(sumBetas[i] + (double)this.n_k[i]) - Dirichlet.digamma(sumBetas[i]) * Math.exp(this.parameters[i][ids[j]])) * this.p_v[ids[j]];
            if (this.n_kv[ids[j] * this.k + i] <= 0) continue;
            int n2 = j;
            buffer[n2] = buffer[n2] + (Dirichlet.digamma(Math.exp(this.parameters[i][ids[j]]) * this.p_v[ids[j]]) - Dirichlet.digamma(Math.exp(this.parameters[i][ids[j]]) * this.p_v[ids[j]] + (double)this.n_kv[ids[j] * this.k + i])) * Math.exp(this.parameters[i][ids[j]]) * this.p_v[ids[j]];
        }
        this.lastBuffer = new double[buffer.length];
        for (int i4 = 0; i4 < buffer.length; ++i4) {
            buffer[i4] = buffer[i4] / (double)this.numTokens;
            this.lastBuffer[i4] = buffer[i4];
        }
    }

    @Override
    public double getValue() {
        int j;
        int[] ids = this.groups[this.currentGroup];
        for (int j2 = 0; j2 < ids.length; ++j2) {
            int i = this.currentK;
            this.parameters[i][ids[j2]] = this.paras[j2];
        }
        double res = 0.0;
        for (int i = 0; i < this.k; ++i) {
            for (int j3 = 0; j3 < this.v; ++j3) {
                res += this.parameters[i][j3] * this.parameters[i][j3] / (2.0 * this.lambda * this.lambda);
            }
        }
        double gl = 0.0;
        double L = 0.0;
        for (int i = 0; i < this.k; ++i) {
            double tmp = 0.0;
            for (j = 0; j < this.v; ++j) {
                tmp += Math.exp(this.parameters[i][j]) * this.p_v[j];
            }
            L += Gamma.logGamma(tmp + (double)this.n_k[i]) - Gamma.logGamma(tmp);
        }
        double sumProd = 0.0;
        for (int i = 0; i < this.k; ++i) {
            for (j = 0; j < this.v; ++j) {
                double tmp = 0.0;
                if (this.n_kv[j * this.k + i] > 0) {
                    tmp += Gamma.logGamma(Math.exp(this.parameters[i][j]) * this.p_v[j]) - Gamma.logGamma(Math.exp(this.parameters[i][j]) * this.p_v[j] + (double)this.n_kv[j * this.k + i]);
                }
                sumProd += tmp;
            }
        }
        this.last = -1.0 * (L + sumProd + res + gl);
        this.last /= (double)this.numTokens;
        return -1.0 / (double)this.numTokens * (L + sumProd + res + gl);
    }
}

