/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.kobra.topicmodels;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SimpleExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DataRowFactory;
import com.rapidminer.example.table.ExampleTable;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.kobra.topicmodels.SamplersLDAMyWordFeatures;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeString;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.List;

public class MyLDAWordFeaturesOperator
extends Operator {
    static String PARAMETER_NUMITERATIONS = "iterations";
    static String PARAMETER_NUMTOPICS = "number_of_topics";
    static String PARAMETER_ALPHA = "alpha";
    static String PARAMETER_BETA = "beta";
    static String PARAMETER_GROUP = "group";
    int iters = 2000;
    int numTopics = 4;
    double alpha = 0.25;
    double beta = 0.1;
    private final InputPort input = (InputPort)this.getInputPorts().createPort("example set input");
    private final InputPort inputGroup = (InputPort)this.getInputPorts().createPort("example set input group");
    private final InputPort inputWords = (InputPort)this.getInputPorts().createPort("example set input word adjacency matrix");
    private final OutputPort outputWords = (OutputPort)this.getOutputPorts().createPort("example set words");
    private final OutputPort outputDocs = (OutputPort)this.getOutputPorts().createPort("example set docs");
    private final OutputPort outputGroups = (OutputPort)this.getOutputPorts().createPort("example set groups");

    public MyLDAWordFeaturesOperator(OperatorDescription description) {
        super(description);
    }

    public void doWork() throws OperatorException {
        int i;
        this.iters = this.getParameterAsInt(PARAMETER_NUMITERATIONS);
        this.numTopics = this.getParameterAsInt(PARAMETER_NUMTOPICS);
        this.alpha = this.getParameterAsDouble(PARAMETER_ALPHA);
        this.beta = this.getParameterAsDouble(PARAMETER_BETA);
        TIntArrayList wordToken = new TIntArrayList();
        TIntArrayList docToken = new TIntArrayList();
        int numWords = 0;
        ExampleSet exampleSet = (ExampleSet)this.input.getData(ExampleSet.class);
        Example ex = exampleSet.getExample(0);
        Attributes attr = ex.getAttributes();
        numWords = attr.size();
        String[] words = new String[numWords];
        for (int i2 = 0; i2 < exampleSet.size(); ++i2) {
            int docId = i2;
            ex = exampleSet.getExample(i2);
            attr = ex.getAttributes();
            boolean nextAtt = false;
            int j = 0;
            for (Attribute att : attr) {
                words[j] = att.getName();
                int wordId = j++;
                double frequ = 0.0;
                frequ = ex.getValue(att);
                if (frequ == 0.0) continue;
                for (int k = 0; k < (int)frequ; ++k) {
                    docToken.add(docId);
                    wordToken.add(wordId);
                }
            }
        }
        TIntArrayList[] graph = new TIntArrayList[numWords];
        TDoubleArrayList[] graphWeights = new TDoubleArrayList[numWords];
        double[] p_v = new double[numWords];
        ExampleSet wordNeigh = (ExampleSet)this.inputWords.getDataOrNull(ExampleSet.class);
        double Z = 0.0;
        if (wordNeigh != null) {
            for (int i3 = 0; i3 < wordNeigh.size(); ++i3) {
                ex = wordNeigh.getExample(i3);
                attr = ex.getAttributes();
                int j = 0;
                for (Attribute att : attr) {
                    double frequ = 0.0;
                    frequ = ex.getValue(att);
                    if (frequ != 0.0) {
                        int n = i3;
                        p_v[n] = p_v[n] + frequ;
                        Z += frequ;
                    }
                    ++j;
                }
            }
        }
        int i4 = 0;
        while (i4 < p_v.length) {
            int n = i4++;
            p_v[n] = p_v[n] / Z;
        }
        SamplersLDAMyWordFeatures sampler = new SamplersLDAMyWordFeatures();
        sampler.Phi = graph;
        sampler.p_v = p_v;
        sampler.init(docToken.toArray(), wordToken.toArray(), this.numTopics, numWords, exampleSet.size(), this.iters, this.beta, this.alpha);
        sampler.GibbsSampling();
        double[][] probs = sampler.documentDistribution();
        ArrayList<Attribute> attributeList = new ArrayList<Attribute>();
        attributeList.add(AttributeFactory.createAttribute((String)"Doc", (int)2));
        attributeList.add(AttributeFactory.createAttribute((String)"Topic", (int)2));
        for (int i5 = 0; i5 < this.numTopics; ++i5) {
            attributeList.add(AttributeFactory.createAttribute((String)("Topic_" + i5), (int)2));
        }
        MemoryExampleTable table = new MemoryExampleTable(attributeList);
        DataRowFactory factory = new DataRowFactory(0, '.');
        for (int i6 = 0; i6 < exampleSet.size(); ++i6) {
            DataRow row = factory.create(table.getNumberOfAttributes());
            table.addDataRow(row);
            row.set((Attribute)attributeList.get(0), (double)(i6 + 1));
            int top = -1;
            double max = 0.0;
            for (int j = 0; j < this.numTopics; ++j) {
                if (probs[j][i6] > max) {
                    max = probs[j][i6];
                    top = j;
                }
                row.set((Attribute)attributeList.get(2 + j), probs[j][i6]);
            }
            row.set((Attribute)attributeList.get(1), (double)top);
        }
        SimpleExampleSet set = new SimpleExampleSet((ExampleTable)table);
        this.outputDocs.deliver((IOObject)set);
        probs = sampler.wordDistribution();
        double[][] betas = sampler.getBetas();
        attributeList = new ArrayList();
        attributeList.add(AttributeFactory.createAttribute((String)"Word", (int)5));
        attributeList.add(AttributeFactory.createAttribute((String)"Word_id", (int)2));
        attributeList.add(AttributeFactory.createAttribute((String)"Topic", (int)2));
        for (i = 0; i < this.numTopics; ++i) {
            attributeList.add(AttributeFactory.createAttribute((String)("Topic_" + i), (int)2));
        }
        for (i = 0; i < this.numTopics; ++i) {
            attributeList.add(AttributeFactory.createAttribute((String)("Betas_" + i), (int)2));
        }
        table = new MemoryExampleTable(attributeList);
        factory = new DataRowFactory(0, '.');
        for (i = 0; i < numWords; ++i) {
            DataRow row = factory.create(table.getNumberOfAttributes());
            table.addDataRow(row);
            row.set((Attribute)attributeList.get(0), (double)((Attribute)attributeList.get(0)).getMapping().mapString(words[i]));
            row.set((Attribute)attributeList.get(1), (double)(i + 1));
            int top = -1;
            double max = 0.0;
            for (int j = 0; j < this.numTopics; ++j) {
                if (probs[j][i] > max) {
                    max = probs[j][i];
                    top = j;
                }
                row.set((Attribute)attributeList.get(3 + j), probs[j][i]);
                row.set((Attribute)attributeList.get(3 + this.numTopics + j), betas[j][i]);
            }
            row.set((Attribute)attributeList.get(2), (double)top);
        }
        set = new SimpleExampleSet((ExampleTable)table);
        this.outputWords.deliver((IOObject)set);
        String gAtt = this.getParameter(PARAMETER_GROUP);
        ExampleSet exGroup = (ExampleSet)this.inputGroup.getDataOrNull(ExampleSet.class);
        if (gAtt != "" && exGroup != null && exGroup.getAttributes().get(gAtt) != null) {
            int[] counts;
            int i7;
            Attribute att = exGroup.getAttributes().get(gAtt);
            String[] groups = new String[exampleSet.size()];
            int[] assignments = sampler.getTokenToTopic();
            TObjectIntHashMap<String> map = new TObjectIntHashMap<String>();
            TIntObjectHashMap<int[]> map2 = new TIntObjectHashMap<int[]>();
            int nextGroup = 1;
            for (i7 = 0; i7 < exampleSet.size(); ++i7) {
                ex = exGroup.getExample(i7);
                String next = ex.getValueAsString(att);
                if (!map.contains(next)) {
                    counts = new int[this.numTopics];
                    counts[assignments[i7]] = 1;
                    map2.put(nextGroup, counts);
                    map.put(next, nextGroup);
                    ++nextGroup;
                    continue;
                }
                counts = (int[])map2.get(map.get(next));
                counts[assignments[i7]] = counts[assignments[i7]] + 1;
            }
            attributeList = new ArrayList();
            attributeList.add(AttributeFactory.createAttribute((String)"Group", (int)5));
            for (i7 = 0; i7 < this.numTopics; ++i7) {
                attributeList.add(AttributeFactory.createAttribute((String)("Topic_" + (i7 + 1)), (int)3));
            }
            table = new MemoryExampleTable(attributeList);
            factory = new DataRowFactory(0, '.');
            for (i7 = 0; i7 < map.keys().length; ++i7) {
                int j;
                String key = (String)map.keys()[i7];
                counts = (int[])map2.get(map.get(key));
                DataRow row = factory.create(table.getNumberOfAttributes());
                table.addDataRow(row);
                row.set((Attribute)attributeList.get(0), (double)((Attribute)attributeList.get(0)).getMapping().mapString(key));
                double sum = 0.0;
                for (j = 0; j < counts.length; ++j) {
                    sum += (double)counts[j];
                }
                for (j = 0; j < counts.length; ++j) {
                    row.set((Attribute)attributeList.get(j + 1), (double)counts[j] / sum);
                }
            }
            set = new SimpleExampleSet((ExampleTable)table);
            this.outputGroups.deliver((IOObject)set);
        }
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeInt(PARAMETER_NUMITERATIONS, "Number of Iterations for Gibbs Sampling.", 1, Integer.MAX_VALUE, 2000));
        types.add(new ParameterTypeInt(PARAMETER_NUMTOPICS, "Number of Topics.", 1, Integer.MAX_VALUE, 5));
        types.add(new ParameterTypeDouble(PARAMETER_ALPHA, "Alpha", 0.0, Double.MAX_VALUE, 0.25));
        types.add(new ParameterTypeDouble(PARAMETER_BETA, "Beta", 0.0, Double.MAX_VALUE, 0.1));
        types.add(new ParameterTypeString(PARAMETER_GROUP, "Attribute name for grouping the word counts."));
        return types;
    }

    public static void main(String[] args) {
    }
}

