/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.kobra.topicmodels;

import cc.mallet.optimize.Optimizable;
import gnu.trove.map.hash.TDoubleIntHashMap;

public class MyHashGompertzOptimizable
implements Optimizable.ByGradientValue {
    double alpha = 0.0;
    double beta = 0.0;
    double a = 0.0;
    double b = 0.0;
    double[] values;
    TDoubleIntHashMap vals = null;

    @Override
    public int getNumParameters() {
        return 2;
    }

    @Override
    public void getParameters(double[] buffer) {
        buffer[0] = this.a;
        buffer[1] = this.b;
    }

    @Override
    public double getParameter(int index) {
        return index == 0 ? this.a : this.b;
    }

    @Override
    public void setParameters(double[] params) {
        this.a = params[0];
        this.b = params[1];
    }

    @Override
    public void setParameter(int index, double value) {
        if (index == 0) {
            this.a = value;
        } else {
            this.b = value;
        }
    }

    @Override
    public void getValueGradient(double[] buffer) {
        int n = 0;
        this.alpha = Math.exp(this.a);
        this.beta = Math.exp(this.b);
        double s2 = 0.0;
        double s3 = 0.0;
        double s4 = 0.0;
        double s5 = 0.0;
        int nv = 0;
        n = 0;
        for (double k : this.vals.keys()) {
            nv = this.vals.get(k);
            n += nv;
            s2 -= (double)nv * Math.exp(-this.beta * k);
            s3 += (double)nv * (1.0 - Math.exp(-this.beta * k)) / (1.0 + this.alpha * (1.0 - Math.exp(-this.beta * k)));
            s4 += (double)nv * k * (1.0 - this.alpha * Math.exp(-this.beta * k));
            s5 += (double)nv * (k * Math.exp(-this.beta * k)) / (1.0 + this.alpha * (1.0 - Math.exp(-this.beta * k)));
        }
        buffer[0] = this.alpha * (s2 + s3) / (double)n;
        buffer[1] = this.beta * ((double)n / this.beta - s4 + this.alpha * s5) / (double)n;
    }

    @Override
    public double getValue() {
        this.alpha = Math.exp(this.a);
        this.beta = Math.exp(this.b);
        int n = 0;
        double s1 = 0.0;
        double s2 = 0.0;
        double s3 = 0.0;
        int nv = 0;
        n = 0;
        for (double k : this.vals.keys()) {
            nv = this.vals.get(k);
            n += nv;
            s1 += (double)nv * k;
            s2 += (double)nv * Math.exp(-this.beta * k);
            s3 += (double)nv * Math.log(1.0 + this.alpha * (1.0 - Math.exp(-this.beta * k)));
        }
        return ((double)n * Math.log(this.beta) - this.beta * s1 - this.alpha * s2 + s3) / (double)n;
    }

    public double getValue2() {
        this.alpha = Math.exp(this.a);
        this.beta = Math.exp(this.b);
        int n = 0;
        double s1 = 0.0;
        double s2 = 0.0;
        double s3 = 0.0;
        int nv = 0;
        n = 0;
        for (double k : this.vals.keys()) {
            nv = this.vals.get(k);
            n += nv;
            s1 += (double)nv * k;
            s2 += (double)nv * Math.exp(-this.beta * k);
            s3 += (double)nv * Math.log(1.0 + this.alpha * (1.0 - Math.exp(-this.beta * k)));
        }
        return (double)n * Math.log(this.beta) - this.beta * s1 - this.alpha * s2 + s3;
    }
}

