/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.kobra.topicmodels;

import cc.mallet.optimize.Optimizable;

public class MyGompertzOptimizable
implements Optimizable.ByGradientValue {
    double alpha = 0.0;
    double beta = 0.0;
    double a = 0.0;
    double b = 0.0;
    double[] values;

    @Override
    public int getNumParameters() {
        return 2;
    }

    @Override
    public void getParameters(double[] buffer) {
        buffer[0] = this.a;
        buffer[1] = this.b;
    }

    @Override
    public double getParameter(int index) {
        return index == 0 ? this.a : this.b;
    }

    @Override
    public void setParameters(double[] params) {
        this.a = params[0];
        this.b = params[1];
    }

    @Override
    public void setParameter(int index, double value) {
        if (index == 0) {
            this.a = value;
        } else {
            this.b = value;
        }
    }

    @Override
    public void getValueGradient(double[] buffer) {
        int n = this.values.length;
        this.alpha = Math.exp(this.a);
        this.beta = Math.exp(this.b);
        double s2 = 0.0;
        for (int i = 0; i < n; ++i) {
            s2 -= Math.exp(-this.beta * this.values[i]);
        }
        double s3 = 0.0;
        for (int i = 0; i < n; ++i) {
            s3 += (1.0 - Math.exp(-this.beta * this.values[i])) / (1.0 + this.alpha * (1.0 - Math.exp(-this.beta * this.values[i])));
        }
        buffer[0] = this.alpha * (s2 + s3) / (double)n;
        double s4 = 0.0;
        for (int i = 0; i < n; ++i) {
            s4 += this.values[i] * (1.0 - this.alpha * Math.exp(-this.beta * this.values[i]));
        }
        double s5 = 0.0;
        for (int i = 0; i < n; ++i) {
            s5 += this.values[i] * Math.exp(-this.beta * this.values[i]) / (1.0 + this.alpha * (1.0 - Math.exp(-this.beta * this.values[i])));
        }
        buffer[1] = this.beta * ((double)n / this.beta - s4 + this.alpha * s5) / (double)n;
    }

    @Override
    public double getValue() {
        this.alpha = Math.exp(this.a);
        this.beta = Math.exp(this.b);
        int n = this.values.length;
        double res = (double)n * Math.log(this.beta);
        double s1 = 0.0;
        for (int i = 0; i < n; ++i) {
            s1 += this.values[i];
        }
        double s2 = 0.0;
        for (int i = 0; i < n; ++i) {
            s2 += Math.exp(-this.beta * this.values[i]);
        }
        double s3 = 0.0;
        for (int i = 0; i < n; ++i) {
            s3 += Math.log(1.0 + this.alpha * (1.0 - Math.exp(-this.beta * this.values[i])));
        }
        return 1.0 * (res - this.beta * s1 - this.alpha * s2 + s3) / (double)n;
    }
}

