/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.kobra.topicmodels;

import cc.mallet.optimize.Optimizable;

public class MyEtaOptimizable
implements Optimizable.ByGradientValue {
    int k = 10;
    int d = 200;
    double mu = 0.0;
    double sigma = 100.0;
    double rho = 0.1;
    double[] parameters = null;
    double[][] z_bar;
    double[] b = null;
    double[] labels;
    double[][] documentFeatures = null;

    @Override
    public int getNumParameters() {
        return this.parameters.length;
    }

    @Override
    public void getParameters(double[] buffer) {
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = this.parameters[i];
        }
    }

    @Override
    public double getParameter(int index) {
        return this.parameters[index];
    }

    @Override
    public void setParameters(double[] params) {
        for (int i = 0; i < params.length; ++i) {
            this.parameters[i] = params[i];
        }
    }

    @Override
    public void setParameter(int index, double value) {
        this.parameters[index] = value;
    }

    public MyEtaOptimizable(double[] labels, int topics, double[][] z) {
        this.k = topics;
        this.d = labels.length;
        this.labels = labels;
        this.z_bar = z;
        this.parameters = new double[this.k];
        for (int i = 0; i < this.k; ++i) {
            this.parameters[i] = 2.0 * Math.random() - 1.0;
        }
    }

    @Override
    public void getValueGradient(double[] buffer) {
        int i;
        double[] outers = new double[this.d];
        for (i = 0; i < this.parameters.length; ++i) {
            buffer[i] = 0.0;
        }
        for (i = 0; i < this.parameters.length; ++i) {
            for (int j = 0; j < this.d; ++j) {
                double inner = 0.0;
                for (int k = 0; k < this.parameters.length; ++k) {
                    inner += this.parameters[k] * this.z_bar[j][k];
                }
                outers[j] = this.labels[j] - inner;
                int n = i;
                buffer[n] = buffer[n] + outers[j] * this.z_bar[j][i] / this.rho;
            }
        }
        for (i = 0; i < this.parameters.length; ++i) {
            int n = i;
            buffer[n] = buffer[n] - (this.parameters[i] - this.mu) / this.sigma;
        }
        for (i = 0; i < this.parameters.length; ++i) {
            buffer[i] = buffer[i];
        }
        double L = 0.0;
    }

    @Override
    public double getValue() {
        double first = 0.0;
        for (int i = 0; i < this.labels.length; ++i) {
            double inner = 0.0;
            for (int j = 0; j < this.z_bar[i].length; ++j) {
                inner += this.parameters[j] * this.z_bar[i][j];
            }
            first += (this.labels[i] - inner) * (this.labels[i] - inner);
        }
        first /= -2.0 * this.rho;
        double second = 0.0;
        for (int i = 0; i < this.parameters.length; ++i) {
            second += (this.parameters[i] - this.mu) * (this.parameters[i] - this.mu);
        }
        return first + (second /= -2.0 * this.sigma);
    }
}

