/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.kobra.topicmodels;

import cc.mallet.optimize.Optimizable;
import cc.mallet.types.Dirichlet;
import java.util.Random;
import org.apache.commons.math3.special.Gamma;

public class MyDMROptimizable
implements Optimizable.ByGradientValue {
    int f = 10;
    int k = 10;
    int n = 1928;
    double sigma = 1.0;
    double[][] parameters = null;
    double[] b = null;
    double[][] documentFeatures = null;
    int[] n_d = null;
    int[] n_td = null;

    public MyDMROptimizable(int f, int k, int n) {
        this.k = k;
        this.f = f;
        this.n = n;
    }

    public void init() {
        this.parameters = new double[this.k][this.f];
        for (int i = 0; i < this.k; ++i) {
            for (int j = 0; j < this.f; ++j) {
                this.parameters[i][j] = 2.0 * Math.random() * this.sigma - this.sigma;
            }
        }
    }

    public void init(Random rn) {
        this.parameters = new double[this.k][this.f];
        for (int i = 0; i < this.k; ++i) {
            for (int j = 0; j < this.f; ++j) {
                this.parameters[i][j] = 2.0 * rn.nextDouble() * this.sigma - this.sigma;
            }
        }
    }

    @Override
    public int getNumParameters() {
        return this.f * this.k;
    }

    @Override
    public void getParameters(double[] buffer) {
        for (int i = 0; i < this.k; ++i) {
            for (int j = 0; j < this.f; ++j) {
                buffer[i * this.f + j] = this.parameters[i][j];
            }
        }
    }

    @Override
    public double getParameter(int index) {
        return this.parameters[index / this.f][index % this.f];
    }

    @Override
    public void setParameters(double[] params) {
        for (int i = 0; i < this.k; ++i) {
            for (int j = 0; j < this.f; ++j) {
                this.parameters[i][j] = params[i * this.f + j];
            }
        }
    }

    @Override
    public void setParameter(int index, double value) {
        this.parameters[index / this.f][index % this.f] = value;
    }

    @Override
    public void getValueGradient(double[] buffer) {
        int i;
        double L = 0.0;
        for (i = 0; i < buffer.length; ++i) {
            buffer[i] = 0.0;
        }
        for (i = 0; i < this.k; ++i) {
            for (int j = 0; j < this.f; ++j) {
                buffer[i * this.f + j] = -this.parameters[i][j] / (this.sigma * this.sigma);
            }
        }
        for (int d = 0; d < this.n; ++d) {
            double[] inner = new double[this.k];
            double[] expInner = new double[this.k];
            double sumExpInner = 0.0;
            for (int t2 = 0; t2 < this.k; ++t2) {
                for (int f2 = 0; f2 < this.f; ++f2) {
                    int n = t2;
                    inner[n] = inner[n] + this.documentFeatures[d][f2] * this.parameters[t2][f2];
                }
                expInner[t2] = Math.exp(inner[t2]);
                sumExpInner += expInner[t2];
            }
            for (int k = 0; k < this.f; ++k) {
                for (int t = 0; t < this.k; ++t) {
                    int n = t * this.f + k;
                    buffer[n] = buffer[n] + this.documentFeatures[t][k] * expInner[t] * (Dirichlet.digamma(sumExpInner) - Dirichlet.digamma(sumExpInner + (double)this.n_d[d]) + Dirichlet.digamma(expInner[t] + (double)this.n_td[d * this.k + t]) - Dirichlet.digamma(expInner[t]));
                }
            }
        }
        for (i = 0; i < buffer.length; ++i) {
            buffer[i] = -buffer[i] / (double)this.n;
        }
    }

    @Override
    public double getValue() {
        double L = 0.0;
        for (int j = 0; j < this.f; ++j) {
            for (int i = 0; i < this.k; ++i) {
                L = -this.parameters[i][j] / (this.sigma * this.sigma);
            }
        }
        for (int d = 0; d < this.n; ++d) {
            double[] inner = new double[this.k];
            double[] expInner = new double[this.k];
            double sumExpInner = 0.0;
            for (int k2 = 0; k2 < this.k; ++k2) {
                for (int f2 = 0; f2 < this.f; ++f2) {
                    int n = k2;
                    inner[n] = inner[n] + this.documentFeatures[d][f2] * this.parameters[k2][f2];
                }
                expInner[k2] = Math.exp(inner[k2]);
                sumExpInner += expInner[k2];
            }
            L += Gamma.logGamma(sumExpInner) - Gamma.logGamma(sumExpInner + (double)this.n_d[d]);
            for (int t = 0; t < this.k; ++t) {
                L += Gamma.logGamma(expInner[t] + (double)this.n_td[d * this.k + t]) - Gamma.logGamma(expInner[t]);
            }
        }
        return -L / (double)this.n;
    }
}

