/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.kobra.topicmodels;

import cc.mallet.optimize.Optimizable;
import gnu.trove.list.array.TIntArrayList;
import org.apache.commons.math3.special.Gamma;

public class LogWordFeatOptimizable
implements Optimizable.ByGradientValue {
    int k = 10;
    int v = 1928;
    double[][] parameters = null;
    double[] b = null;
    double[][] documentFeatures = null;
    public TIntArrayList[] Phi;
    double lambda = 1.0;
    public int[] n_k;
    public int[] n_kv;

    public LogWordFeatOptimizable(int k, int v) {
        this.k = k;
        this.v = v;
        this.parameters = new double[k + 1][v];
        for (int i = 0; i < k + 1; ++i) {
            for (int j = 0; j < v; ++j) {
                this.parameters[i][j] = 2.0 * Math.random() - 1.0;
            }
        }
    }

    @Override
    public int getNumParameters() {
        return (this.k + 1) * this.v;
    }

    @Override
    public void getParameters(double[] buffer) {
        for (int i = 0; i < this.k + 1; ++i) {
            for (int j = 0; j < this.v; ++j) {
                buffer[i * this.v + j] = this.parameters[i][j];
            }
        }
    }

    @Override
    public double getParameter(int index) {
        return this.parameters[index / this.v][index % this.v];
    }

    @Override
    public void setParameters(double[] params) {
        for (int i = 0; i < this.k + 1; ++i) {
            for (int j = 0; j < this.v; ++j) {
                this.parameters[i][j] = params[i * this.v + j];
            }
        }
    }

    @Override
    public void setParameter(int index, double value) {
        this.parameters[index / this.v][index % this.v] = value;
    }

    @Override
    public void getValueGradient(double[] buffer) {
        int i;
        int j;
        double L = 0.0;
        for (int i2 = 0; i2 < buffer.length; ++i2) {
            buffer[i2] = 0.0;
        }
        for (j = 0; j < this.v; ++j) {
            buffer[this.k * this.v + j] = this.parameters[this.k][j] / (this.lambda * this.lambda);
        }
        if (this.Phi != null) {
            for (j = 0; j < this.v; ++j) {
                if (this.Phi[j] == null) continue;
                for (i = 0; i < this.k; ++i) {
                    for (int h = 0; h < this.Phi[j].size(); ++h) {
                        int n = i * this.v + j;
                        buffer[n] = buffer[n] + 1.0 / (this.lambda * this.lambda) * (this.parameters[i][j] - this.parameters[i][this.Phi[j].get(h)]);
                    }
                }
            }
        }
        double[] sumBetas = new double[this.k];
        for (i = 0; i < this.k; ++i) {
            for (int j2 = 0; j2 < this.v; ++j2) {
                int n = i;
                sumBetas[n] = sumBetas[n] + Math.exp(this.parameters[i][j2] + this.parameters[this.k][j2]);
            }
        }
        double res = 0.0;
        for (int j3 = 0; j3 < this.v; ++j3) {
            double tmp = 0.0;
            for (int i3 = 0; i3 < this.k; ++i3) {
                tmp += Gamma.digamma(sumBetas[i3] + (double)this.n_k[i3]) - Gamma.digamma(sumBetas[i3]);
                if (this.Phi != null) {
                    int n = i3 * this.v + j3;
                    buffer[n] = buffer[n] + (Gamma.digamma(sumBetas[i3] + (double)this.n_k[i3]) - Gamma.digamma(sumBetas[i3]));
                }
                if (this.n_kv[j3 * this.k + i3] <= 0) continue;
                if (this.Phi != null) {
                    int n = i3 * this.v + j3;
                    buffer[n] = buffer[n] + (Gamma.digamma(Math.exp(this.parameters[i3][j3] + this.parameters[this.k][j3])) - Gamma.digamma(Math.exp(this.parameters[i3][j3] + this.parameters[this.k][j3]) + (double)this.n_kv[j3 * this.k + i3]));
                }
                tmp += Gamma.digamma(Math.exp(this.parameters[i3][j3] + this.parameters[this.k][j3])) - Gamma.digamma(Math.exp(this.parameters[i3][j3] + this.parameters[this.k][j3]) + (double)this.n_kv[j3 * this.k + i3]);
            }
            int n = this.k * this.v + j3;
            buffer[n] = buffer[n] + Math.exp(this.parameters[this.k][j3]) * tmp;
        }
        for (int i4 = 0; i4 < buffer.length; ++i4) {
            buffer[i4] = -buffer[i4];
        }
    }

    @Override
    public double getValue() {
        int j;
        int i;
        double res = 0.0;
        if (this.Phi != null) {
            for (int j2 = 0; j2 < this.v; ++j2) {
                if (this.Phi[j2] == null) continue;
                for (int h = 0; h < this.Phi[j2].size(); ++h) {
                    for (i = 0; i < this.k; ++i) {
                        res += Math.pow(this.parameters[i][j2] - this.parameters[i][this.Phi[j2].get(h)], 2.0);
                    }
                }
            }
        }
        for (int i2 = 0; i2 < this.v; ++i2) {
            res += Math.pow(this.parameters[this.k][i2], 2.0);
        }
        res = -res / (2.0 * this.lambda * this.lambda);
        double L = 0.0;
        for (i = 0; i < this.k; ++i) {
            double tmp = 0.0;
            for (j = 0; j < this.v; ++j) {
                tmp += Math.exp(this.parameters[i][j] + this.parameters[this.k][j]);
            }
            L += Gamma.logGamma(tmp + (double)this.n_k[i]) - Gamma.logGamma(tmp);
        }
        double sumProd = 0.0;
        for (int i3 = 0; i3 < this.k; ++i3) {
            for (j = 0; j < this.v; ++j) {
                double tmp = 0.0;
                if (this.n_kv[j * this.k + i3] > 0) {
                    tmp += Gamma.logGamma(Math.exp(this.parameters[i3][j] + this.parameters[this.k][j])) - Gamma.logGamma(Math.exp(this.parameters[i3][j] + this.parameters[this.k][j]) + (double)this.n_kv[j * this.k + i3]);
                }
                sumProd += tmp;
            }
        }
        return -1.0 * (L + sumProd - res);
    }
}

