/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.kobra.topicmodels;

import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SimpleExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DataRowFactory;
import com.rapidminer.example.table.ExampleTable;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.kobra.data.CCSMatrix;
import com.rapidminer.kobra.topicmodels.SamplersLDAGroupWordFeatures;
import com.rapidminer.kobra.topicmodels.SamplersLDAMyWordFeatures;
import com.rapidminer.kobra.topicmodels.SamplersLDAWordFeatures;
import com.rapidminer.kobra.topicmodels.SamplersLDAWordRegularize;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDirectory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.RandomGenerator;
import gnu.trove.TIntHashSet;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntIntHashMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.DiagonalMatrix;
import org.apache.commons.math3.linear.EigenDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import weka.clusterers.SimpleKMeans;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public class LDAWordFeaturesOperator
extends Operator {
    static String PARAMETER_NUMITERATIONS = "iterations";
    static String PARAMETER_NUMTOPICS = "number_of_topics";
    static String PARAMETER_ALPHA = "alpha";
    static String PARAMETER_BETA = "beta";
    static String PARAMETER_GROUP = "group";
    static String PARAMETER_LAMBDA = "lambda";
    static String PARAMETER_GAMMA = "gamma";
    static String PARAMETER_REG = "regularization";
    static String PARAMETER_REG_TM = "regularized topic model";
    static String PARAMETER_SIMPRIOR_TM = "similarity prior topic model";
    static String PARAMETER_WORD_PROB = "word probabilities";
    static String PARAMETER_WORD_GROUP = "word grouping";
    static String PARAMETER_NUM_WORG_GROUPS = "number of word groups";
    static String PARAMETER_A = "a";
    static String PARAMETER_PROXIMAL = "use proximal operator";
    static String PARAMETER_DFR = "dfr";
    static String PARAMETER_PATH = "path";
    String path = "/home/poelitz/work/Datasets/ResultData/acl2015/";
    static String PARAMETER_METHODS = "methods";
    static String[] methods = new String[]{"LDA", "LDA Word Features Grouped Lasso", "LDA Word Features l1", "Regularized Topic Model", "Word Features LDA", "Mallet LDA", "TM with Paschinko Allocation", "Paschinko Allocation with Time"};
    static int LDA = 0;
    static int LDAGroup = 1;
    static int LDAL1 = 2;
    static int RegLDA = 3;
    static int WordLDA = 4;
    static int MalletLDA = 5;
    static int PaschinkoLDA = 6;
    static int PaschinkoTime = 7;
    int iters = 2000;
    int numTopics = 4;
    double alpha = 0.25;
    double beta = 0.1;
    double lambda = 0.1;
    private final InputPort input = (InputPort)this.getInputPorts().createPort("example set of documents as Bag-of-Words vectors with term occurrences");
    private final InputPort inputGroup = (InputPort)this.getInputPorts().createPort("example set of groups for each document (optional)");
    private final InputPort inputWords = (InputPort)this.getInputPorts().createPort("example set of word adjacency matrix for word correlations");
    private final InputPort inputWordProbs = (InputPort)this.getInputPorts().createPort("example set of word probabilities");
    private final OutputPort outputWords = (OutputPort)this.getOutputPorts().createPort("example set of word distributions for the topics");
    private final OutputPort outputDocs = (OutputPort)this.getOutputPorts().createPort("example set of topic distributions for the documents");
    private final OutputPort outputWordsCounts = (OutputPort)this.getOutputPorts().createPort("example set of word topics assignments");
    private final OutputPort outputTopicCounts = (OutputPort)this.getOutputPorts().createPort("example set of counts of topics");
    int topK = 40;

    public LDAWordFeaturesOperator(OperatorDescription description) {
        super(description);
    }

    public void doWork() throws OperatorException {
        int i;
        int i2;
        ExampleSet wordProbs;
        boolean locSeed = this.getParameterAsBoolean("use_local_random_seed");
        int seed = this.getParameterAsInt("local_random_seed");
        this.iters = this.getParameterAsInt(PARAMETER_NUMITERATIONS);
        this.numTopics = this.getParameterAsInt(PARAMETER_NUMTOPICS);
        this.alpha = this.getParameterAsDouble(PARAMETER_ALPHA);
        this.beta = this.getParameterAsDouble(PARAMETER_BETA);
        this.lambda = this.getParameterAsDouble(PARAMETER_LAMBDA);
        double a = this.getParameterAsDouble(PARAMETER_A);
        double gamma = this.getParameterAsDouble(PARAMETER_GAMMA);
        boolean doReg = this.getParameterAsBoolean(PARAMETER_REG);
        boolean wordprobs = this.getParameterAsBoolean(PARAMETER_WORD_PROB);
        boolean prox = this.getParameterAsBoolean(PARAMETER_PROXIMAL);
        this.path = this.getParameterAsString(PARAMETER_PATH);
        int m = this.getParameterAsInt(PARAMETER_METHODS);
        TIntArrayList wordToken = new TIntArrayList();
        TIntArrayList docToken = new TIntArrayList();
        int numWords = 0;
        ExampleSet exampleSet = (ExampleSet)this.input.getData(ExampleSet.class);
        Example ex = exampleSet.getExample(0);
        Attributes attr = ex.getAttributes();
        numWords = attr.size();
        String[] words = new String[numWords];
        HashMap<String, Integer> word_map = new HashMap<String, Integer>();
        for (int i3 = 0; i3 < exampleSet.size(); ++i3) {
            int docId = i3;
            ex = exampleSet.getExample(i3);
            attr = ex.getAttributes();
            boolean nextAtt = false;
            int j = 0;
            for (com.rapidminer.example.Attribute att : attr) {
                words[j] = att.getName();
                if (!word_map.containsKey(words[j])) {
                    word_map.put(words[j], j);
                }
                int wordId = j++;
                double frequ = 0.0;
                frequ = ex.getValue(att);
                if (frequ == 0.0) continue;
                for (int k = 0; k < (int)frequ; ++k) {
                    docToken.add(docId);
                    wordToken.add(wordId);
                }
            }
        }
        TIntArrayList[] graph = new TIntArrayList[numWords];
        TDoubleArrayList[] graphWeights = new TDoubleArrayList[numWords];
        ExampleSet wordNeigh = (ExampleSet)this.inputWords.getDataOrNull(ExampleSet.class);
        double[] p_v = null;
        double norm_p_v = 0.0;
        double Z = 0.0;
        p_v = new double[numWords];
        for (int i4 = 0; i4 < p_v.length; ++i4) {
            p_v[i4] = this.beta;
        }
        double minWeight = 1.0;
        if (wordNeigh != null) {
            int j;
            int i5;
            p_v = new double[numWords];
            for (i5 = 0; i5 < wordNeigh.size(); ++i5) {
                graphWeights[i5] = new TDoubleArrayList();
                graph[i5] = new TIntArrayList();
                ex = wordNeigh.getExample(i5);
                attr = ex.getAttributes();
                j = 0;
                for (com.rapidminer.example.Attribute att : attr) {
                    double frequ = 0.0;
                    frequ = ex.getValue(att);
                    if (frequ != 0.0) {
                        graph[i5].add(j);
                        graphWeights[i5].add(frequ);
                        Z += frequ;
                        int n = i5;
                        p_v[n] = p_v[n] + frequ;
                    }
                    ++j;
                }
                p_v[i5] = 1.0 / (1.0 + Math.exp(-p_v[i5]));
                norm_p_v += p_v[i5];
            }
            i5 = 0;
            while (i5 < p_v.length) {
                int n = i5;
                p_v[n] = p_v[n] / norm_p_v;
                int n2 = i5++;
                p_v[n2] = p_v[n2] * (this.beta * (double)p_v.length);
            }
            for (i5 = 0; i5 < graphWeights.length; ++i5) {
                for (j = 0; j < graphWeights[i5].size(); ++j) {
                    if (m == LDAGroup) {
                        graphWeights[i5].set(j, 1.0 / graphWeights[i5].get(j));
                    } else if (m == RegLDA) {
                        graphWeights[i5].set(j, graphWeights[i5].get(j));
                    } else {
                        graphWeights[i5].set(j, graphWeights[i5].get(j) / Z);
                    }
                    if (!(graphWeights[i5].get(j) < minWeight) || graphWeights[i5].get(j) == 0.0) continue;
                    minWeight = graphWeights[i5].get(j);
                }
            }
        }
        if ((wordProbs = (ExampleSet)this.inputWordProbs.getDataOrNull()) != null) {
            int i6;
            norm_p_v = 0.0;
            for (i6 = 0; i6 < wordProbs.size(); ++i6) {
                Example e = wordProbs.getExample(i6);
                com.rapidminer.example.Attribute a1 = e.getAttributes().get("word");
                com.rapidminer.example.Attribute a2 = e.getAttributes().get("total");
                String w = e.getNominalValue(a1);
                int id = i6;
                if (!word_map.containsKey(w)) continue;
                id = (Integer)word_map.get(w);
                p_v[id] = e.getValue(a2);
                norm_p_v += p_v[id];
            }
            i6 = 0;
            while (i6 < p_v.length) {
                int n = i6;
                p_v[n] = p_v[n] / norm_p_v;
                int n3 = i6++;
                p_v[n3] = p_v[n3] * (this.beta * (double)p_v.length);
            }
        }
        int[] clusters = null;
        double sigma = 0.5;
        if (m == LDAGroup) {
            int i7;
            Instance in;
            int j;
            int i8;
            minWeight /= 10.0;
            double[] rowSums = new double[graphWeights.length];
            Array2DRowRealMatrix M = new Array2DRowRealMatrix(graphWeights.length, graphWeights.length);
            for (i8 = 0; i8 < graphWeights.length; ++i8) {
                int j2;
                for (j2 = 0; j2 < graphWeights.length; ++j2) {
                    M.setEntry(i8, j2, 1.0);
                    int n = i8;
                    rowSums[n] = rowSums[n] + M.getEntry(i8, j2);
                }
                for (j2 = 0; j2 < graphWeights[i8].size(); ++j2) {
                    if (i8 == graph[i8].get(j2)) continue;
                    M.setEntry(i8, graph[i8].get(j2), Math.exp(-Math.pow(graphWeights[i8].get(j2), 2.0) / (2.0 * sigma)));
                    int n = i8;
                    rowSums[n] = rowSums[n] - 1.0;
                    int n4 = i8;
                    rowSums[n4] = rowSums[n4] + M.getEntry(i8, j2);
                }
                M.setEntry(i8, i8, 0.0);
            }
            for (i8 = 0; i8 < graphWeights.length; ++i8) {
                rowSums[i8] = 1.0 / Math.sqrt(rowSums[i8]);
            }
            DiagonalMatrix D = new DiagonalMatrix(rowSums);
            double[] diag = new double[graphWeights.length];
            for (int i9 = 0; i9 < graphWeights.length; ++i9) {
                diag[i9] = 0.01;
            }
            RealMatrix L = D.multiply(M).multiply(D);
            L = L.add(new DiagonalMatrix(diag));
            EigenDecomposition eig = new EigenDecomposition(L);
            RealMatrix U = eig.getV();
            RealMatrix E = eig.getD();
            SimpleKMeans kmeans = new SimpleKMeans();
            int dim = this.getParameterAsInt(PARAMETER_NUM_WORG_GROUPS);
            ArrayList<Attribute> ls = new ArrayList<Attribute>();
            for (int i10 = 0; i10 < dim; ++i10) {
                ls.add(new Attribute("att" + i10));
            }
            Instances insts = new Instances("data", ls, p_v.length);
            double[] rowsums = new double[p_v.length];
            for (j = 0; j < p_v.length; ++j) {
                in = new DenseInstance(dim);
                for (i7 = 0; i7 < dim; ++i7) {
                    in.setValue(i7, U.getEntry(j, i7));
                    int n = j;
                    rowsums[n] = rowsums[n] + U.getEntry(j, i7) * U.getEntry(j, i7);
                }
                insts.add(in);
            }
            for (j = 0; j < p_v.length; ++j) {
                in = insts.get(j);
                for (i7 = 0; i7 < dim; ++i7) {
                    in.setValue(i7, U.getEntry(j, i7) / Math.sqrt(rowsums[j]));
                }
            }
            try {
                kmeans.setNumClusters(dim);
                kmeans.setPreserveInstancesOrder(true);
                kmeans.buildClusterer(insts);
                clusters = kmeans.getAssignments();
                this.writeClusters(words, clusters);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        SamplersLDAWordFeatures sampler = new SamplersLDAWordFeatures();
        if (m == WordLDA) {
            sampler = new SamplersLDAMyWordFeatures();
        }
        if (m == RegLDA) {
            sampler = new SamplersLDAWordRegularize();
            ((SamplersLDAWordRegularize)sampler).graphWeights = graphWeights;
            ((SamplersLDAWordRegularize)sampler).Phi = graph;
            ((SamplersLDAWordRegularize)sampler).LAMBDA = this.lambda;
            ((SamplersLDAWordRegularize)sampler).GAMMA = gamma;
            ((SamplersLDAWordRegularize)sampler).nu = this.lambda;
        }
        if (m == LDAGroup) {
            int i11;
            sampler = new SamplersLDAGroupWordFeatures();
            ((SamplersLDAGroupWordFeatures)sampler).prox = prox;
            Object groups = null;
            TIntHashSet set = new TIntHashSet();
            TIntIntHashMap map = new TIntIntHashMap();
            for (int i12 = 0; i12 < clusters.length; ++i12) {
                set.add((int)clusters[i12]);
                if (!map.contains((int)clusters[i12])) {
                    map.put((int)clusters[i12], 0);
                }
                map.put((int)clusters[i12], map.get((int)clusters[i12]) + 1);
            }
            groups = new int[set.size()][];
            TIntArrayList[] array = new TIntArrayList[set.size()];
            for (i11 = 0; i11 < clusters.length; ++i11) {
                if (array[clusters[i11]] == null) {
                    array[clusters[i11]] = new TIntArrayList();
                }
                array[clusters[i11]].add(i11);
            }
            for (i11 = 0; i11 < set.size(); ++i11) {
                groups[i11] = array[i11].toArray();
            }
            ((SamplersLDAGroupWordFeatures)sampler).groups = groups;
            ((SamplersLDAGroupWordFeatures)sampler).a = a;
        }
        sampler.setReg(doReg);
        if (wordprobs) {
            sampler.p_v = p_v;
        }
        sampler.Phi = graph;
        sampler.LAMBDA = this.lambda;
        sampler.GAMMA = gamma;
        for (int i13 = 0; i13 < 1; ++i13) {
            sampler.init(docToken.toArray(), wordToken.toArray(), this.numTopics, numWords, exampleSet.size(), this.iters, this.beta, this.alpha, locSeed, seed);
            sampler.GibbsSampling();
        }
        double[][] probs = sampler.documentDistribution();
        boolean dfr = this.getParameterAsBoolean(PARAMETER_DFR);
        if (dfr) {
            this.writeDT(probs);
        }
        ArrayList<com.rapidminer.example.Attribute> attributeList = new ArrayList<com.rapidminer.example.Attribute>();
        attributeList.add(AttributeFactory.createAttribute((String)"Doc", (int)2));
        attributeList.add(AttributeFactory.createAttribute((String)"Topic", (int)2));
        for (int i14 = 0; i14 < this.numTopics; ++i14) {
            attributeList.add(AttributeFactory.createAttribute((String)("Topic_" + i14), (int)2));
        }
        MemoryExampleTable table = new MemoryExampleTable(attributeList);
        DataRowFactory factory = new DataRowFactory(0, '.');
        TIntArrayList assTop = new TIntArrayList();
        TDoubleArrayList probTop = new TDoubleArrayList();
        for (int i15 = 0; i15 < exampleSet.size(); ++i15) {
            DataRow row = factory.create(table.getNumberOfAttributes());
            table.addDataRow(row);
            row.set((com.rapidminer.example.Attribute)attributeList.get(0), (double)(i15 + 1));
            int top = -1;
            double max = 0.0;
            for (int j = 0; j < this.numTopics; ++j) {
                if (probs[j][i15] > max) {
                    max = probs[j][i15];
                    top = j;
                }
                row.set((com.rapidminer.example.Attribute)attributeList.get(2 + j), probs[j][i15]);
            }
            probTop.add(max);
            assTop.add(top);
            row.set((com.rapidminer.example.Attribute)attributeList.get(1), (double)top);
        }
        SimpleExampleSet set = new SimpleExampleSet((ExampleTable)table);
        this.outputDocs.deliver((IOObject)set);
        probs = sampler.wordDistribution();
        if (dfr) {
            this.writeTW(words, probs, this.alpha);
            this.writeTopWords(words, probs);
        }
        double[][] betas = sampler.getBetas();
        attributeList = new ArrayList();
        attributeList.add(AttributeFactory.createAttribute((String)"Word", (int)5));
        attributeList.add(AttributeFactory.createAttribute((String)"Word_id", (int)2));
        attributeList.add(AttributeFactory.createAttribute((String)"Topic", (int)2));
        for (i2 = 0; i2 < this.numTopics; ++i2) {
            attributeList.add(AttributeFactory.createAttribute((String)("Topic_" + i2), (int)2));
        }
        for (i2 = 0; i2 < this.numTopics; ++i2) {
            attributeList.add(AttributeFactory.createAttribute((String)("Betas_" + i2), (int)2));
        }
        if (m == LDAGroup) {
            attributeList.add(AttributeFactory.createAttribute((String)"cluster", (int)2));
            attributeList.add(AttributeFactory.createAttribute((String)"p(w)", (int)2));
        }
        table = new MemoryExampleTable(attributeList);
        factory = new DataRowFactory(0, '.');
        for (i2 = 0; i2 < numWords; ++i2) {
            DataRow row = factory.create(table.getNumberOfAttributes());
            table.addDataRow(row);
            row.set((com.rapidminer.example.Attribute)attributeList.get(0), (double)((com.rapidminer.example.Attribute)attributeList.get(0)).getMapping().mapString(words[i2]));
            row.set((com.rapidminer.example.Attribute)attributeList.get(1), (double)(i2 + 1));
            int top = -1;
            double max = 0.0;
            for (int j = 0; j < this.numTopics; ++j) {
                if (probs[j][i2] > max) {
                    max = probs[j][i2];
                    top = j;
                }
                row.set((com.rapidminer.example.Attribute)attributeList.get(3 + j), probs[j][i2]);
                row.set((com.rapidminer.example.Attribute)attributeList.get(3 + this.numTopics + j), betas[j][i2]);
            }
            row.set((com.rapidminer.example.Attribute)attributeList.get(2), (double)top);
            if (m != LDAGroup) continue;
            row.set((com.rapidminer.example.Attribute)attributeList.get(attributeList.size() - 2), (double)clusters[i2]);
            row.set((com.rapidminer.example.Attribute)attributeList.get(attributeList.size() - 1), p_v[i2]);
        }
        set = new SimpleExampleSet((ExampleTable)table);
        this.outputWords.deliver((IOObject)set);
        int[][] wt = sampler.getWordTopicCounts();
        attributeList = new ArrayList();
        attributeList.add(AttributeFactory.createAttribute((String)"Word", (int)5));
        attributeList.add(AttributeFactory.createAttribute((String)"Word_id", (int)2));
        for (i = 0; i < this.numTopics; ++i) {
            attributeList.add(AttributeFactory.createAttribute((String)("Topic_" + i), (int)2));
        }
        table = new MemoryExampleTable(attributeList);
        factory = new DataRowFactory(0, '.');
        for (i = 0; i < numWords; ++i) {
            DataRow row = factory.create(table.getNumberOfAttributes());
            table.addDataRow(row);
            row.set((com.rapidminer.example.Attribute)attributeList.get(0), (double)((com.rapidminer.example.Attribute)attributeList.get(0)).getMapping().mapString(words[i]));
            row.set((com.rapidminer.example.Attribute)attributeList.get(1), (double)(i + 1));
            int top = -1;
            double max = 0.0;
            for (int j = 0; j < this.numTopics; ++j) {
                if (probs[j][i] > max) {
                    max = probs[j][i];
                    top = j;
                }
                row.set((com.rapidminer.example.Attribute)attributeList.get(2 + j), (double)wt[j][i]);
            }
        }
        set = new SimpleExampleSet((ExampleTable)table);
        this.outputWordsCounts.deliver((IOObject)set);
        int[] t = sampler.getTopicCounts();
        attributeList = new ArrayList();
        for (int i16 = 0; i16 < this.numTopics; ++i16) {
            attributeList.add(AttributeFactory.createAttribute((String)("Topic_" + i16), (int)2));
        }
        table = new MemoryExampleTable(attributeList);
        factory = new DataRowFactory(0, '.');
        DataRow row = factory.create(table.getNumberOfAttributes());
        for (int j = 0; j < this.numTopics; ++j) {
            row.set((com.rapidminer.example.Attribute)attributeList.get(j), (double)t[j]);
        }
        table.addDataRow(row);
        set = new SimpleExampleSet((ExampleTable)table);
        this.outputTopicCounts.deliver((IOObject)set);
    }

    public void writeDT(int[] topics, double[] pr) {
        String r = "{";
        String i = "\"i\":[" + topics[0];
        String p = "\"p\":[0";
        String x = "\"x\":[" + pr[0];
        for (int d = 1; d < topics.length; ++d) {
            i = i + "," + topics[d];
            p = p + "," + d;
            x = x + "," + (int)(pr[d] * 1000.0);
        }
        r = r + i + "]," + p + "]," + x + "]}";
        System.out.println(r);
    }

    public void writeDT(double[][] td) {
        double[][] dt = new double[td[0].length][td.length];
        for (int i = 0; i < dt.length; ++i) {
            for (int j = 0; j < dt[i].length; ++j) {
                dt[i][j] = (int)(td[j][i] * 100.0);
            }
        }
        CCSMatrix ma = CCSMatrix.from2DArray(dt);
        int[] cp = ma.columnPointers;
        int[] ri = ma.rowIndices;
        double[] v = ma.values;
        String file = this.path + "dt.json";
        String r = "{";
        String i = "\"i\": [" + ri[0] + " ";
        for (int ind = 1; ind < ri.length; ++ind) {
            i = i + ", " + ri[ind];
        }
        String p = "\"p\": [" + cp[0] + " ";
        for (int poi = 1; poi < cp.length; ++poi) {
            p = p + ", " + cp[poi];
        }
        String x = "\"x\": [" + (int)v[0] + " ";
        for (int val = 1; val < v.length; ++val) {
            x = x + ", " + (int)v[val];
        }
        r = r + i + "]," + p + "]," + x + "]}";
        this.writeAndZip(r, file);
    }

    public void writeAndZip(String r, String file) {
        Writer bw = null;
        try {
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            bw.write(r);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            ((BufferedWriter)bw).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            int count;
            BufferedInputStream origin = null;
            FileOutputStream dest = new FileOutputStream(file + ".zip");
            ZipOutputStream out2 = new ZipOutputStream(new BufferedOutputStream(dest));
            byte[] data = new byte[2048];
            FileInputStream fi = new FileInputStream(file);
            origin = new BufferedInputStream(fi, 2048);
            ZipEntry entry = new ZipEntry(file.substring(file.lastIndexOf("/") + 1, file.length()));
            out2.putNextEntry(entry);
            while ((count = origin.read(data, 0, 2048)) != -1) {
                out2.write(data, 0, count);
            }
            origin.close();
            out2.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeTopWords(String[] words, double[][] tw) {
        int t;
        Word[][] myWords = new Word[tw.length][tw[0].length];
        for (t = 0; t < tw.length; ++t) {
            for (int i = 0; i < tw[t].length; ++i) {
                Word w = new Word();
                w.id = i;
                w.weight = tw[t][i];
                w.word = words[i];
                myWords[t][i] = w;
            }
        }
        for (t = 0; t < tw.length; ++t) {
            Object[] tmp = myWords[t];
            Arrays.sort(tmp);
        }
        try {
            PrintStream ps = new PrintStream((OutputStream)new FileOutputStream(this.path + "topWords.txt", false), true, "UTF-8");
            System.setOut(ps);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < this.topK && i < words.length; ++i) {
            String next = "";
            for (int t2 = 0; t2 < tw.length; ++t2) {
                next = next + t2 + "," + myWords[t2][i].toString() + ",";
            }
            System.out.println(next);
        }
        System.setOut(System.out);
    }

    public void writeClusters(String[] words, int[] clusters) {
        Object[] myWords = new Word[words.length];
        for (int i = 0; i < words.length; ++i) {
            Word w = new Word();
            w.id = i;
            w.weight = clusters[i];
            w.word = words[i];
            myWords[i] = w;
        }
        Arrays.sort(myWords);
        try {
            PrintStream ps = new PrintStream((OutputStream)new FileOutputStream(this.path + "clusters.txt", false), true, "UTF-8");
            System.setOut(ps);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < myWords.length; ++i) {
            System.out.println(((Word)myWords[i]).toString());
        }
        System.setOut(System.out);
    }

    public void writeTW(String[] words, double[][] tw, double alpha) {
        int t;
        String twS = "\"tw\":[";
        String alphaS = "{\"alpha\":[" + alpha;
        for (t = 1; t < tw.length; ++t) {
            alphaS = alphaS + "," + alpha;
        }
        for (t = 0; t < tw.length; ++t) {
            double[] w = new double[tw[t].length];
            for (int i = 0; i < tw[t].length; ++i) {
                w[i] = tw[t][i];
            }
            Arrays.sort(w);
            if (this.topK >= w.length) {
                // empty if block
            }
            double min = w[w.length - this.topK];
            String wordsS = "\"words\":[";
            String weightsS = "{\"weights\":[";
            for (int i = 0; i < tw[t].length; ++i) {
                if (!(tw[t][i] >= min)) continue;
                wordsS = wordsS + "\"" + words[i] + "\",";
                weightsS = weightsS + tw[t][i] + ",";
            }
            wordsS = wordsS.substring(0, wordsS.length() - 1);
            wordsS = wordsS + "]}";
            weightsS = weightsS.substring(0, weightsS.length() - 1);
            weightsS = weightsS + "],";
            twS = twS + weightsS + wordsS + ",";
        }
        alphaS = alphaS + "],";
        twS = twS.substring(0, twS.length() - 1);
        String r = alphaS + twS + "]}";
        String file = this.path + "tw.json";
        this.writeAndZip(r, file);
    }

    public void writeMeta() {
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeInt(PARAMETER_NUMITERATIONS, "Number of Iterations for Gibbs Sampling.", 1, Integer.MAX_VALUE, 2000));
        types.add(new ParameterTypeInt(PARAMETER_NUMTOPICS, "Number of Topics.", 1, Integer.MAX_VALUE, 5));
        types.add(new ParameterTypeDouble(PARAMETER_ALPHA, "Alpha metaparameter for Dirichlet", 0.0, Double.MAX_VALUE, 0.25));
        types.add(new ParameterTypeDouble(PARAMETER_BETA, "Beta metaparameter for Dirichlet", 0.0, Double.MAX_VALUE, 0.1));
        types.add(new ParameterTypeDouble(PARAMETER_LAMBDA, "Lambda: variance of weights for word feature", 0.0, Double.MAX_VALUE, 0.1));
        types.add(new ParameterTypeDouble(PARAMETER_GAMMA, "Gamma: l1 weight for regularization", 0.0, Double.MAX_VALUE, 0.1));
        types.add(new ParameterTypeInt(PARAMETER_NUM_WORG_GROUPS, "Number of word groups for group lasso.", 1, Integer.MAX_VALUE, 20));
        types.add(new ParameterTypeDouble(PARAMETER_A, "a: weight for group lasso", 0.0, Double.MAX_VALUE, 0.5));
        ParameterTypeCategory type = new ParameterTypeCategory(PARAMETER_METHODS, "The type of the kernel.", methods, LDAGroup);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeString(PARAMETER_GROUP, "Attribute name for grouping the word counts."));
        types.add(new ParameterTypeBoolean(PARAMETER_REG, "Specifies whether to use l1 regularization on parameter of prior.", false, false));
        types.add(new ParameterTypeBoolean(PARAMETER_WORD_PROB, "Use external data for word probs.", false, false));
        types.add(new ParameterTypeBoolean(PARAMETER_PROXIMAL, "Use proximal operator for group lasso.", false, false));
        types.add(new ParameterTypeBoolean(PARAMETER_DFR, "Write results out for dfr browser", true, false));
        types.add(new ParameterTypeDirectory(PARAMETER_PATH, "Path for dfr files.", "/home/poelitz/work/Datasets/ResultData/acl2015/"));
        types.addAll(RandomGenerator.getRandomGeneratorParameters((Operator)this));
        return types;
    }

    public static void main(String[] args) {
    }

    class Word
    implements Comparable<Word> {
        public String word = "";
        public double weight = 0.0;
        public int id = -1;

        Word() {
        }

        @Override
        public int compareTo(Word o) {
            if (this.weight == o.weight) {
                return -this.word.compareTo(o.word);
            }
            return this.weight < o.weight ? 1 : -1;
        }

        public String toString() {
            return this.word + "," + this.weight;
        }
    }
}

