/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.kobra.topicmodels;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SimpleExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DataRowFactory;
import com.rapidminer.example.table.ExampleTable;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.kobra.topicmodels.LDABaseOperator;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDirectory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.RandomGenerator;
import gnu.trove.list.array.TIntArrayList;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.output.FileWriterWithEncoding;

public class LDAPythonOperator
extends LDABaseOperator {
    static String PARAMETER_BETA = "beta";
    static String SCRIPT_PATH = "script";
    static String PATH_DATA = "data_path";
    static String PARAMETER_TEXT = "text attribute";
    static String PARAMETER_SUPER = "supervised";
    public static final String PARAMETER_ENCODING = "encoding";
    public static final String[] ENCODINGS = new String[]{"US-ASCII", "ISO-8859-1", "UTF-8", "UTF-16"};
    double beta = 0.1;
    protected final InputPort inputTest = (InputPort)this.getInputPorts().createPort("example set of documents as Bag-of-Words vectors with term occurrences for test");
    protected final OutputPort predictionOutput = (OutputPort)this.getOutputPorts().createPort("example set of predictions for the test documents");

    public LDAPythonOperator(OperatorDescription description) {
        super(description);
    }

    public void doWork() throws OperatorException {
        int i;
        boolean locSeed = this.getParameterAsBoolean("use_local_random_seed");
        int seed = this.getParameterAsInt("local_random_seed");
        this.iters = this.getParameterAsInt(PARAMETER_NUMITERATIONS);
        this.numTopics = this.getParameterAsInt(PARAMETER_NUMTOPICS);
        this.alpha = this.getParameterAsDouble(PARAMETER_ALPHA);
        this.beta = this.getParameterAsDouble(PARAMETER_BETA);
        this.path = this.getParameter(PARAMETER_PATH);
        String encode = this.getParameterAsString(PARAMETER_ENCODING);
        String path_data = this.getParameterAsString(PATH_DATA);
        boolean supervised = this.getParameterAsBoolean(PARAMETER_SUPER);
        boolean bow = true;
        String t_att = "";
        try {
            t_att = this.getParameterAsString(PARAMETER_TEXT);
        }
        catch (Exception e) {
            // empty catch block
        }
        TIntArrayList wordToken = new TIntArrayList();
        TIntArrayList docToken = new TIntArrayList();
        int numWords = 0;
        ExampleSet exampleSet = (ExampleSet)this.input.getDataOrNull(ExampleSet.class);
        if (exampleSet != null) {
            Example ex = exampleSet.getExample(0);
            Attributes attr = ex.getAttributes();
            numWords = attr.size();
            String[] words = new String[numWords];
            double[] labels = null;
            if (attr.getLabel() != null) {
                labels = new double[exampleSet.size()];
            }
            int[] doc_lengths = new int[exampleSet.size()];
            BufferedWriter wr = null;
            BufferedWriter wr_labels = null;
            try {
                wr = new BufferedWriter(new FileWriterWithEncoding(path_data + "/texts.csv", encode));
                wr_labels = new BufferedWriter(new FileWriter(path_data + "/labels.csv"));
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            ex = exampleSet.getExample(0);
            attr = ex.getAttributes();
            for (Attribute att : attr) {
                if (!Ontology.ATTRIBUTE_VALUE_TYPE.isA(att.getValueType(), 5)) continue;
                bow = false;
            }
            for (int i2 = 0; i2 < exampleSet.size(); ++i2) {
                String next = "";
                ex = exampleSet.getExample(i2);
                attr = ex.getAttributes();
                if (bow) {
                    for (Attribute att : attr) {
                        if (ex.getValue(att) == 0.0) continue;
                        int mult = (int)ex.getValue(att);
                        for (int m = 0; m < mult; ++m) {
                            next = att.getName().equals("text_0") ? next + "text " : next + att.getName() + " ";
                        }
                    }
                    if (next.length() == 0) {
                        next = "?";
                    }
                } else {
                    for (Attribute att : attr) {
                        if (!Ontology.ATTRIBUTE_VALUE_TYPE.isA(att.getValueType(), 5)) continue;
                        next = next + ex.getNominalValue(att) + " ";
                    }
                    if (attr.get(t_att) != null) {
                        next = next + ex.getNominalValue(attr.get(t_att)) + " ";
                    } else if (attr.getSpecial(t_att) != null) {
                        next = next + ex.getNominalValue(attr.getSpecial(t_att)) + " ";
                    }
                }
                try {
                    wr.write(next.replaceAll("\n", " ") + "\n");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                int docId = i2;
                if (attr.getLabel() == null) continue;
                try {
                    wr_labels.write(ex.getLabel() + "\n");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                labels[i2] = ex.getLabel();
            }
            try {
                wr.close();
                wr_labels.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        int testSize = 0;
        ExampleSet exampleTests = (ExampleSet)this.inputTest.getDataOrNull(ExampleSet.class);
        if (exampleTests != null) {
            testSize = exampleTests.size();
            Example ex = exampleTests.getExample(0);
            Attributes attr = ex.getAttributes();
            numWords = attr.size();
            BufferedWriter wr = null;
            try {
                wr = new BufferedWriter(new FileWriterWithEncoding(path_data + "/texts.csv", encode, true));
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            ex = exampleTests.getExample(0);
            attr = ex.getAttributes();
            for (Attribute att : attr) {
                if (!Ontology.ATTRIBUTE_VALUE_TYPE.isA(att.getValueType(), 5)) continue;
                bow = false;
            }
            for (int i3 = 0; i3 < exampleTests.size(); ++i3) {
                String next = "";
                ex = exampleTests.getExample(i3);
                attr = ex.getAttributes();
                if (bow) {
                    for (Attribute att : attr) {
                        if (ex.getValue(att) == 0.0) continue;
                        int mult = (int)ex.getValue(att);
                        for (int m = 0; m < mult; ++m) {
                            next = att.getName().equals("text_0") ? next + "text " : next + att.getName() + " ";
                        }
                    }
                    if (next.length() == 0) {
                        next = "?";
                    }
                } else {
                    for (Attribute att : attr) {
                        if (!Ontology.ATTRIBUTE_VALUE_TYPE.isA(att.getValueType(), 5)) continue;
                        next = next + ex.getNominalValue(att) + " ";
                    }
                    if (attr.get(t_att) != null) {
                        next = next + ex.getNominalValue(attr.get(t_att)) + " ";
                    } else if (attr.getSpecial(t_att) != null) {
                        next = next + ex.getNominalValue(attr.getSpecial(t_att)) + " ";
                    }
                }
                try {
                    wr.write(next.replaceAll("\n", " ") + "\n");
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                wr.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        String pythonScriptPath = this.getParameter(SCRIPT_PATH);
        String[] cmd = new String[]{"python", pythonScriptPath, path_data, "" + this.numTopics, locSeed ? "" + seed : "1992", "" + this.alpha, "" + this.beta, "" + this.iters, supervised ? "" + testSize : ""};
        for (int i4 = 0; i4 < cmd.length; ++i4) {
            System.out.print(cmd[i4] + " ");
        }
        System.out.println();
        Runtime rt = Runtime.getRuntime();
        Process pr = null;
        try {
            pr = rt.exec(cmd);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        boolean dfr = this.getParameterAsBoolean(PARAMETER_DFR);
        double[][] probs = null;
        int numDocs = 0;
        BufferedReader reader = null;
        try {
            int D;
            reader = new BufferedReader(new InputStreamReader(pr.getInputStream(), encode));
            numDocs = D = Integer.parseInt(reader.readLine());
            int K = Integer.parseInt(reader.readLine());
            probs = new double[K][D];
            for (int i5 = 0; i5 < D; ++i5) {
                for (int j = 0; j < K; ++j) {
                    String nextString = reader.readLine();
                    probs[j][i5] = Double.parseDouble(nextString);
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (dfr) {
            this.writeDT(probs);
        }
        ArrayList<Attribute> attributeList = new ArrayList<Attribute>();
        attributeList.add(AttributeFactory.createAttribute((String)"Doc", (int)2));
        attributeList.add(AttributeFactory.createAttribute((String)"Topic", (int)2));
        for (int i6 = 0; i6 < this.numTopics; ++i6) {
            attributeList.add(AttributeFactory.createAttribute((String)("Topic_" + i6), (int)2));
        }
        MemoryExampleTable table = new MemoryExampleTable(attributeList);
        DataRowFactory factory = new DataRowFactory(0, '.');
        for (int i7 = 0; i7 < numDocs; ++i7) {
            DataRow row = factory.create(table.getNumberOfAttributes());
            table.addDataRow(row);
            row.set((Attribute)attributeList.get(0), (double)(i7 + 1));
            int top = -1;
            double max = 0.0;
            for (int j = 0; j < this.numTopics; ++j) {
                if (probs[j][i7] > max) {
                    max = probs[j][i7];
                    top = j;
                }
                row.set((Attribute)attributeList.get(2 + j), probs[j][i7]);
            }
            row.set((Attribute)attributeList.get(1), (double)top);
        }
        SimpleExampleSet set = new SimpleExampleSet((ExampleTable)table);
        this.outputDocs.deliver((IOObject)set);
        String[] words = null;
        double[] predictions = new double[testSize];
        try {
            int i8;
            int V = Integer.parseInt(reader.readLine());
            int K = Integer.parseInt(reader.readLine());
            probs = new double[K][V];
            for (i8 = 0; i8 < V; ++i8) {
                for (int j = 0; j < K; ++j) {
                    probs[j][i8] = Double.parseDouble(reader.readLine());
                }
            }
            numWords = V = Integer.parseInt(reader.readLine());
            words = new String[V];
            for (i8 = 0; i8 < V; ++i8) {
                words[i8] = reader.readLine();
            }
            for (i8 = 0; i8 < testSize && supervised; ++i8) {
                predictions[i8] = Double.parseDouble(reader.readLine());
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (dfr) {
            this.writeTW(words, probs, this.alpha);
            this.writeTopWords(words, probs);
        }
        attributeList = new ArrayList();
        attributeList.add(AttributeFactory.createAttribute((String)"Word", (int)5));
        attributeList.add(AttributeFactory.createAttribute((String)"Word_id", (int)2));
        attributeList.add(AttributeFactory.createAttribute((String)"Topic", (int)2));
        for (i = 0; i < this.numTopics; ++i) {
            attributeList.add(AttributeFactory.createAttribute((String)("Topic_" + i), (int)2));
        }
        table = new MemoryExampleTable(attributeList);
        factory = new DataRowFactory(0, '.');
        for (i = 0; i < numWords; ++i) {
            DataRow row = factory.create(table.getNumberOfAttributes());
            table.addDataRow(row);
            row.set((Attribute)attributeList.get(0), (double)((Attribute)attributeList.get(0)).getMapping().mapString(words[i]));
            row.set((Attribute)attributeList.get(1), (double)(i + 1));
            int top = -1;
            double max = 0.0;
            for (int j = 0; j < this.numTopics; ++j) {
                if (probs[j][i] > max) {
                    max = probs[j][i];
                    top = j;
                }
                row.set((Attribute)attributeList.get(3 + j), probs[j][i]);
            }
            row.set((Attribute)attributeList.get(2), (double)top);
        }
        set = new SimpleExampleSet((ExampleTable)table);
        this.outputWords.deliver((IOObject)set);
        if (supervised) {
            attributeList = new ArrayList();
            attributeList.add(AttributeFactory.createAttribute((String)"Prediction", (int)2));
            table = new MemoryExampleTable(attributeList);
            factory = new DataRowFactory(0, '.');
            for (i = 0; i < predictions.length; ++i) {
                DataRow row = factory.create(table.getNumberOfAttributes());
                table.addDataRow(row);
                row.set((Attribute)attributeList.get(0), predictions[i]);
            }
            set = new SimpleExampleSet((ExampleTable)table);
            this.predictionOutput.deliver((IOObject)set);
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        ArrayList<ParameterType> types = new ArrayList<ParameterType>();
        types.add((ParameterType)new ParameterTypeString(PARAMETER_TEXT, "Attribute name for text", "text_attr"));
        types.add((ParameterType)new ParameterTypeInt(PARAMETER_NUMITERATIONS, "Number of Iterations for Gibbs Sampling. If zero, we perform variational inference.", 0, Integer.MAX_VALUE, 2000));
        types.add((ParameterType)new ParameterTypeInt(PARAMETER_NUMTOPICS, "Number of Topics.", 1, Integer.MAX_VALUE, 5));
        types.add((ParameterType)new ParameterTypeDouble(PARAMETER_ALPHA, "Alpha parameter for Dirichlet", 0.0, Double.MAX_VALUE, 0.25));
        types.add((ParameterType)new ParameterTypeDouble(PARAMETER_BETA, "Beta parameter for Dirichlet", 0.0, Double.MAX_VALUE, 0.1));
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_DFR, "Write results out for dfr browser", true, false));
        types.add((ParameterType)new ParameterTypeDirectory(PARAMETER_PATH, "Path for dfr files.", "/home/poelitz/work/Datasets/ResultData/acl2015/"));
        types.add((ParameterType)new ParameterTypeDirectory(PATH_DATA, "Path for data files.", "/home/poelitz/work/Datasets/ResultData/TM"));
        types.add((ParameterType)new ParameterTypeFile(SCRIPT_PATH, "Python scrips", ".py", "/home/poelitz/work/python/buildCorpusAndOnlineLDA.py"));
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_SUPER, "Perform supervised LDA with numinal (Gaussian) or numeric (Beta) labels. ", false, false));
        types.add((ParameterType)new ParameterTypeStringCategory(PARAMETER_ENCODING, "The encoding of the texts.", ENCODINGS, ENCODINGS[1]));
        types.addAll(RandomGenerator.getRandomGeneratorParameters((Operator)this));
        return types;
    }

    public static void main(String[] args) {
    }
}

