/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.kobra.topicmodels;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SimpleExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DataRowFactory;
import com.rapidminer.example.table.ExampleTable;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.kobra.data.CCSMatrix;
import com.rapidminer.kobra.topicmodels.SamplersDTLDA;
import com.rapidminer.kobra.topicmodels.SamplersGBTLDA;
import com.rapidminer.kobra.topicmodels.SamplersGTLDA;
import com.rapidminer.kobra.topicmodels.SamplersLDA;
import com.rapidminer.kobra.topicmodels.SamplersSLDA;
import com.rapidminer.kobra.topicmodels.SamplersUniformTLDA;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.clustering.ClusterModel;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDirectory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.RandomGenerator;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TDoubleIntHashMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class LDAOperator
extends Operator {
    static String PARAMETER_NUMITERATIONS = "iterations";
    static String PARAMETER_NUMTOPICS = "number_of_topics";
    static String PARAMETER_ALPHA = "alpha";
    static String PARAMETER_BETA = "beta";
    static String PARAMETER_GROUP = "group";
    static String PARAMETER_SUPER = "supervised";
    static String PARAMETER_LABEL = "label distribution";
    static String[] label = new String[]{"Beta", "Gaussian", "Gompertz", "GomperzUni", "GompertzEmp", "Uniform", "TruncatedGomp"};
    static int BETA = 0;
    static int GAUSSIAN = 1;
    static int GOMPERTZ = 2;
    static int GOMPERTZUNI = 3;
    static int GOMPERTZEMP = 4;
    static int UNI = 5;
    static int TRUNCGOMPERTZ = 6;
    int iters = 2000;
    int numTopics = 4;
    double alpha = 0.25;
    double beta = 0.1;
    static String PARAMETER_DFR = "dfr";
    static String PARAMETER_PATH = "path";
    String path = "/home/poelitz/work/Datasets/ResultData/acl2015/";
    int seed = 1992;
    boolean locSeed = false;
    private final InputPort input = (InputPort)this.getInputPorts().createPort("example set of documents as Bag-of-Words vectors with term occurrences");
    private final InputPort inputTest = (InputPort)this.getInputPorts().createPort("example set of documents as Bag-of-Words vectors with term occurrences to be classified. (optional)");
    private final InputPort inputGroup = (InputPort)this.getInputPorts().createPort("example set of groups for each document (optional)");
    private final InputPort inputText = (InputPort)this.getInputPorts().createPort("example set of the text from each document (optional)");
    private final InputPort inputLabels = (InputPort)this.getInputPorts().createPort("example set containing labels for each document (deprecated)");
    private final InputPort inputSources = (InputPort)this.getInputPorts().createPort("example set indicating sources from the documents (deprecated)");
    private final OutputPort outputWordsProbs = (OutputPort)this.getOutputPorts().createPort("example set of word distributions for the topics");
    private final OutputPort outputDocs = (OutputPort)this.getOutputPorts().createPort("example set of topic distributions for the documents");
    private final OutputPort outputWordsCounts = (OutputPort)this.getOutputPorts().createPort("example set of word topics assignments");
    private final OutputPort outputTopicCounts = (OutputPort)this.getOutputPorts().createPort("example set of counts of topics");
    private final OutputPort outputPi = (OutputPort)this.getOutputPorts().createPort("example set of estimited Beta parameters, if labels are Beta distributed");
    private OutputPort modelOutput = (OutputPort)this.getOutputPorts().createPort("cluster model");
    int topK = 40;

    public LDAOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule((MDTransformationRule)new GenerateNewMDRule(this.modelOutput, new MetaData(ClusterModel.class)));
    }

    public void doWork() throws OperatorException {
        int i;
        int count;
        int count2;
        TIntArrayList list;
        ArrayList<Attribute> attributeList;
        int k;
        double frequ;
        int wordId;
        int j;
        this.locSeed = this.getParameterAsBoolean("use_local_random_seed");
        this.seed = this.getParameterAsInt("local_random_seed");
        this.iters = this.getParameterAsInt(PARAMETER_NUMITERATIONS);
        this.numTopics = this.getParameterAsInt(PARAMETER_NUMTOPICS);
        this.alpha = this.getParameterAsDouble(PARAMETER_ALPHA);
        this.beta = this.getParameterAsDouble(PARAMETER_BETA);
        this.path = this.getParameter(PARAMETER_PATH);
        boolean supervised = this.getParameterAsBoolean(PARAMETER_SUPER);
        TIntArrayList wordToken = new TIntArrayList();
        TIntArrayList docToken = new TIntArrayList();
        int numWords = 0;
        ExampleSet exampleSet = (ExampleSet)this.input.getData(ExampleSet.class);
        Example ex = exampleSet.getExample(0);
        Attributes attr = ex.getAttributes();
        numWords = attr.size();
        String[] words = new String[numWords];
        double[] labels = null;
        if (attr.getLabel() != null) {
            labels = new double[exampleSet.size()];
        }
        int[] doc_lengths = new int[exampleSet.size()];
        TIntArrayList[] documentTokens = new TIntArrayList[exampleSet.size()];
        String[] texts = new String[exampleSet.size()];
        boolean containsTexts = false;
        for (int i2 = 0; i2 < exampleSet.size(); ++i2) {
            documentTokens[i2] = new TIntArrayList();
            int docId = i2;
            ex = exampleSet.getExample(i2);
            attr = ex.getAttributes();
            if (attr.getLabel() != null) {
                labels[i2] = ex.getLabel();
            }
            if (attr.getSpecial("text") != null) {
                texts[i2] = ex.getNominalValue(attr.getSpecial("text"));
                containsTexts = true;
            }
            boolean nextAtt = false;
            j = 0;
            for (Attribute att : attr) {
                words[j] = att.getName();
                wordId = j++;
                frequ = 0.0;
                frequ = ex.getValue(att);
                if (frequ == 0.0) continue;
                for (k = 0; k < (int)frequ; ++k) {
                    int n = i2;
                    doc_lengths[n] = doc_lengths[n] + 1;
                    docToken.add(docId);
                    wordToken.add(wordId);
                    documentTokens[i2].add(j - 1);
                }
            }
        }
        int trainSize = exampleSet.size();
        ExampleSet test = (ExampleSet)this.inputTest.getDataOrNull(ExampleSet.class);
        if (test != null) {
            for (int i3 = 0; i3 < test.size(); ++i3) {
                int docId = i3;
                ex = test.getExample(i3);
                attr = ex.getAttributes();
                j = 0;
                for (Attribute att : attr) {
                    words[j] = att.getName();
                    wordId = j++;
                    frequ = 0.0;
                    frequ = ex.getValue(att);
                    if (frequ == 0.0) continue;
                    for (k = 0; k < (int)frequ; ++k) {
                        docToken.add(docId);
                        wordToken.add(wordId);
                    }
                }
            }
        }
        ExampleSet exampleSet2 = (ExampleSet)this.inputLabels.getDataOrNull(ExampleSet.class);
        double[] times = null;
        double[][] geos = null;
        boolean containsX = false;
        boolean containsY = false;
        if (exampleSet2 != null) {
            geos = new double[exampleSet2.size()][2];
            times = new double[exampleSet2.size()];
            ex = exampleSet2.getExample(0);
            attr = ex.getAttributes();
            for (int i4 = 0; i4 < exampleSet2.size(); ++i4) {
                ex = exampleSet2.getExample(i4);
                times[i4] = ex.getValue(attr.get("date"));
                if (attr.getSpecial("geoX") != null) {
                    geos[i4][0] = ex.getValue(attr.getSpecial("geoX"));
                    containsX = true;
                }
                if (attr.getSpecial("geoY") == null) continue;
                geos[i4][1] = ex.getValue(attr.getSpecial("geoY"));
                containsY = true;
            }
        }
        ExampleSet exampleSet3 = (ExampleSet)this.inputSources.getDataOrNull(ExampleSet.class);
        int[] UniqueDocIds = null;
        if (exampleSet3 != null) {
            UniqueDocIds = new int[exampleSet3.size()];
            ex = exampleSet3.getExample(0);
            attr = ex.getAttributes();
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            int id = 0;
            for (int i5 = 0; i5 < exampleSet3.size(); ++i5) {
                ex = exampleSet3.getExample(i5);
                String next = ex.getNominalValue(attr.get("source"));
                if (next.contains(":")) {
                    next = next.substring(0, next.indexOf(":"));
                }
                if (map.containsKey(next)) {
                    UniqueDocIds[i5] = (Integer)map.get(next);
                    continue;
                }
                UniqueDocIds[i5] = ++id;
                map.put(next, id);
            }
        }
        Random rn = new Random();
        SamplersLDA sampler = null;
        int l = this.getParameterAsInt(PARAMETER_LABEL);
        if (supervised) {
            if (l == UNI) {
                if (labels != null) {
                    times = labels;
                    sampler = new SamplersUniformTLDA();
                    ((SamplersUniformTLDA)sampler).init(docToken.toArray(), wordToken.toArray(), times, UniqueDocIds, this.numTopics, numWords, exampleSet.size(), this.iters, this.beta, this.alpha, this.locSeed, this.seed);
                } else if (exampleSet2 != null) {
                    sampler = new SamplersUniformTLDA();
                    ((SamplersUniformTLDA)sampler).init(docToken.toArray(), wordToken.toArray(), times, UniqueDocIds, this.numTopics, numWords, exampleSet.size(), this.iters, this.beta, this.alpha, this.locSeed, this.seed);
                }
            } else if (l == GOMPERTZUNI || l == GOMPERTZEMP) {
                if (labels != null) {
                    times = labels;
                    sampler = new SamplersGBTLDA();
                    ((SamplersGBTLDA)sampler).init(docToken.toArray(), wordToken.toArray(), times, UniqueDocIds, this.numTopics, numWords, exampleSet.size(), this.iters, this.beta, this.alpha, this.locSeed, this.seed);
                    if (l == GOMPERTZEMP) {
                        ((SamplersGBTLDA)sampler).emp = true;
                    }
                } else if (exampleSet2 != null) {
                    sampler = new SamplersGBTLDA();
                    ((SamplersGBTLDA)sampler).init(docToken.toArray(), wordToken.toArray(), times, UniqueDocIds, this.numTopics, numWords, exampleSet.size(), this.iters, this.beta, this.alpha, this.locSeed, this.seed);
                    if (l == GOMPERTZEMP) {
                        ((SamplersGBTLDA)sampler).emp = true;
                    }
                }
            } else if (l == BETA) {
                if (labels != null) {
                    times = labels;
                    sampler = new SamplersDTLDA();
                    ((SamplersDTLDA)sampler).init(docToken.toArray(), wordToken.toArray(), times, UniqueDocIds, this.numTopics, numWords, exampleSet.size(), this.iters, this.beta, this.alpha, this.locSeed, this.seed);
                } else if (exampleSet2 != null) {
                    sampler = new SamplersDTLDA();
                    ((SamplersDTLDA)sampler).init(docToken.toArray(), wordToken.toArray(), times, UniqueDocIds, this.numTopics, numWords, exampleSet.size(), this.iters, this.beta, this.alpha, this.locSeed, this.seed);
                } else {
                    sampler = new SamplersLDA();
                    sampler.init(docToken.toArray(), wordToken.toArray(), this.numTopics, numWords, exampleSet.size(), this.iters, this.beta, this.alpha, this.locSeed, this.seed);
                }
            } else if (l == GOMPERTZ) {
                if (labels != null) {
                    times = labels;
                    sampler = new SamplersGTLDA();
                    ((SamplersGTLDA)sampler).init(docToken.toArray(), wordToken.toArray(), times, UniqueDocIds, this.numTopics, numWords, exampleSet.size(), this.iters, this.beta, this.alpha, this.locSeed, this.seed);
                } else if (exampleSet2 != null) {
                    sampler = new SamplersGTLDA();
                    ((SamplersGTLDA)sampler).init(docToken.toArray(), wordToken.toArray(), times, UniqueDocIds, this.numTopics, numWords, exampleSet.size(), this.iters, this.beta, this.alpha, this.locSeed, this.seed);
                } else {
                    sampler = new SamplersLDA();
                    sampler.init(docToken.toArray(), wordToken.toArray(), this.numTopics, numWords, exampleSet.size(), this.iters, this.beta, this.alpha, this.locSeed, this.seed);
                }
            } else if (labels == null) {
                if (exampleSet2 != null) {
                    sampler = new SamplersSLDA();
                    labels = times;
                    ((SamplersSLDA)sampler).init(docToken.toArray(), wordToken.toArray(), this.numTopics, numWords, exampleSet.size(), this.iters, this.beta, this.alpha, labels, doc_lengths, this.locSeed, this.seed);
                    ((SamplersSLDA)sampler).start_test = trainSize;
                } else {
                    sampler = new SamplersLDA();
                    sampler.init(docToken.toArray(), wordToken.toArray(), this.numTopics, numWords, exampleSet.size(), this.iters, this.beta, this.alpha, this.locSeed, this.seed);
                }
            } else {
                sampler = new SamplersSLDA();
                ((SamplersSLDA)sampler).init(docToken.toArray(), wordToken.toArray(), this.numTopics, numWords, exampleSet.size(), this.iters, this.beta, this.alpha, labels, doc_lengths, this.locSeed, this.seed);
                ((SamplersSLDA)sampler).start_test = trainSize;
            }
        } else {
            sampler = new SamplersLDA();
            sampler.init(docToken.toArray(), wordToken.toArray(), this.numTopics, numWords, exampleSet.size(), this.iters, this.beta, this.alpha, this.locSeed, this.seed);
        }
        sampler.GibbsSampling();
        boolean dfr = this.getParameterAsBoolean(PARAMETER_DFR);
        if ((exampleSet2 != null || labels != null && l == BETA || labels != null && l == GOMPERTZ || labels != null && l == GOMPERTZUNI || labels != null && l == UNI || labels != null && l == GOMPERTZEMP) && supervised) {
            double[][] pi = null;
            if (l != GOMPERTZ && l != GOMPERTZUNI && l != UNI && l != GOMPERTZEMP) {
                pi = ((SamplersDTLDA)sampler).getPi();
                for (int i6 = 0; i6 < pi.length; ++i6) {
                    for (int j2 = 0; j2 < pi[i6].length; ++j2) {
                    }
                }
            } else {
                pi = ((SamplersGTLDA)sampler).getPi();
                if (dfr) {
                    double[][] stats = ((SamplersGTLDA)sampler).testStatistics;
                    BufferedWriter bw = null;
                    try {
                        bw = new BufferedWriter(new FileWriter(this.path + "pValues.txt"));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    String lines = "";
                    for (int i7 = 0; i7 < stats.length; ++i7) {
                        lines = "";
                        for (int j3 = 0; j3 < stats[i7].length; ++j3) {
                            lines = lines + stats[i7][j3] + ", ";
                        }
                        try {
                            bw.write(lines);
                            continue;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    try {
                        bw.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            attributeList = new ArrayList();
            attributeList.add(AttributeFactory.createAttribute((String)"Topic", (int)2));
            attributeList.add(AttributeFactory.createAttribute((String)"alpha", (int)2));
            attributeList.add(AttributeFactory.createAttribute((String)"beta", (int)2));
            MemoryExampleTable table = new MemoryExampleTable(attributeList);
            DataRowFactory factory = new DataRowFactory(0, '.');
            for (int i8 = 0; i8 < pi.length; ++i8) {
                DataRow row = factory.create(table.getNumberOfAttributes());
                row.set((Attribute)attributeList.get(0), (double)(i8 + 1));
                row.set((Attribute)attributeList.get(1), pi[i8][0]);
                row.set((Attribute)attributeList.get(2), pi[i8][1]);
                table.addDataRow(row);
            }
            SimpleExampleSet set = new SimpleExampleSet((ExampleTable)table);
            this.outputPi.deliver((IOObject)set);
            if (dfr) {
                TDoubleArrayList[] assigned = null;
                assigned = l != GOMPERTZ && l != GOMPERTZUNI && l != UNI && l != GOMPERTZEMP ? ((SamplersDTLDA)sampler).getAssignedTimes() : ((SamplersGTLDA)sampler).getAssignedTimes();
                try {
                    TDoubleIntHashMap timeToCounts = new TDoubleIntHashMap();
                    for (int i9 = 0; i9 < assigned.length; ++i9) {
                        for (int j4 = 0; j4 < assigned[i9].size(); ++j4) {
                            double time = assigned[i9].get(j4);
                            list = documentTokens[i9];
                            count2 = 1;
                            if (timeToCounts.contains(time)) {
                                count2 += timeToCounts.get(time);
                            }
                            timeToCounts.put(time, count2);
                        }
                    }
                    TDoubleIntHashMap[] timeToCountsAll = new TDoubleIntHashMap[this.numTopics];
                    for (int t = 0; t < this.numTopics; ++t) {
                        timeToCountsAll[t] = new TDoubleIntHashMap();
                    }
                    for (int i10 = 0; i10 < assigned.length; ++i10) {
                        for (int j5 = 0; j5 < assigned[i10].size(); ++j5) {
                            double nextTime = assigned[i10].get(j5);
                            count2 = 1;
                            if (timeToCountsAll[i10].contains(nextTime)) {
                                count2 += timeToCountsAll[i10].get(nextTime);
                            }
                            timeToCountsAll[i10].put(nextTime, count2);
                        }
                        BufferedWriter bw = new BufferedWriter(new FileWriter(this.path + "t" + (i10 + 1) + "times.txt"));
                        String lines = "";
                        for (double vt : timeToCountsAll[i10].keys()) {
                            int locCount = timeToCountsAll[i10].get(vt);
                            int pr = (int)((double)(100 * locCount) / (double)(count = timeToCounts.get(vt)));
                            if (pr == 0) {
                                pr = 1;
                            }
                            for (int s = 0; s < pr; ++s) {
                                lines = i10 + 1 + "," + (s + 1) + "," + vt + "\n";
                                bw.write(lines);
                            }
                        }
                        bw.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        double[][] probs = sampler.documentDistribution();
        if (dfr) {
            this.writeDT(probs);
        }
        attributeList = new ArrayList<Attribute>();
        attributeList.add(AttributeFactory.createAttribute((String)"Doc", (int)2));
        attributeList.add(AttributeFactory.createAttribute((String)"Topic", (int)2));
        for (int i11 = 0; i11 < this.numTopics; ++i11) {
            attributeList.add(AttributeFactory.createAttribute((String)("Topic_" + i11), (int)2));
        }
        double[] preds = null;
        if (labels != null && supervised) {
            attributeList.add(AttributeFactory.createAttribute((String)"Label", (int)1));
            attributeList.add(AttributeFactory.createAttribute((String)"Prediction", (int)1));
            preds = ((SamplersSLDA)sampler).getPredictions();
        }
        MemoryExampleTable table = new MemoryExampleTable(attributeList);
        DataRowFactory factory = new DataRowFactory(0, '.');
        for (int i12 = 0; i12 < exampleSet.size(); ++i12) {
            DataRow row = factory.create(table.getNumberOfAttributes());
            table.addDataRow(row);
            row.set((Attribute)attributeList.get(0), (double)(i12 + 1));
            int top = -1;
            double max = 0.0;
            for (int j6 = 0; j6 < this.numTopics; ++j6) {
                if (probs[j6][i12] > max) {
                    max = probs[j6][i12];
                    top = j6;
                }
                row.set((Attribute)attributeList.get(2 + j6), probs[j6][i12]);
            }
            row.set((Attribute)attributeList.get(1), (double)top);
            if (labels == null || !supervised) continue;
            row.set((Attribute)attributeList.get(attributeList.size() - 2), (double)((Attribute)attributeList.get(attributeList.size() - 2)).getMapping().mapString(labels[i12] + ""));
            row.set((Attribute)attributeList.get(attributeList.size() - 1), (double)((Attribute)attributeList.get(attributeList.size() - 1)).getMapping().mapString(preds[i12] + ""));
        }
        SimpleExampleSet set = new SimpleExampleSet((ExampleTable)table);
        this.outputDocs.deliver((IOObject)set);
        probs = sampler.wordDistribution();
        int[][] wt = sampler.getWordTopicCounts();
        if (dfr) {
            this.writeTW(words, probs, this.alpha);
            if (supervised && (l == GOMPERTZ || l == GOMPERTZUNI || l == UNI || l == BETA || l == GOMPERTZEMP)) {
                int s;
                int pr;
                int count3;
                int locCount;
                int i13;
                int t;
                TDoubleIntHashMap timeToCounts = new TDoubleIntHashMap();
                for (int i14 = 0; i14 < documentTokens.length; ++i14) {
                    double time = labels[i14];
                    list = documentTokens[i14];
                    count2 = 0;
                    for (int s2 = 0; s2 < list.size(); ++s2) {
                        ++count2;
                    }
                    if (timeToCounts.contains(time)) {
                        count2 += timeToCounts.get(time);
                    }
                    timeToCounts.put(time, count2);
                }
                int[][] top2 = this.writeTopWords2(words, probs);
                TDoubleArrayList[] temps = new TDoubleArrayList[this.numTopics];
                TDoubleIntHashMap[] timeToCountsAll = new TDoubleIntHashMap[this.numTopics];
                for (t = 0; t < this.numTopics; ++t) {
                    temps[t] = new TDoubleArrayList();
                    timeToCountsAll[t] = new TDoubleIntHashMap();
                }
                if (!containsTexts) {
                    for (i13 = 0; i13 < documentTokens.length; ++i13) {
                        TIntArrayList list2 = documentTokens[i13];
                        for (int t2 = 0; t2 < this.numTopics; ++t2) {
                            if (!list2.contains(top2[t2][0]) && !list2.contains(top2[t2][1])) continue;
                            double nextTime = labels[i13];
                            int count4 = 0;
                            for (int s3 = 0; s3 < list2.size(); ++s3) {
                                ++count4;
                            }
                            if (timeToCountsAll[t2].contains(nextTime)) {
                                count4 += timeToCountsAll[t2].get(nextTime);
                            }
                            timeToCountsAll[t2].put(nextTime, count4);
                        }
                    }
                    for (t = 0; t < this.numTopics; ++t) {
                        for (double vt : timeToCountsAll[t].keys()) {
                            locCount = timeToCountsAll[t].get(vt);
                            pr = (int)((double)(100 * locCount) / (double)(count3 = timeToCounts.get(vt)));
                            if (pr == 0) {
                                pr = 1;
                            }
                            for (s = 0; s < pr; ++s) {
                                temps[t].add(vt);
                            }
                        }
                    }
                } else {
                    for (i13 = 0; i13 < texts.length; ++i13) {
                        String tt = texts[i13];
                        TIntArrayList list3 = documentTokens[i13];
                        for (int t3 = 0; t3 < this.numTopics; ++t3) {
                            if (!tt.contains(words[top2[t3][0]]) || !tt.contains(words[top2[t3][1]])) continue;
                            double nextTime = labels[i13];
                            count = 0;
                            for (int s4 = 0; s4 < list3.size(); ++s4) {
                                ++count;
                            }
                            if (timeToCountsAll[t3].contains(nextTime)) {
                                count += timeToCountsAll[t3].get(nextTime);
                            }
                            timeToCountsAll[t3].put(nextTime, count);
                        }
                    }
                    for (t = 0; t < this.numTopics; ++t) {
                        for (double vt : timeToCountsAll[t].keys()) {
                            locCount = timeToCountsAll[t].get(vt);
                            pr = (int)((double)(100 * locCount) / (double)(count3 = timeToCounts.get(vt)));
                            if (pr == 0) {
                                pr = 1;
                            }
                            for (s = 0; s < pr; ++s) {
                                temps[t].add(vt);
                            }
                        }
                    }
                }
                BufferedWriter bw = null;
                try {
                    for (int t4 = 0; t4 < this.numTopics; ++t4) {
                        bw = new BufferedWriter(new FileWriter(this.path + "t" + (t4 + 1) + words[top2[t4][0]] + words[top2[t4][1]] + "times.txt"));
                        String lines = "";
                        for (int j7 = 0; j7 < temps[t4].size(); ++j7) {
                            lines = t4 + 1 + "," + (j7 + 1) + "," + temps[t4].get(j7) + "\n";
                            bw.write(lines);
                        }
                        bw.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                this.writeTopWords(words, probs);
            }
        }
        attributeList = new ArrayList();
        attributeList.add(AttributeFactory.createAttribute((String)"Word", (int)5));
        attributeList.add(AttributeFactory.createAttribute((String)"Word_id", (int)2));
        attributeList.add(AttributeFactory.createAttribute((String)"Topic", (int)2));
        for (i = 0; i < this.numTopics; ++i) {
            attributeList.add(AttributeFactory.createAttribute((String)("Topic_" + i), (int)2));
        }
        table = new MemoryExampleTable(attributeList);
        factory = new DataRowFactory(0, '.');
        for (i = 0; i < numWords; ++i) {
            DataRow row = factory.create(table.getNumberOfAttributes());
            table.addDataRow(row);
            row.set((Attribute)attributeList.get(0), (double)((Attribute)attributeList.get(0)).getMapping().mapString(words[i]));
            row.set((Attribute)attributeList.get(1), (double)(i + 1));
            int top = -1;
            double max = 0.0;
            for (int j8 = 0; j8 < this.numTopics; ++j8) {
                if (probs[j8][i] > max) {
                    max = probs[j8][i];
                    top = j8;
                }
                row.set((Attribute)attributeList.get(3 + j8), probs[j8][i]);
            }
            row.set((Attribute)attributeList.get(2), (double)top);
        }
        set = new SimpleExampleSet((ExampleTable)table);
        this.outputWordsProbs.deliver((IOObject)set);
        attributeList = new ArrayList();
        attributeList.add(AttributeFactory.createAttribute((String)"Word", (int)5));
        attributeList.add(AttributeFactory.createAttribute((String)"Word_id", (int)2));
        for (i = 0; i < this.numTopics; ++i) {
            attributeList.add(AttributeFactory.createAttribute((String)("Topic_" + i), (int)2));
        }
        table = new MemoryExampleTable(attributeList);
        factory = new DataRowFactory(0, '.');
        for (i = 0; i < numWords; ++i) {
            DataRow row = factory.create(table.getNumberOfAttributes());
            table.addDataRow(row);
            row.set((Attribute)attributeList.get(0), (double)((Attribute)attributeList.get(0)).getMapping().mapString(words[i]));
            row.set((Attribute)attributeList.get(1), (double)(i + 1));
            int top = -1;
            double max = 0.0;
            for (int j9 = 0; j9 < this.numTopics; ++j9) {
                if (probs[j9][i] > max) {
                    max = probs[j9][i];
                    top = j9;
                }
                row.set((Attribute)attributeList.get(2 + j9), (double)wt[j9][i]);
            }
        }
        set = new SimpleExampleSet((ExampleTable)table);
        this.outputWordsCounts.deliver((IOObject)set);
        int[] t = sampler.getTopicCounts();
        attributeList = new ArrayList();
        for (int i15 = 0; i15 < this.numTopics; ++i15) {
            attributeList.add(AttributeFactory.createAttribute((String)("Topic_" + i15), (int)2));
        }
        table = new MemoryExampleTable(attributeList);
        factory = new DataRowFactory(0, '.');
        DataRow row = factory.create(table.getNumberOfAttributes());
        for (int j10 = 0; j10 < this.numTopics; ++j10) {
            row.set((Attribute)attributeList.get(j10), (double)t[j10]);
        }
        table.addDataRow(row);
        set = new SimpleExampleSet((ExampleTable)table);
        this.outputTopicCounts.deliver((IOObject)set);
    }

    public void writeDT(int[] topics, double[] pr) {
        String r = "{";
        String i = "\"i\":[" + topics[0];
        String p = "\"p\":[0";
        String x = "\"x\":[" + pr[0];
        for (int d = 1; d < topics.length; ++d) {
            i = i + "," + topics[d];
            p = p + "," + d;
            x = x + "," + (int)(pr[d] * 1000.0);
        }
        r = r + i + "]," + p + "]," + x + "]}";
        System.out.println(r);
    }

    public void writeDT(double[][] td) {
        double[][] dt = new double[td[0].length][td.length];
        for (int i = 0; i < dt.length; ++i) {
            for (int j = 0; j < dt[i].length; ++j) {
                dt[i][j] = (int)(td[j][i] * 100.0);
            }
        }
        CCSMatrix ma = CCSMatrix.from2DArray(dt);
        int[] cp = ma.columnPointers;
        int[] ri = ma.rowIndices;
        double[] v = ma.values;
        String file = this.path + "dt.json";
        StringBuilder res = new StringBuilder(ri.length + cp.length + v.length);
        res.append('{');
        res.append("\"i\": [" + ri[0] + " ");
        for (int ind = 1; ind < ri.length; ++ind) {
            res.append(", " + ri[ind]);
        }
        res.append("],");
        res.append("\"p\": [" + cp[0] + " ");
        for (int poi = 1; poi < cp.length; ++poi) {
            res.append(", " + cp[poi]);
        }
        res.append("],");
        res.append("\"x\": [" + (int)v[0] + " ");
        for (int val = 1; val < v.length; ++val) {
            res.append(", " + (int)v[val]);
        }
        res.append("]}");
        this.writeAndZip(res.toString(), file);
    }

    public void writeDT2(double[][] td) {
        double[][] dt = new double[td[0].length][td.length];
        for (int i = 0; i < dt.length; ++i) {
            for (int j = 0; j < dt[i].length; ++j) {
                dt[i][j] = (int)(td[j][i] * 100.0);
            }
        }
        CCSMatrix ma = CCSMatrix.from2DArray(dt);
        int[] cp = ma.columnPointers;
        int[] ri = ma.rowIndices;
        double[] v = ma.values;
        String file = this.path + "dt.json";
        StringBuilder res = new StringBuilder(ri.length + cp.length + v.length);
        res.append('{');
        String r = "{";
        String i = "\"i\": [" + ri[0] + " ";
        for (int ind = 1; ind < ri.length; ++ind) {
            i = i + ", " + ri[ind];
        }
        String p = "\"p\": [" + cp[0] + " ";
        for (int poi = 1; poi < cp.length; ++poi) {
            p = p + ", " + cp[poi];
        }
        String x = "\"x\": [" + (int)v[0] + " ";
        for (int val = 1; val < v.length; ++val) {
            x = x + ", " + (int)v[val];
        }
        r = r + i + "]," + p + "]," + x + "]}";
        this.writeAndZip(r, file);
    }

    public void writeAndZip(String r, String file) {
        Writer bw = null;
        try {
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            bw.write(r);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            ((BufferedWriter)bw).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            int count;
            BufferedInputStream origin = null;
            FileOutputStream dest = new FileOutputStream(file + ".zip");
            ZipOutputStream out2 = new ZipOutputStream(new BufferedOutputStream(dest));
            byte[] data = new byte[2048];
            FileInputStream fi = new FileInputStream(file);
            origin = new BufferedInputStream(fi, 2048);
            ZipEntry entry = new ZipEntry(file.substring(file.lastIndexOf("/") + 1, file.length()));
            out2.putNextEntry(entry);
            while ((count = origin.read(data, 0, 2048)) != -1) {
                out2.write(data, 0, count);
            }
            origin.close();
            out2.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeTopWords(String[] words, double[][] tw) {
        int t;
        Word[][] myWords = new Word[tw.length][tw[0].length];
        for (t = 0; t < tw.length; ++t) {
            for (int i = 0; i < tw[t].length; ++i) {
                Word w = new Word();
                w.id = i;
                w.weight = tw[t][i];
                w.word = words[i];
                myWords[t][i] = w;
            }
        }
        for (t = 0; t < tw.length; ++t) {
            Object[] tmp = myWords[t];
            Arrays.sort(tmp);
        }
        PrintStream ps = null;
        try {
            ps = new PrintStream((OutputStream)new FileOutputStream(this.path + "topWords.txt", false), true, "UTF-8");
            System.setOut(ps);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < this.topK && i < words.length; ++i) {
            String next = "";
            for (int t2 = 0; t2 < tw.length; ++t2) {
                next = next + t2 + "," + myWords[t2][i].toString() + ",";
            }
            System.out.println(next);
        }
        try {
            ps.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        System.setOut(System.out);
    }

    public int[][] writeTopWords2(String[] words, double[][] tw) {
        int t;
        int[][] res = new int[tw.length][10];
        Word[][] myWords = new Word[tw.length][tw[0].length];
        for (t = 0; t < tw.length; ++t) {
            for (int i = 0; i < tw[t].length; ++i) {
                Word w = new Word();
                w.id = i;
                w.weight = tw[t][i];
                w.word = words[i];
                myWords[t][i] = w;
            }
        }
        for (t = 0; t < tw.length; ++t) {
            Object[] tmp = myWords[t];
            Arrays.sort(tmp);
            res[t][0] = ((Word)tmp[0]).id;
            res[t][1] = ((Word)tmp[1]).id;
            res[t][2] = ((Word)tmp[2]).id;
            res[t][3] = ((Word)tmp[3]).id;
            res[t][4] = ((Word)tmp[4]).id;
            res[t][5] = ((Word)tmp[5]).id;
            res[t][6] = ((Word)tmp[6]).id;
            res[t][7] = ((Word)tmp[7]).id;
            res[t][8] = ((Word)tmp[8]).id;
            res[t][9] = ((Word)tmp[9]).id;
        }
        PrintStream ps = null;
        try {
            ps = new PrintStream((OutputStream)new FileOutputStream(this.path + "topWords.txt", false), true, "UTF-8");
            System.setOut(ps);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < this.topK && i < words.length; ++i) {
            String next = "";
            for (int t2 = 0; t2 < tw.length; ++t2) {
                next = next + t2 + "," + myWords[t2][i].toString() + ",";
            }
            System.out.println(next);
        }
        try {
            ps.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        System.setOut(System.out);
        return res;
    }

    public void writeTW(String[] words, double[][] tw, double alpha) {
        int t;
        String twS = "\"tw\":[";
        String alphaS = "{\"alpha\":[" + alpha;
        for (t = 1; t < tw.length; ++t) {
            alphaS = alphaS + "," + alpha;
        }
        for (t = 0; t < tw.length; ++t) {
            double[] w = new double[tw[t].length];
            for (int i = 0; i < tw[t].length; ++i) {
                w[i] = tw[t][i];
            }
            Arrays.sort(w);
            if (this.topK >= w.length) {
                // empty if block
            }
            double min = w[w.length - this.topK];
            String wordsS = "\"words\":[";
            String weightsS = "{\"weights\":[";
            for (int i = 0; i < tw[t].length; ++i) {
                if (!(tw[t][i] >= min)) continue;
                wordsS = wordsS + "\"" + words[i] + "\",";
                weightsS = weightsS + tw[t][i] + ",";
            }
            wordsS = wordsS.substring(0, wordsS.length() - 1);
            wordsS = wordsS + "]}";
            weightsS = weightsS.substring(0, weightsS.length() - 1);
            weightsS = weightsS + "],";
            twS = twS + weightsS + wordsS + ",";
        }
        alphaS = alphaS + "],";
        twS = twS.substring(0, twS.length() - 1);
        String r = alphaS + twS + "]}";
        this.writeAndZip(r, this.path + "tw.json");
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeInt(PARAMETER_NUMITERATIONS, "Number of Iterations for Gibbs Sampling. If zero, we perform variational inference.", 0, Integer.MAX_VALUE, 2000));
        types.add(new ParameterTypeInt(PARAMETER_NUMTOPICS, "Number of Topics.", 1, Integer.MAX_VALUE, 5));
        types.add(new ParameterTypeDouble(PARAMETER_ALPHA, "Alpha parameter for Dirichlet", 0.0, Double.MAX_VALUE, 0.25));
        types.add(new ParameterTypeDouble(PARAMETER_BETA, "Beta parameter for Dirichlet", 0.0, Double.MAX_VALUE, 0.1));
        types.add(new ParameterTypeString(PARAMETER_GROUP, "Attribute name for grouping the word counts."));
        types.add(new ParameterTypeBoolean(PARAMETER_SUPER, "Perform supervised LDA with numinal (Gaussian) or numeric (Beta) labels. ", false, false));
        ParameterTypeCategory type = new ParameterTypeCategory(PARAMETER_LABEL, "Label distribution.", label, GAUSSIAN);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_DFR, "Write results out for dfr browser", true, false));
        types.add(new ParameterTypeDirectory(PARAMETER_PATH, "Path for dfr files.", "/home/poelitz/work/Datasets/ResultData/acl2015/"));
        types.addAll(RandomGenerator.getRandomGeneratorParameters((Operator)this));
        return types;
    }

    public static void main(String[] args) {
    }

    class Word
    implements Comparable<Word> {
        public String word = "";
        public double weight = 0.0;
        public int id = -1;

        Word() {
        }

        @Override
        public int compareTo(Word o) {
            if (this.weight == o.weight) {
                return -this.word.compareTo(o.word);
            }
            return this.weight < o.weight ? 1 : -1;
        }

        public String toString() {
            return this.word + "," + this.weight;
        }
    }
}

