/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.kobra.topicmodels;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SimpleExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DataRowFactory;
import com.rapidminer.example.table.ExampleTable;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.RandomGenerator;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TDoubleDoubleHashMap;
import gnu.trove.map.hash.TDoubleIntHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.math3.distribution.BetaDistribution;

public class LDAEvaluationSMCOperator
extends Operator {
    static String PARAMETER_NUMITERATIONS = "iterations";
    static String PARAMETER_NUMTOPICS = "number_of_topics";
    static String PARAMETER_NUMTESTS = "tests";
    static String PARAMETER_ALPHA = "alpha";
    static String PARAMETER_SUPER = "supervised";
    static String PARAMETER_LABEL = "label distribution";
    static String[] label = new String[]{"Beta", "Gaussian", "Gompertz", "GomperzUni", "Uniform", "TruncatedGomp"};
    static String PARAMETER_MAX_TIME = "max_time";
    static String PARAMETER_CONDITIONAL = "conditional_distribution";
    static int BETA = 0;
    static int GAUSSIAN = 1;
    static int GOMPERTZ = 2;
    static int GOMPERTZUNI = 3;
    static int UNI = 4;
    static int TRUNCGOMPERTZ = 5;
    double maxTime = 0.0;
    boolean cond = false;
    int iters = 2000;
    int numTopics = 4;
    double alpha = 0.25;
    private final InputPort input = (InputPort)this.getInputPorts().createPort("example set input test documents as BoW");
    private final InputPort inputWords = (InputPort)this.getInputPorts().createPort("example set topic-word distributions");
    private final InputPort inputParameters = (InputPort)this.getInputPorts().createPort("example set of topic parameters for label distribution");
    private final OutputPort output = (OutputPort)this.getOutputPorts().createPort("output neg log likelihoods");
    double currentTime = 0.0;
    double timeStep = 0.0;
    TDoubleDoubleHashMap timeToNextTime = new TDoubleDoubleHashMap();
    TDoubleArrayList sortedTimeSteps = new TDoubleArrayList();
    TDoubleIntHashMap timeMap = new TDoubleIntHashMap();
    int sum = 0;
    Random rn = null;

    public LDAEvaluationSMCOperator(OperatorDescription description) {
        super(description);
    }

    public double distG(double x, double a, double b) {
        if (a == 0.0) {
            return 1.0;
        }
        double tmp = b * Math.exp(-(b * x + a * Math.exp(-b * x))) * (1.0 + a * (1.0 - Math.exp(-b * x)));
        return tmp /= (1.0 - Math.exp(-b * 10.0)) * Math.exp(-a * Math.exp(-b * 10.0));
    }

    public double cumG(double x, double a, double b) {
        return (1.0 - Math.exp(-b * x)) * Math.exp(-a * Math.exp(-b * x));
    }

    public double probG(double x1, double x2, double a, double b) {
        if (a == 0.0) {
            return (double)this.timeMap.get(x1) / (double)this.sum;
        }
        return this.cumG(x2, a, b) - this.cumG(x1, a, b);
    }

    public double distB(double x, double a, double b, BetaDistribution beta) {
        if (a == 0.0) {
            return 1.0 / this.maxTime;
        }
        return beta.density(x);
    }

    public double probB(double x1, double x2, double a, double b, BetaDistribution beta) {
        if (x2 < x1) {
            return 0.0;
        }
        return beta.cumulativeProbability(x2) - beta.cumulativeProbability(x1);
    }

    public double probUni(double x1, double x2) {
        return 1.0 / (double)this.timeToNextTime.size();
    }

    public double probEmp(double x1) {
        return (double)this.timeMap.get(x1) / (double)this.sum;
    }

    public double getGompertzLDAPerplexity(TIntArrayList[] documentTokens, double[][] topicassigns, double[][] parameters, double[] times) {
        double perplexity = 0.0;
        double ll = 0.0;
        for (int i = 0; i < documentTokens.length; ++i) {
            this.currentTime = times[i];
            TIntArrayList list = documentTokens[i];
            if (list == null) continue;
            list.shuffle(this.rn);
            int firstToken = list.get(0);
            double firstDenom = 0.0;
            double norm = 0.0;
            for (int k2 = 0; k2 < this.numTopics; ++k2) {
                firstDenom += this.alpha;
            }
            double[] z = new double[this.numTopics];
            double[] w = new double[this.numTopics];
            for (int k = 0; k < this.numTopics; ++k) {
                w[k] = this.alpha / firstDenom * topicassigns[firstToken][k] * this.probG(this.timeToNextTime.get(this.currentTime), this.currentTime, parameters[k][0], parameters[k][1]);
                if (this.cond) {
                    norm += this.alpha / firstDenom * this.probG(this.timeToNextTime.get(this.currentTime), this.currentTime, parameters[k][0], parameters[k][1]);
                    continue;
                }
                norm = 1.0;
            }
            double firstS = 0.0;
            int k = 0;
            while (k < this.numTopics) {
                int n = k++;
                w[n] = w[n] / norm;
            }
            for (k = 0; k < this.numTopics; ++k) {
                firstS += w[k];
            }
            ll = Math.log(firstS);
            for (k = 0; k < this.numTopics; ++k) {
                z[k] = w[k];
            }
            for (int n = 1; n < list.size(); ++n) {
                int nextToken = list.get(n);
                norm = 0.0;
                for (int k2 = 0; k2 < this.numTopics; ++k2) {
                    double denom = 0.0;
                    for (int k22 = 0; k22 < this.numTopics; ++k22) {
                        denom += this.alpha + z[k22];
                    }
                    w[k2] = (this.alpha + z[k2]) / denom * topicassigns[nextToken][k2] * this.probG(this.timeToNextTime.get(this.currentTime), this.currentTime, parameters[k2][0], parameters[k2][1]);
                    if (this.cond) {
                        norm += (this.alpha + z[k2]) / denom * this.probG(this.timeToNextTime.get(this.currentTime), this.currentTime, parameters[k2][0], parameters[k2][1]);
                        continue;
                    }
                    norm = 1.0;
                }
                double S = 0.0;
                int k3 = 0;
                while (k3 < this.numTopics) {
                    int n2 = k3++;
                    w[n2] = w[n2] / norm;
                }
                for (k3 = 0; k3 < this.numTopics; ++k3) {
                    S += w[k3];
                }
                ll += Math.log(S);
                for (k3 = 0; k3 < this.numTopics; ++k3) {
                    int n3 = k3;
                    w[n3] = w[n3] / S;
                    int n4 = k3;
                    z[n4] = z[n4] + w[k3];
                }
            }
            perplexity += ll;
        }
        return perplexity;
    }

    public double getBetaLDAPerplexity(TIntArrayList[] documentTokens, double[][] topicassigns, double[][] parameters, double[] times) {
        BetaDistribution[] pBeta = new BetaDistribution[parameters.length];
        for (int p = 0; p < parameters.length; ++p) {
            pBeta[p] = new BetaDistribution(parameters[p][0], parameters[p][1]);
        }
        double perplexity = 0.0;
        double ll = 0.0;
        for (int i = 0; i < documentTokens.length; ++i) {
            int k;
            int k2;
            this.currentTime = times[i];
            TIntArrayList list = documentTokens[i];
            if (list == null) continue;
            list.shuffle(this.rn);
            int firstToken = list.get(0);
            double firstDenom = 0.0;
            double norm = 0.0;
            for (int k22 = 0; k22 < this.numTopics; ++k22) {
                firstDenom += this.alpha;
            }
            double[] z = new double[this.numTopics];
            double[] w = new double[this.numTopics];
            for (k2 = 0; k2 < this.numTopics; ++k2) {
                w[k2] = this.alpha / firstDenom * topicassigns[firstToken][k2] * this.probB(this.timeToNextTime.get(this.currentTime), this.currentTime, parameters[k2][0], parameters[k2][1], pBeta[k2]);
                if (this.cond) {
                    norm += this.alpha / firstDenom * this.probB(this.timeToNextTime.get(this.currentTime), this.currentTime, parameters[k2][0], parameters[k2][1], pBeta[k2]);
                    continue;
                }
                norm = 1.0;
            }
            k2 = 0;
            while (k2 < this.numTopics) {
                int n = k2++;
                w[n] = w[n] / norm;
            }
            double firstS = 0.0;
            for (k = 0; k < this.numTopics; ++k) {
                firstS += w[k];
            }
            ll = Math.log(firstS);
            for (k = 0; k < this.numTopics; ++k) {
                z[k] = w[k];
            }
            for (int n = 1; n < list.size(); ++n) {
                int k3;
                int k4;
                int nextToken = list.get(n);
                norm = 0.0;
                for (k4 = 0; k4 < this.numTopics; ++k4) {
                    double denom = 0.0;
                    for (int k23 = 0; k23 < this.numTopics; ++k23) {
                        denom += this.alpha + z[k23];
                    }
                    w[k4] = (this.alpha + z[k4]) / denom * topicassigns[nextToken][k4] * this.probB(this.timeToNextTime.get(this.currentTime), this.currentTime, parameters[k4][0], parameters[k4][1], pBeta[k4]);
                    if (this.cond) {
                        norm += (this.alpha + z[k4]) / denom * this.probB(this.timeToNextTime.get(this.currentTime), this.currentTime, parameters[k4][0], parameters[k4][1], pBeta[k4]);
                        continue;
                    }
                    norm = 1.0;
                }
                k4 = 0;
                while (k4 < this.numTopics) {
                    int n2 = k4++;
                    w[n2] = w[n2] / norm;
                }
                double S = 0.0;
                for (k3 = 0; k3 < this.numTopics; ++k3) {
                    S += w[k3];
                }
                ll += Math.log(S);
                for (k3 = 0; k3 < this.numTopics; ++k3) {
                    int n3 = k3;
                    w[n3] = w[n3] / S;
                    int n4 = k3;
                    z[n4] = z[n4] + w[k3];
                }
            }
            perplexity += ll;
        }
        return perplexity;
    }

    public double getUniformLDAPerplexity(TIntArrayList[] documentTokens, double[][] topicassigns, double[][] parameters, double[] times) {
        double perplexity = 0.0;
        boolean allCounts = false;
        double ll = 0.0;
        for (int i = 0; i < documentTokens.length; ++i) {
            this.currentTime = times[i];
            TIntArrayList list = documentTokens[i];
            if (list == null) continue;
            list.shuffle(this.rn);
            int firstToken = list.get(0);
            double firstDenom = 0.0;
            double norm = 0.0;
            for (int k2 = 0; k2 < this.numTopics; ++k2) {
                firstDenom += this.alpha;
            }
            double[] z = new double[this.numTopics];
            double[] w = new double[this.numTopics];
            for (int k = 0; k < this.numTopics; ++k) {
                w[k] = this.alpha / firstDenom * topicassigns[firstToken][k] * this.probUni(this.timeToNextTime.get(this.currentTime), this.currentTime);
                if (this.cond) {
                    norm += this.alpha / firstDenom * this.probUni(this.timeToNextTime.get(this.currentTime), this.currentTime);
                    continue;
                }
                norm = 1.0;
            }
            double firstS = 0.0;
            int k = 0;
            while (k < this.numTopics) {
                int n = k++;
                w[n] = w[n] / norm;
            }
            for (k = 0; k < this.numTopics; ++k) {
                firstS += w[k];
            }
            ll = Math.log(firstS);
            for (k = 0; k < this.numTopics; ++k) {
                z[k] = w[k];
            }
            for (int n = 1; n < list.size(); ++n) {
                int nextToken = list.get(n);
                norm = 0.0;
                for (int k2 = 0; k2 < this.numTopics; ++k2) {
                    double denom = 0.0;
                    for (int k22 = 0; k22 < this.numTopics; ++k22) {
                        denom += this.alpha + z[k22];
                    }
                    w[k2] = (this.alpha + z[k2]) / denom * topicassigns[nextToken][k2] * this.probUni(this.timeToNextTime.get(this.currentTime), this.currentTime);
                    if (this.cond) {
                        norm += (this.alpha + z[k2]) / denom * this.probUni(this.timeToNextTime.get(this.currentTime), this.currentTime);
                        continue;
                    }
                    norm = 1.0;
                }
                double S = 0.0;
                int k3 = 0;
                while (k3 < this.numTopics) {
                    int n2 = k3++;
                    w[n2] = w[n2] / norm;
                }
                for (k3 = 0; k3 < this.numTopics; ++k3) {
                    S += w[k3];
                }
                ll += Math.log(S);
                for (k3 = 0; k3 < this.numTopics; ++k3) {
                    int n3 = k3;
                    w[n3] = w[n3] / S;
                    int n4 = k3;
                    z[n4] = z[n4] + w[k3];
                }
            }
            perplexity += ll;
        }
        return perplexity;
    }

    public double getLDAPerplexity(TIntArrayList[] documentTokens, double[][] topicassigns) {
        double perplexity = 0.0;
        boolean allCounts = false;
        double ll = 0.0;
        for (int i = 0; i < documentTokens.length; ++i) {
            int k;
            TIntArrayList list = documentTokens[i];
            if (list == null) continue;
            list.shuffle(this.rn);
            int firstToken = list.get(0);
            double firstDenom = 0.0;
            for (int k2 = 0; k2 < this.numTopics; ++k2) {
                firstDenom += this.alpha;
            }
            double[] z = new double[this.numTopics];
            double[] w = new double[this.numTopics];
            for (int k2 = 0; k2 < this.numTopics; ++k2) {
                w[k2] = this.alpha / firstDenom * topicassigns[firstToken][k2];
            }
            double firstS = 0.0;
            for (k = 0; k < this.numTopics; ++k) {
                firstS += w[k];
            }
            ll = Math.log(firstS);
            for (k = 0; k < this.numTopics; ++k) {
                z[k] = w[k];
            }
            for (int n = 1; n < list.size(); ++n) {
                int k3;
                int nextToken = list.get(n);
                for (int k4 = 0; k4 < this.numTopics; ++k4) {
                    double denom = 0.0;
                    for (int k2 = 0; k2 < this.numTopics; ++k2) {
                        denom += this.alpha + z[k2];
                    }
                    w[k4] = (this.alpha + z[k4]) / denom * topicassigns[nextToken][k4];
                }
                double S = 0.0;
                for (k3 = 0; k3 < this.numTopics; ++k3) {
                    S += w[k3];
                }
                ll += Math.log(S);
                for (k3 = 0; k3 < this.numTopics; ++k3) {
                    int n2 = k3;
                    w[n2] = w[n2] / S;
                    int n3 = k3;
                    z[n3] = z[n3] + w[k3];
                }
            }
            perplexity += ll;
        }
        return perplexity;
    }

    public void doWork() throws OperatorException {
        int i;
        this.iters = this.getParameterAsInt(PARAMETER_NUMITERATIONS);
        this.numTopics = this.getParameterAsInt(PARAMETER_NUMTOPICS);
        this.alpha = this.getParameterAsDouble(PARAMETER_ALPHA);
        int numTests = this.getParameterAsInt(PARAMETER_NUMTESTS);
        this.cond = this.getParameterAsBoolean(PARAMETER_CONDITIONAL);
        boolean locSeed = this.getParameterAsBoolean("use_local_random_seed");
        int seed = this.getParameterAsInt("local_random_seed");
        this.rn = locSeed ? new Random(seed) : new Random();
        ArrayList<Attribute> attributeList = new ArrayList<Attribute>();
        attributeList.add(AttributeFactory.createAttribute((String)"negloglikelihood", (int)2));
        MemoryExampleTable table = new MemoryExampleTable(attributeList);
        DataRowFactory factory = new DataRowFactory(0, '.');
        int numWords = 0;
        ExampleSet exampleSet = (ExampleSet)this.input.getData(ExampleSet.class);
        Example ex = exampleSet.getExample(0);
        Attributes attr = ex.getAttributes();
        numWords = attr.size();
        TIntArrayList[] documentTokens = new TIntArrayList[exampleSet.size()];
        double[] labels = null;
        if (attr.getLabel() != null) {
            labels = new double[exampleSet.size()];
        }
        int next = 0;
        TDoubleArrayList times = new TDoubleArrayList();
        for (i = 0; i < exampleSet.size(); ++i) {
            TIntArrayList list = new TIntArrayList();
            ex = exampleSet.getExample(i);
            attr = ex.getAttributes();
            if (attr.getLabel() != null) {
                labels[i] = ex.getLabel();
                times.add(labels[i]);
                if (labels[i] > this.maxTime) {
                    this.maxTime = labels[i];
                }
            }
            int j = 0;
            for (Attribute att : attr) {
                double frequ = 0.0;
                frequ = ex.getValue(att);
                if (frequ != 0.0) {
                    for (int k = 0; k < (int)frequ; ++k) {
                        list.add(j);
                    }
                }
                ++j;
            }
            if (list.size() <= 1) continue;
            documentTokens[next] = list;
            documentTokens[next].shuffle(this.rn);
            ++next;
        }
        times.sort();
        if (times.size() >= 1) {
            this.timeToNextTime.put(times.get(0), 0.0);
        }
        this.sortedTimeSteps.add(0.0);
        for (i = 1; i < times.size(); ++i) {
            if (times.get(i) == times.get(i - 1)) continue;
            this.timeToNextTime.put(times.get(i), times.get(i - 1));
            this.timeStep = times.get(i) - times.get(i - 1);
            this.sortedTimeSteps.add(times.get(i));
        }
        ExampleSet examplesProbs = (ExampleSet)this.inputWords.getData(ExampleSet.class);
        Example ex2 = examplesProbs.getExample(0);
        Attributes atts = ex.getAttributes();
        this.numTopics = 0;
        ex2 = examplesProbs.getExample(0);
        atts = ex2.getAttributes();
        for (Attribute att : atts) {
            if (!att.getName().contains("Topic_")) continue;
            ++this.numTopics;
        }
        numWords = examplesProbs.size();
        double[][] topicassigns = new double[numWords][this.numTopics];
        for (int i2 = 0; i2 < examplesProbs.size(); ++i2) {
            ex2 = examplesProbs.getExample(i2);
            atts = ex2.getAttributes();
            int j = 0;
            for (Attribute att : atts) {
                if (!att.getName().contains("Topic_")) continue;
                topicassigns[i2][j] = ex2.getValue(att);
                ++j;
            }
        }
        ExampleSet examplesParas = (ExampleSet)this.inputParameters.getDataOrNull(ExampleSet.class);
        double[][] parameters = null;
        if (examplesParas != null) {
            parameters = new double[examplesParas.size()][2];
            for (int i3 = 0; i3 < examplesParas.size(); ++i3) {
                ex2 = examplesParas.getExample(i3);
                atts = ex2.getAttributes();
                for (Attribute att : atts) {
                    if (att.getName().contains("alpha")) {
                        parameters[i3][0] = ex2.getValue(att);
                    }
                    if (!att.getName().contains("beta")) continue;
                    parameters[i3][1] = ex2.getValue(att);
                }
            }
        }
        for (int i4 = 0; i4 < documentTokens.length; ++i4) {
            double time = labels[i4];
            TIntArrayList list = documentTokens[i4];
            if (list == null) continue;
            for (int n = 1; n < list.size(); ++n) {
                ++this.sum;
                int c = 1;
                if (this.timeMap.contains(time)) {
                    c += this.timeMap.get(time);
                }
                this.timeMap.put(time, c);
            }
        }
        boolean supervised = this.getParameterAsBoolean(PARAMETER_SUPER);
        int l = this.getParameterAsInt(PARAMETER_LABEL);
        for (int te = 0; te < numTests; ++te) {
            double perplexity = 0.0;
            perplexity = supervised && parameters != null && labels != null ? (l == GOMPERTZ || l == GOMPERTZUNI ? this.getGompertzLDAPerplexity(documentTokens, topicassigns, parameters, labels) : (l == BETA ? this.getBetaLDAPerplexity(documentTokens, topicassigns, parameters, labels) : this.getUniformLDAPerplexity(documentTokens, topicassigns, parameters, labels))) : (l == UNI ? this.getUniformLDAPerplexity(documentTokens, topicassigns, parameters, labels) : this.getLDAPerplexity(documentTokens, topicassigns));
            System.out.println(perplexity);
            DataRow row = factory.create(table.getNumberOfAttributes());
            table.addDataRow(row);
            row.set((Attribute)attributeList.get(0), perplexity);
        }
        SimpleExampleSet set = new SimpleExampleSet((ExampleTable)table);
        this.output.deliver((IOObject)set);
    }

    public int[] getDiscrete(int num, double[] probs) {
        int i;
        double sum = 0.0;
        for (i = 0; i < probs.length; ++i) {
            sum += probs[i];
        }
        i = 0;
        while (i < probs.length) {
            int n = i++;
            probs[n] = probs[n] / sum;
        }
        double pr = 0.0;
        int[] res = new int[num];
        for (int i2 = 0; i2 < num; ++i2) {
            int j = 0;
            double p = this.rn.nextDouble();
            for (pr = probs[0]; pr < p; pr += probs[++j]) {
            }
            res[i2] = j;
        }
        return res;
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeInt(PARAMETER_NUMITERATIONS, "Number of Iterations for Samplings.", 1, Integer.MAX_VALUE, 2000));
        types.add(new ParameterTypeInt(PARAMETER_NUMTESTS, "Number of Iterations for Samplings.", 1, Integer.MAX_VALUE, 20));
        types.add(new ParameterTypeInt(PARAMETER_NUMTOPICS, "Number of Topics.", 1, Integer.MAX_VALUE, 5));
        types.add(new ParameterTypeDouble(PARAMETER_ALPHA, "Alpha", 0.0, Double.MAX_VALUE, 0.25));
        types.add(new ParameterTypeBoolean(PARAMETER_SUPER, "Perform supervised LDA with numinal (Gaussian) or numeric (Beta) labels. ", false, false));
        ParameterTypeCategory type = new ParameterTypeCategory(PARAMETER_LABEL, "Label distribution.", label, GAUSSIAN);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_CONDITIONAL, "Use conditional distribution instead of joint distribution. ", false, false));
        types.addAll(RandomGenerator.getRandomGeneratorParameters((Operator)this));
        return types;
    }

    public static void main(String[] args) {
    }
}

