/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.kobra.topicmodels;

import com.rapidminer.kobra.data.CCSMatrix;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDirectory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.RandomGenerator;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class LDABaseOperator
extends Operator {
    static String PARAMETER_NUMITERATIONS = "iterations";
    static String PARAMETER_NUMTOPICS = "number_of_topics";
    static String PARAMETER_ALPHA = "alpha";
    int iters = 2000;
    int numTopics = 4;
    double alpha = 0.25;
    static String PARAMETER_DFR = "dfr";
    static String PARAMETER_PATH = "path";
    String path = "/home/poelitz/work/Datasets/ResultData/acl2015/";
    int seed = 1992;
    boolean locSeed = false;
    protected final InputPort input = (InputPort)this.getInputPorts().createPort("example set of documents as Bag-of-Words vectors with term occurrences");
    protected final OutputPort outputWords = (OutputPort)this.getOutputPorts().createPort("example set of word distributions for the topics");
    protected final OutputPort outputDocs = (OutputPort)this.getOutputPorts().createPort("example set of topic distributions for the documents");
    int topK = 40;

    public LDABaseOperator(OperatorDescription description) {
        super(description);
    }

    public void writeDT(int[] topics, double[] pr) {
        String r = "{";
        String i = "\"i\":[" + topics[0];
        String p = "\"p\":[0";
        String x = "\"x\":[" + pr[0];
        for (int d = 1; d < topics.length; ++d) {
            i = i + "," + topics[d];
            p = p + "," + d;
            x = x + "," + (int)(pr[d] * 1000.0);
        }
        r = r + i + "]," + p + "]," + x + "]}";
        System.out.println(r);
    }

    public void writeDT(double[][] td) {
        double[][] dt = new double[td[0].length][td.length];
        for (int i = 0; i < dt.length; ++i) {
            for (int j = 0; j < dt[i].length; ++j) {
                dt[i][j] = (int)(td[j][i] * 100.0);
            }
        }
        CCSMatrix ma = CCSMatrix.from2DArray(dt);
        int[] cp = ma.columnPointers;
        int[] ri = ma.rowIndices;
        double[] v = ma.values;
        String file = this.path + "dt.json";
        String r = "{";
        String i = "\"i\": [" + ri[0] + " ";
        for (int ind = 1; ind < ri.length; ++ind) {
            i = i + ", " + ri[ind];
        }
        String p = "\"p\": [" + cp[0] + " ";
        for (int poi = 1; poi < cp.length; ++poi) {
            p = p + ", " + cp[poi];
        }
        String x = "\"x\": [" + (int)v[0] + " ";
        for (int val = 1; val < v.length; ++val) {
            x = x + ", " + (int)v[val];
        }
        r = r + i + "]," + p + "]," + x + "]}";
        this.writeAndZip(r, file);
    }

    public void writeAndZip(String r, String file) {
        Writer bw = null;
        try {
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            bw.write(r);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            ((BufferedWriter)bw).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            int count;
            BufferedInputStream origin = null;
            FileOutputStream dest = new FileOutputStream(file + ".zip");
            ZipOutputStream out2 = new ZipOutputStream(new BufferedOutputStream(dest));
            byte[] data = new byte[2048];
            FileInputStream fi = new FileInputStream(file);
            origin = new BufferedInputStream(fi, 2048);
            ZipEntry entry = new ZipEntry(file.substring(file.lastIndexOf("/") + 1, file.length()));
            out2.putNextEntry(entry);
            while ((count = origin.read(data, 0, 2048)) != -1) {
                out2.write(data, 0, count);
            }
            origin.close();
            out2.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeTopWords(String[] words, double[][] tw) {
        int t;
        Word[][] myWords = new Word[tw.length][tw[0].length];
        for (t = 0; t < tw.length; ++t) {
            for (int i = 0; i < tw[t].length; ++i) {
                Word w = new Word();
                w.id = i;
                w.weight = tw[t][i];
                w.word = words[i];
                myWords[t][i] = w;
            }
        }
        for (t = 0; t < tw.length; ++t) {
            Object[] tmp = myWords[t];
            Arrays.sort(tmp);
        }
        try {
            PrintStream ps = new PrintStream((OutputStream)new FileOutputStream(this.path + "topWords.txt", false), true, "UTF-8");
            System.setOut(ps);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < this.topK && i < words.length; ++i) {
            String next = "";
            for (int t2 = 0; t2 < tw.length; ++t2) {
                next = next + t2 + "," + myWords[t2][i].toString() + ",";
            }
            System.out.println(next);
        }
        System.setOut(System.out);
    }

    public void writeTW(String[] words, double[][] tw, double alpha) {
        int t;
        String twS = "\"tw\":[";
        String alphaS = "{\"alpha\":[" + alpha;
        for (t = 1; t < tw.length; ++t) {
            alphaS = alphaS + "," + alpha;
        }
        for (t = 0; t < tw.length; ++t) {
            double[] w = new double[tw[t].length];
            for (int i = 0; i < tw[t].length; ++i) {
                w[i] = tw[t][i];
            }
            Arrays.sort(w);
            if (this.topK >= w.length) {
                // empty if block
            }
            double min = w[w.length - this.topK];
            String wordsS = "\"words\":[";
            String weightsS = "{\"weights\":[";
            for (int i = 0; i < tw[t].length; ++i) {
                if (!(tw[t][i] >= min)) continue;
                wordsS = wordsS + "\"" + words[i] + "\",";
                weightsS = weightsS + tw[t][i] + ",";
            }
            wordsS = wordsS.substring(0, wordsS.length() - 1);
            wordsS = wordsS + "]}";
            weightsS = weightsS.substring(0, weightsS.length() - 1);
            weightsS = weightsS + "],";
            twS = twS + weightsS + wordsS + ",";
        }
        alphaS = alphaS + "],";
        twS = twS.substring(0, twS.length() - 1);
        String r = alphaS + twS + "]}";
        this.writeAndZip(r, this.path + "tw.json");
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeInt(PARAMETER_NUMITERATIONS, "Number of Iterations for Gibbs Sampling. If zero, we perform variational inference.", 0, Integer.MAX_VALUE, 2000));
        types.add(new ParameterTypeInt(PARAMETER_NUMTOPICS, "Number of Topics.", 1, Integer.MAX_VALUE, 5));
        types.add(new ParameterTypeDouble(PARAMETER_ALPHA, "Alpha parameter for Dirichlet", 0.0, Double.MAX_VALUE, 0.25));
        types.add(new ParameterTypeBoolean(PARAMETER_DFR, "Write results out for dfr browser", true, false));
        types.add(new ParameterTypeDirectory(PARAMETER_PATH, "Path for dfr files.", "/home/poelitz/work/Datasets/ResultData/acl2015/"));
        types.addAll(RandomGenerator.getRandomGeneratorParameters((Operator)this));
        return types;
    }

    public static void main(String[] args) {
    }

    class Word
    implements Comparable<Word> {
        public String word = "";
        public double weight = 0.0;
        public int id = -1;

        Word() {
        }

        @Override
        public int compareTo(Word o) {
            if (this.weight == o.weight) {
                return -this.word.compareTo(o.word);
            }
            return this.weight < o.weight ? 1 : -1;
        }

        public String toString() {
            return this.word + "," + this.weight;
        }
    }
}

