/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.kobra.topicmodels;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SimpleExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DataRowFactory;
import com.rapidminer.example.table.ExampleTable;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.kobra.topicmodels.LDABaseOperator;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDirectory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.RandomGenerator;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class FactorModelsMatlabOperator
extends LDABaseOperator {
    static String PARAMETER_BETA = "beta";
    static String SCRIPT_PATH = "script";
    static String PATH_DATA = "data_path";
    static String PARAMETER_TEXT = "text attribute";
    public static final String PARAMETER_ENCODING = "encoding";
    public static final String[] ENCODINGS = new String[]{"US-ASCII", "ISO-8859-1", "UTF-8", "UTF-16"};
    double beta = 0.1;

    public FactorModelsMatlabOperator(OperatorDescription description) {
        super(description);
    }

    public void doWork() throws OperatorException {
        int i;
        int j;
        boolean locSeed = this.getParameterAsBoolean("use_local_random_seed");
        int seed = this.getParameterAsInt("local_random_seed");
        this.iters = this.getParameterAsInt(PARAMETER_NUMITERATIONS);
        this.numTopics = this.getParameterAsInt(PARAMETER_NUMTOPICS);
        this.alpha = this.getParameterAsDouble(PARAMETER_ALPHA);
        this.beta = this.getParameterAsDouble(PARAMETER_BETA);
        this.path = this.getParameter(PARAMETER_PATH);
        String encode = this.getParameterAsString(PARAMETER_ENCODING);
        String path_data = this.getParameterAsString(PATH_DATA);
        boolean bow = true;
        String t_att = "";
        try {
            t_att = this.getParameterAsString(PARAMETER_TEXT);
        }
        catch (Exception e) {
            // empty catch block
        }
        TIntArrayList wordToken = new TIntArrayList();
        TIntArrayList docToken = new TIntArrayList();
        int numWords = 0;
        ExampleSet exampleSet = (ExampleSet)this.input.getDataOrNull(ExampleSet.class);
        if (exampleSet != null) {
            Example ex = exampleSet.getExample(0);
            Attributes attr = ex.getAttributes();
            numWords = attr.size();
            String[] words = new String[numWords];
            double[] labels = null;
            if (attr.getLabel() != null) {
                labels = new double[exampleSet.size()];
            }
            int[] doc_lengths = new int[exampleSet.size()];
            BufferedWriter wr = null;
            BufferedWriter wr_labels = null;
            try {
                wr = new BufferedWriter(new FileWriter(path_data + "/texts.csv"));
                wr_labels = new BufferedWriter(new FileWriter(path_data + "/labels.csv"));
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            ex = exampleSet.getExample(0);
            attr = ex.getAttributes();
            for (Attribute att : attr) {
                if (!Ontology.ATTRIBUTE_VALUE_TYPE.isA(att.getValueType(), 5)) continue;
                bow = false;
            }
            TObjectIntHashMap wordToIdx = new TObjectIntHashMap();
            for (int i2 = 0; i2 < exampleSet.size(); ++i2) {
                String next = "";
                ex = exampleSet.getExample(i2);
                attr = ex.getAttributes();
                String nextWord = "";
                int index = 0;
                if (bow) {
                    for (Attribute att : attr) {
                        if (ex.getValue(att) == 0.0) continue;
                        double mult = ex.getValue(att);
                        next = next + i2 + ", " + index + ", " + mult + "\n";
                        ++index;
                    }
                    if (next.length() == 0) {
                        next = i2 + ", " + "0, " + "0";
                    }
                }
                try {
                    wr.write(next);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                int docId = i2;
                if (attr.getLabel() == null) continue;
                try {
                    wr_labels.write(ex.getLabel() + "\n");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                labels[i2] = ex.getLabel();
            }
            try {
                wr.close();
                wr_labels.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        String pythonScriptPath = this.getParameter(SCRIPT_PATH);
        String[] cmd = new String[]{"python", pythonScriptPath, path_data, "" + this.numTopics, locSeed ? "" + seed : "1992", "" + this.alpha, "" + this.beta, "" + this.iters};
        for (int i3 = 0; i3 < cmd.length; ++i3) {
            System.out.print(cmd[i3] + " ");
        }
        System.out.println();
        Runtime rt = Runtime.getRuntime();
        Process pr = null;
        try {
            pr = rt.exec(cmd);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        boolean dfr = this.getParameterAsBoolean(PARAMETER_DFR);
        double[][] probs = null;
        int numDocs = 0;
        BufferedReader reader = null;
        try {
            int D;
            reader = new BufferedReader(new InputStreamReader(pr.getInputStream(), encode));
            numDocs = D = Integer.parseInt(reader.readLine());
            int K = Integer.parseInt(reader.readLine());
            probs = new double[K][D];
            for (int i4 = 0; i4 < D; ++i4) {
                for (int j2 = 0; j2 < K; ++j2) {
                    probs[j2][i4] = Double.parseDouble(reader.readLine());
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (dfr) {
            this.writeDT(probs);
        }
        ArrayList<Attribute> attributeList = new ArrayList<Attribute>();
        attributeList.add(AttributeFactory.createAttribute((String)"Doc", (int)2));
        attributeList.add(AttributeFactory.createAttribute((String)"Topic", (int)2));
        for (int i5 = 0; i5 < this.numTopics; ++i5) {
            attributeList.add(AttributeFactory.createAttribute((String)("Topic_" + i5), (int)2));
        }
        MemoryExampleTable table = new MemoryExampleTable(attributeList);
        DataRowFactory factory = new DataRowFactory(0, '.');
        for (int i6 = 0; i6 < numDocs; ++i6) {
            DataRow row = factory.create(table.getNumberOfAttributes());
            table.addDataRow(row);
            row.set((Attribute)attributeList.get(0), (double)(i6 + 1));
            int top = -1;
            double max = 0.0;
            for (j = 0; j < this.numTopics; ++j) {
                if (probs[j][i6] > max) {
                    max = probs[j][i6];
                    top = j;
                }
                row.set((Attribute)attributeList.get(2 + j), probs[j][i6]);
            }
            row.set((Attribute)attributeList.get(1), (double)top);
        }
        SimpleExampleSet set = new SimpleExampleSet((ExampleTable)table);
        this.outputDocs.deliver((IOObject)set);
        String[] words = null;
        try {
            int i7;
            int V = Integer.parseInt(reader.readLine());
            int K = Integer.parseInt(reader.readLine());
            probs = new double[K][V];
            for (i7 = 0; i7 < V; ++i7) {
                for (j = 0; j < K; ++j) {
                    probs[j][i7] = Double.parseDouble(reader.readLine());
                }
            }
            numWords = V = Integer.parseInt(reader.readLine());
            words = new String[V];
            for (i7 = 0; i7 < V; ++i7) {
                words[i7] = reader.readLine();
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (dfr) {
            this.writeTW(words, probs, this.alpha);
            this.writeTopWords(words, probs);
        }
        attributeList = new ArrayList();
        attributeList.add(AttributeFactory.createAttribute((String)"Word", (int)5));
        attributeList.add(AttributeFactory.createAttribute((String)"Word_id", (int)2));
        attributeList.add(AttributeFactory.createAttribute((String)"Topic", (int)2));
        for (i = 0; i < this.numTopics; ++i) {
            attributeList.add(AttributeFactory.createAttribute((String)("Topic_" + i), (int)2));
        }
        table = new MemoryExampleTable(attributeList);
        factory = new DataRowFactory(0, '.');
        for (i = 0; i < numWords; ++i) {
            DataRow row = factory.create(table.getNumberOfAttributes());
            table.addDataRow(row);
            row.set((Attribute)attributeList.get(0), (double)((Attribute)attributeList.get(0)).getMapping().mapString(words[i]));
            row.set((Attribute)attributeList.get(1), (double)(i + 1));
            int top = -1;
            double max = 0.0;
            for (int j3 = 0; j3 < this.numTopics; ++j3) {
                if (probs[j3][i] > max) {
                    max = probs[j3][i];
                    top = j3;
                }
                row.set((Attribute)attributeList.get(3 + j3), probs[j3][i]);
            }
            row.set((Attribute)attributeList.get(2), (double)top);
        }
        set = new SimpleExampleSet((ExampleTable)table);
        this.outputWords.deliver((IOObject)set);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        ArrayList<ParameterType> types = new ArrayList<ParameterType>();
        types.add((ParameterType)new ParameterTypeString(PARAMETER_TEXT, "Attribute name for text", "text_attr"));
        types.add((ParameterType)new ParameterTypeInt(PARAMETER_NUMITERATIONS, "Number of Iterations for Gibbs Sampling. If zero, we perform variational inference.", 0, Integer.MAX_VALUE, 2000));
        types.add((ParameterType)new ParameterTypeInt(PARAMETER_NUMTOPICS, "Number of Topics.", 1, Integer.MAX_VALUE, 5));
        types.add((ParameterType)new ParameterTypeDouble(PARAMETER_ALPHA, "Alpha parameter for Dirichlet", 0.0, Double.MAX_VALUE, 0.25));
        types.add((ParameterType)new ParameterTypeDouble(PARAMETER_BETA, "Beta parameter for Dirichlet", 0.0, Double.MAX_VALUE, 0.1));
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_DFR, "Write results out for dfr browser", true, false));
        types.add((ParameterType)new ParameterTypeDirectory(PARAMETER_PATH, "Path for dfr files.", "/home/poelitz/work/Datasets/ResultData/acl2015/"));
        types.add((ParameterType)new ParameterTypeDirectory(PATH_DATA, "Path for data files.", "/home/poelitz/work/Datasets/ResultData/TM"));
        types.add((ParameterType)new ParameterTypeFile(SCRIPT_PATH, "Python scrips", ".py", "/home/poelitz/work/python/buildCorpusAndOnlineLDA.py"));
        types.add((ParameterType)new ParameterTypeStringCategory(PARAMETER_ENCODING, "The encoding of the texts.", ENCODINGS, ENCODINGS[1]));
        types.addAll(RandomGenerator.getRandomGeneratorParameters((Operator)this));
        return types;
    }

    public static void main(String[] args) {
    }
}

