/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.kobra.data;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import org.la4j.Matrices;
import org.la4j.Matrix;
import org.la4j.Vector;
import org.la4j.iterator.ColumnMajorMatrixIterator;
import org.la4j.iterator.VectorIterator;
import org.la4j.matrix.ColumnMajorSparseMatrix;
import org.la4j.matrix.MatrixFactory;
import org.la4j.matrix.functor.MatrixFunction;
import org.la4j.matrix.functor.MatrixProcedure;
import org.la4j.vector.functor.VectorProcedure;
import org.la4j.vector.sparse.CompressedVector;

public class CCSMatrix
extends ColumnMajorSparseMatrix {
    private static final byte MATRIX_TAG = 48;
    private static final int MINIMUM_SIZE = 32;
    public double[] values;
    public int[] rowIndices;
    public int[] columnPointers;

    public static CCSMatrix zero(int rows, int columns) {
        return new CCSMatrix(rows, columns);
    }

    public static CCSMatrix zero(int rows, int columns, int capacity) {
        return new CCSMatrix(rows, columns, capacity);
    }

    public static CCSMatrix diagonal(int size, double diagonal) {
        double[] values = new double[size];
        int[] rowIndices = new int[size];
        int[] columnPointers = new int[size + 1];
        for (int i = 0; i < size; ++i) {
            rowIndices[i] = i;
            columnPointers[i] = i;
            values[i] = diagonal;
        }
        columnPointers[size] = size;
        return new CCSMatrix(size, size, size, values, rowIndices, columnPointers);
    }

    public static CCSMatrix identity(int size) {
        return CCSMatrix.diagonal(size, 1.0);
    }

    public static CCSMatrix random(int rows, int columns, double density, Random random) {
        if (density < 0.0 || density > 1.0) {
            throw new IllegalArgumentException("The density value should be between 0 and 1.0");
        }
        int cardinality = Math.max((int)((double)(rows * columns) * density), columns);
        double[] values = new double[cardinality];
        int[] rowIndices = new int[cardinality];
        int[] columnPointers = new int[columns + 1];
        int kk = cardinality / columns;
        int[] indices = new int[kk];
        int k = 0;
        for (int j = 0; j < columns; ++j) {
            columnPointers[j] = k;
            for (int jj = 0; jj < kk; ++jj) {
                indices[jj] = random.nextInt(rows);
            }
            Arrays.sort(indices);
            int previous = -1;
            for (int jj = 0; jj < kk; ++jj) {
                if (indices[jj] == previous) continue;
                values[k] = random.nextDouble();
                rowIndices[k++] = indices[jj];
                previous = indices[jj];
            }
        }
        columnPointers[columns] = cardinality;
        return new CCSMatrix(rows, columns, cardinality, values, rowIndices, columnPointers);
    }

    public static CCSMatrix randomSymmetric(int size, double density, Random random) {
        int cardinality = (int)((double)(size * size) * density);
        CCSMatrix matrix = new CCSMatrix(size, size, cardinality);
        for (int k = 0; k < cardinality / 2; ++k) {
            int i = random.nextInt(size);
            int j = random.nextInt(size);
            double value = random.nextDouble();
            matrix.set(i, j, value);
            matrix.set(j, i, value);
        }
        return matrix;
    }

    public static CCSMatrix from1DArray(int rows, int columns, double[] array) {
        CCSMatrix result = CCSMatrix.zero(rows, columns);
        for (int j = 0; j < columns; ++j) {
            for (int i = 0; i < rows; ++i) {
                int k = i * columns + j;
                if (array[k] == 0.0) continue;
                result.set(i, j, array[k]);
            }
        }
        return result;
    }

    public static CCSMatrix from2DArray(double[][] array) {
        int rows = array.length;
        int columns = array[0].length;
        CCSMatrix result = CCSMatrix.zero(rows, columns);
        for (int j = 0; j < columns; ++j) {
            for (int i = 0; i < rows; ++i) {
                if (array[i][j] == 0.0) continue;
                result.set(i, j, array[i][j]);
            }
        }
        return result;
    }

    public static CCSMatrix block(Matrix a, Matrix b, Matrix c, Matrix d) {
        if (a.rows() != b.rows() || a.columns() != c.columns() || c.rows() != d.rows() || b.columns() != d.columns()) {
            throw new IllegalArgumentException("Sides of blocks are incompatible!");
        }
        int rows = a.rows() + c.rows();
        int columns = a.columns() + b.columns();
        ArrayList<Double> values = new ArrayList<Double>();
        ArrayList<Integer> rowIndices = new ArrayList<Integer>();
        int[] columnPointers = new int[rows + 1];
        int k = 0;
        columnPointers[0] = 0;
        double current = 0.0;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                if (i < a.rows() && j < a.columns()) {
                    current = a.get(i, j);
                }
                if (i < a.rows() && j > a.columns()) {
                    current = b.get(i, j);
                }
                if (i > a.rows() && j < a.columns()) {
                    current = c.get(i, j);
                }
                if (i > a.rows() && j > a.columns()) {
                    current = d.get(i, j);
                }
                if (!(Math.abs(current) > Matrices.EPS)) continue;
                values.add(current);
                rowIndices.add(j);
                ++k;
            }
            columnPointers[i + 1] = k;
        }
        double[] valuesArray = new double[values.size()];
        int[] rowIndArray = new int[rowIndices.size()];
        for (int i = 0; i < values.size(); ++i) {
            valuesArray[i] = (Double)values.get(i);
            rowIndArray[i] = (Integer)rowIndices.get(i);
        }
        return new CCSMatrix(rows, columns, k, valuesArray, rowIndArray, columnPointers);
    }

    public static CCSMatrix fromBinary(byte[] array) {
        int i;
        ByteBuffer buffer = ByteBuffer.wrap(array);
        if (buffer.get() != 48) {
            throw new IllegalArgumentException("Can not decode CCSMatrix from the given byte array.");
        }
        int rows = buffer.getInt();
        int columns = buffer.getInt();
        int cardinality = buffer.getInt();
        int[] rowIndices = new int[cardinality];
        double[] values = new double[cardinality];
        int[] columnsPointers = new int[columns + 1];
        for (i = 0; i < cardinality; ++i) {
            rowIndices[i] = buffer.getInt();
            values[i] = buffer.getDouble();
        }
        for (i = 0; i < columns + 1; ++i) {
            columnsPointers[i] = buffer.getInt();
        }
        return new CCSMatrix(rows, columns, cardinality, values, rowIndices, columnsPointers);
    }

    public CCSMatrix() {
        this(0, 0);
    }

    public CCSMatrix(int rows, int columns) {
        this(rows, columns, 0);
    }

    public CCSMatrix(int rows, int columns, int capacity) {
        super(rows, columns);
        this.ensureCardinalityIsCorrect(rows, columns, capacity);
        int alignedSize = this.align(capacity);
        this.values = new double[alignedSize];
        this.rowIndices = new int[alignedSize];
        this.columnPointers = new int[columns + 1];
    }

    public CCSMatrix(int rows, int columns, int cardinality, double[] values, int[] rowIndices, int[] columnPointers) {
        super(rows, columns, cardinality);
        this.ensureCardinalityIsCorrect(rows, columns, cardinality);
        this.values = values;
        this.rowIndices = rowIndices;
        this.columnPointers = columnPointers;
    }

    @Override
    public double getOrElse(int i, int j, double defaultValue) {
        this.ensureIndexesAreInBounds(i, j);
        int k = this.searchForRowIndex(i, this.columnPointers[j], this.columnPointers[j + 1]);
        if (k < this.columnPointers[j + 1] && this.rowIndices[k] == i) {
            return this.values[k];
        }
        return defaultValue;
    }

    @Override
    public void set(int i, int j, double value) {
        this.ensureIndexesAreInBounds(i, j);
        int k = this.searchForRowIndex(i, this.columnPointers[j], this.columnPointers[j + 1]);
        if (k < this.columnPointers[j + 1] && this.rowIndices[k] == i) {
            if (value == 0.0) {
                this.remove(k, j);
            } else {
                this.values[k] = value;
            }
        } else {
            this.insert(k, i, j, value);
        }
    }

    @Override
    public void setAll(double value) {
        if (value == 0.0) {
            this.cardinality = 0;
        } else {
            int size = (int)this.capacity();
            if (this.values.length < size) {
                this.values = new double[size];
                this.rowIndices = new int[size];
                this.columnPointers = new int[this.columns + 1];
            }
            for (int j = 0; j < this.columns; ++j) {
                for (int i = 0; i < this.rows; ++i) {
                    this.values[j * this.rows + i] = value;
                    this.rowIndices[j * this.rows + i] = i;
                }
                this.columnPointers[j] = this.rows * j;
            }
            this.columnPointers[this.columns] = size;
            this.cardinality = size;
        }
    }

    @Override
    public Vector getColumn(int j) {
        int columnCardinality = this.columnPointers[j + 1] - this.columnPointers[j];
        double[] columnValues = new double[columnCardinality];
        int[] columnIndices = new int[columnCardinality];
        System.arraycopy(this.values, this.columnPointers[j], columnValues, 0, columnCardinality);
        System.arraycopy(this.rowIndices, this.columnPointers[j], columnIndices, 0, columnCardinality);
        return new CompressedVector(this.rows, columnCardinality, columnValues, columnIndices);
    }

    @Override
    public Vector getRow(int i) {
        CompressedVector result = CompressedVector.zero(this.columns);
        int j = 0;
        while (this.columnPointers[j] < this.cardinality) {
            int k = this.searchForRowIndex(i, this.columnPointers[j], this.columnPointers[j + 1]);
            if (k < this.columnPointers[j + 1] && this.rowIndices[k] == i) {
                ((Vector)result).set(j, this.values[k]);
            }
            ++j;
        }
        return result;
    }

    @Override
    public Matrix copyOfShape(int rows, int columns) {
        int j;
        this.ensureDimensionsAreCorrect(rows, columns);
        if (rows >= this.rows && columns >= this.columns) {
            double[] $values = new double[this.align(this.cardinality)];
            int[] $rowIndices = new int[this.align(this.cardinality)];
            int[] $columnPointers = new int[columns + 1];
            System.arraycopy(this.values, 0, $values, 0, this.cardinality);
            System.arraycopy(this.rowIndices, 0, $rowIndices, 0, this.cardinality);
            System.arraycopy(this.columnPointers, 0, $columnPointers, 0, this.columns + 1);
            for (int i = this.columns; i < columns + 1; ++i) {
                $columnPointers[i] = this.cardinality;
            }
            return new CCSMatrix(rows, columns, this.cardinality, $values, $rowIndices, $columnPointers);
        }
        double[] $values = new double[this.align(this.cardinality)];
        int[] $rowIndices = new int[this.align(this.cardinality)];
        int[] $columnPointers = new int[columns + 1];
        int $cardinality = 0;
        int k = 0;
        for (j = 0; k < this.cardinality && j < columns; ++j) {
            $columnPointers[j] = $cardinality;
            int i = this.columnPointers[j];
            while (i < this.columnPointers[j + 1] && this.rowIndices[i] < rows) {
                $values[$cardinality] = this.values[i];
                $rowIndices[$cardinality] = this.rowIndices[i];
                ++$cardinality;
                ++i;
                ++k;
            }
        }
        while (j < columns + 1) {
            $columnPointers[j] = $cardinality;
            ++j;
        }
        return new CCSMatrix(rows, columns, $cardinality, $values, $rowIndices, $columnPointers);
    }

    @Override
    public void eachNonZero(MatrixProcedure procedure) {
        int k = 0;
        int j = 0;
        while (k < this.cardinality) {
            int i = this.columnPointers[j];
            while (i < this.columnPointers[j + 1]) {
                procedure.apply(this.rowIndices[i], j, this.values[i]);
                ++i;
                ++k;
            }
            ++j;
        }
    }

    @Override
    public void each(MatrixProcedure procedure) {
        int k = 0;
        for (int i = 0; i < this.rows; ++i) {
            int valuesSoFar = this.columnPointers[i + 1];
            for (int j = 0; j < this.columns; ++j) {
                if (k < valuesSoFar && j == this.rowIndices[k]) {
                    procedure.apply(i, j, this.values[k++]);
                    continue;
                }
                procedure.apply(i, j, 0.0);
            }
        }
    }

    @Override
    public void eachInColumn(int j, VectorProcedure procedure) {
        int k = this.columnPointers[j];
        int valuesSoFar = this.columnPointers[j + 1];
        for (int i = 0; i < this.rows; ++i) {
            if (k < valuesSoFar && i == this.rowIndices[k]) {
                procedure.apply(i, this.values[k++]);
                continue;
            }
            procedure.apply(i, 0.0);
        }
    }

    @Override
    public void eachNonZeroInColumn(int j, VectorProcedure procedure) {
        for (int i = this.columnPointers[j]; i < this.columnPointers[j + 1]; ++i) {
            procedure.apply(this.rowIndices[i], this.values[i]);
        }
    }

    @Override
    public void updateAt(int i, int j, MatrixFunction function) {
        int k = this.searchForRowIndex(i, this.columnPointers[j], this.columnPointers[j + 1]);
        if (k < this.columnPointers[j + 1] && this.rowIndices[k] == i) {
            double value = function.evaluate(i, j, this.values[k]);
            if (value == 0.0) {
                this.remove(k, j);
            } else {
                this.values[k] = value;
            }
        } else {
            this.insert(k, i, j, function.evaluate(i, j, 0.0));
        }
    }

    @Override
    public boolean nonZeroAt(int i, int j) {
        int k = this.searchForRowIndex(i, this.columnPointers[j], this.columnPointers[j + 1]);
        return k < this.columnPointers[j + 1] && this.rowIndices[k] == i;
    }

    private int searchForRowIndex(int i, int left, int right) {
        if (right - left == 0 || i > this.rowIndices[right - 1]) {
            return right;
        }
        while (left < right) {
            int p = (left + right) / 2;
            if (this.rowIndices[p] > i) {
                right = p;
                continue;
            }
            if (this.rowIndices[p] < i) {
                left = p + 1;
                continue;
            }
            return p;
        }
        return left;
    }

    private void insert(int k, int i, int j, double value) {
        if (value == 0.0) {
            return;
        }
        if (this.values.length < this.cardinality + 1) {
            this.growUp();
        }
        if (this.cardinality - k > 0) {
            System.arraycopy(this.values, k, this.values, k + 1, this.cardinality - k);
            System.arraycopy(this.rowIndices, k, this.rowIndices, k + 1, this.cardinality - k);
        }
        this.values[k] = value;
        this.rowIndices[k] = i;
        int jj = j + 1;
        while (jj < this.columns + 1) {
            int n = jj++;
            this.columnPointers[n] = this.columnPointers[n] + 1;
        }
        ++this.cardinality;
    }

    private void remove(int k, int j) {
        --this.cardinality;
        if (this.cardinality - k > 0) {
            System.arraycopy(this.values, k + 1, this.values, k, this.cardinality - k);
            System.arraycopy(this.rowIndices, k + 1, this.rowIndices, k, this.cardinality - k);
        }
        int jj = j + 1;
        while (jj < this.columns + 1) {
            int n = jj++;
            this.columnPointers[n] = this.columnPointers[n] - 1;
        }
    }

    private void growUp() {
        if ((long)this.values.length == this.capacity()) {
            throw new IllegalStateException("This matrix can't grow up.");
        }
        int min = this.rows != 0 && this.columns > Integer.MAX_VALUE / this.rows ? Integer.MAX_VALUE : this.rows * this.columns;
        int capacity = Math.min(min, this.cardinality * 3 / 2 + 1);
        double[] $values = new double[capacity];
        int[] $rowIndices = new int[capacity];
        System.arraycopy(this.values, 0, $values, 0, this.cardinality);
        System.arraycopy(this.rowIndices, 0, $rowIndices, 0, this.cardinality);
        this.values = $values;
        this.rowIndices = $rowIndices;
    }

    private int align(int cardinality) {
        return (cardinality / 32 + 1) * 32;
    }

    @Override
    public double max() {
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.cardinality; ++i) {
            if (!(this.values[i] > max)) continue;
            max = this.values[i];
        }
        return max > 0.0 ? max : 0.0;
    }

    @Override
    public double min() {
        double min = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.cardinality; ++i) {
            if (!(this.values[i] < min)) continue;
            min = this.values[i];
        }
        return min < 0.0 ? min : 0.0;
    }

    @Override
    public double maxInColumn(int j) {
        double max = Double.NEGATIVE_INFINITY;
        for (int k = this.columnPointers[j]; k < this.columnPointers[j + 1]; ++k) {
            if (!(this.values[k] > max)) continue;
            max = this.values[k];
        }
        return max > 0.0 ? max : 0.0;
    }

    @Override
    public double minInColumn(int j) {
        double min = Double.POSITIVE_INFINITY;
        for (int k = this.columnPointers[j]; k < this.columnPointers[j + 1]; ++k) {
            if (!(this.values[k] < min)) continue;
            min = this.values[k];
        }
        return min < 0.0 ? min : 0.0;
    }

    @Override
    public Matrix select(int[] rowIndices, int[] columnIndices) {
        int newRows = rowIndices.length;
        int newCols = columnIndices.length;
        if (newRows == 0 || newCols == 0) {
            this.fail("No rows or columns selected.");
        }
        int newCardinality = 0;
        for (int i = 0; i < newRows; ++i) {
            for (int j = 0; j < newCols; ++j) {
                if (this.get(rowIndices[i], columnIndices[j]) == 0.0) continue;
                ++newCardinality;
            }
        }
        double[] newValues = new double[newCardinality];
        int[] newRowIndices = new int[newCardinality];
        int[] newColumnPointers = new int[newCols + 1];
        newColumnPointers[0] = 0;
        int endPtr = 0;
        for (int j = 0; j < newCols; ++j) {
            newColumnPointers[j + 1] = newColumnPointers[j];
            for (int i = 0; i < newRows; ++i) {
                double val = this.get(rowIndices[i], columnIndices[j]);
                if (val == 0.0) continue;
                newValues[endPtr] = val;
                newRowIndices[endPtr] = i;
                ++endPtr;
                int n = j + 1;
                newColumnPointers[n] = newColumnPointers[n] + 1;
            }
        }
        return new CCSMatrix(newRows, newCols, newCardinality, newValues, newRowIndices, newColumnPointers);
    }

    @Override
    public <T extends Matrix> T to(MatrixFactory<T> factory) {
        if (factory.outputClass == CCSMatrix.class) {
            return (T)((Matrix)factory.outputClass.cast(this));
        }
        return super.to(factory);
    }

    @Override
    public Matrix blankOfShape(int rows, int columns) {
        return CCSMatrix.zero(rows, columns);
    }

    @Override
    public Iterator<Integer> iteratorOrNonZeroColumns() {
        return new Iterator<Integer>(){
            private int j = -1;

            @Override
            public boolean hasNext() {
                while (this.j + 1 < CCSMatrix.this.columns && CCSMatrix.this.columnPointers[this.j + 1] < CCSMatrix.this.cardinality && CCSMatrix.this.columnPointers[this.j + 1] == CCSMatrix.this.columnPointers[this.j + 2]) {
                    ++this.j;
                }
                return this.j + 1 < CCSMatrix.this.columns && CCSMatrix.this.columnPointers[this.j + 1] < CCSMatrix.this.cardinality;
            }

            @Override
            public Integer next() {
                ++this.j;
                return this.j;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Can not remove from this iterator.");
            }
        };
    }

    @Override
    public ColumnMajorMatrixIterator columnMajorIterator() {
        return new ColumnMajorMatrixIterator(this.rows, this.columns){
            private long limit;
            private boolean currentNonZero;
            private int i;
            private int k;
            {
                this.limit = (long)this.rows * (long)this.columns;
                this.currentNonZero = false;
                this.i = -1;
                this.k = 0;
            }

            @Override
            public int rowIndex() {
                return this.i - this.columnIndex() * this.rows;
            }

            @Override
            public int columnIndex() {
                return this.i / this.rows;
            }

            @Override
            public double get() {
                return this.currentNonZero ? CCSMatrix.this.values[this.k] : 0.0;
            }

            @Override
            public void set(double value) {
                if (this.currentNonZero) {
                    if (value == 0.0) {
                        CCSMatrix.this.remove(this.k, this.columnIndex());
                        this.currentNonZero = false;
                    } else {
                        CCSMatrix.this.values[this.k] = value;
                    }
                } else {
                    CCSMatrix.this.insert(this.k, this.rowIndex(), this.columnIndex(), value);
                    this.currentNonZero = true;
                }
            }

            @Override
            public boolean hasNext() {
                return (long)(this.i + 1) < this.limit;
            }

            @Override
            public Double next() {
                if (this.currentNonZero) {
                    ++this.k;
                }
                ++this.i;
                this.currentNonZero = this.k < CCSMatrix.this.columnPointers[this.columnIndex() + 1] && CCSMatrix.this.rowIndices[this.k] == this.rowIndex();
                return this.get();
            }
        };
    }

    @Override
    public ColumnMajorMatrixIterator nonZeroColumnMajorIterator() {
        return new ColumnMajorMatrixIterator(this.rows, this.columns){
            private int j;
            private int k;
            private boolean currentIsRemoved;
            private int removedIndex;
            {
                this.j = 0;
                this.k = -1;
                this.currentIsRemoved = false;
                this.removedIndex = -1;
            }

            @Override
            public int rowIndex() {
                return this.currentIsRemoved ? this.removedIndex : CCSMatrix.this.rowIndices[this.k];
            }

            @Override
            public int columnIndex() {
                return this.j;
            }

            @Override
            public double get() {
                return this.currentIsRemoved ? 0.0 : CCSMatrix.this.values[this.k];
            }

            @Override
            public void set(double value) {
                if (value == 0.0 && !this.currentIsRemoved) {
                    this.currentIsRemoved = true;
                    this.removedIndex = CCSMatrix.this.rowIndices[this.k];
                    CCSMatrix.this.remove(this.k--, this.j);
                } else if (value != 0.0 && !this.currentIsRemoved) {
                    CCSMatrix.this.values[this.k] = value;
                } else {
                    this.currentIsRemoved = false;
                    CCSMatrix.this.insert(++this.k, this.removedIndex, this.j, value);
                }
            }

            @Override
            public boolean hasNext() {
                return this.k + 1 < CCSMatrix.this.cardinality;
            }

            @Override
            public Double next() {
                this.currentIsRemoved = false;
                ++this.k;
                while (CCSMatrix.this.columnPointers[this.j + 1] == this.k) {
                    ++this.j;
                }
                return this.get();
            }
        };
    }

    @Override
    public VectorIterator nonZeroIteratorOfColumn(int j) {
        final int jj = j;
        return new VectorIterator(this.rows){
            private int k;
            private boolean currentIsRemoved;
            private int removedIndex;
            {
                super(x0);
                this.k = CCSMatrix.this.columnPointers[jj] - 1;
                this.currentIsRemoved = false;
                this.removedIndex = -1;
            }

            @Override
            public int index() {
                return this.currentIsRemoved ? this.removedIndex : CCSMatrix.this.rowIndices[this.k];
            }

            @Override
            public double get() {
                return this.currentIsRemoved ? 0.0 : CCSMatrix.this.values[this.k];
            }

            @Override
            public void set(double value) {
                if (value == 0.0 && !this.currentIsRemoved) {
                    this.currentIsRemoved = true;
                    this.removedIndex = CCSMatrix.this.rowIndices[this.k];
                    CCSMatrix.this.remove(this.k--, jj);
                } else if (value != 0.0 && !this.currentIsRemoved) {
                    CCSMatrix.this.values[this.k] = value;
                } else {
                    this.currentIsRemoved = false;
                    CCSMatrix.this.insert(++this.k, this.removedIndex, jj, value);
                }
            }

            @Override
            public boolean hasNext() {
                return this.k + 1 < CCSMatrix.this.columnPointers[jj + 1];
            }

            @Override
            public Double next() {
                this.currentIsRemoved = false;
                return CCSMatrix.this.values[++this.k];
            }
        };
    }

    @Override
    public VectorIterator iteratorOfColumn(int j) {
        final int jj = j;
        return new VectorIterator(this.rows){
            private int i;
            private int k;
            {
                super(x0);
                this.i = -1;
                this.k = CCSMatrix.this.columnPointers[jj];
            }

            @Override
            public int index() {
                return this.i;
            }

            @Override
            public double get() {
                if (this.k < CCSMatrix.this.columnPointers[jj + 1] && CCSMatrix.this.rowIndices[this.k] == this.i) {
                    return CCSMatrix.this.values[this.k];
                }
                return 0.0;
            }

            @Override
            public void set(double value) {
                if (this.k < CCSMatrix.this.columnPointers[jj + 1] && CCSMatrix.this.rowIndices[this.k] == this.i) {
                    if (value == 0.0) {
                        CCSMatrix.this.remove(this.k, jj);
                    } else {
                        CCSMatrix.this.values[this.k] = value;
                    }
                } else {
                    CCSMatrix.this.insert(this.k, this.i, jj, value);
                }
            }

            @Override
            public boolean hasNext() {
                return this.i + 1 < CCSMatrix.this.rows;
            }

            @Override
            public Double next() {
                ++this.i;
                if (this.k < CCSMatrix.this.columnPointers[jj + 1] && CCSMatrix.this.rowIndices[this.k] == this.i - 1) {
                    ++this.k;
                }
                return this.get();
            }
        };
    }

    @Override
    public byte[] toBinary() {
        int i;
        int size = 13 + 8 * this.cardinality + 4 * this.cardinality + 4 * (this.columns + 1);
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.put((byte)48);
        buffer.putInt(this.rows);
        buffer.putInt(this.columns);
        buffer.putInt(this.cardinality);
        for (i = 0; i < this.cardinality; ++i) {
            buffer.putInt(this.rowIndices[i]);
            buffer.putDouble(this.values[i]);
        }
        for (i = 0; i < this.columns + 1; ++i) {
            buffer.putInt(this.columnPointers[i]);
        }
        return buffer.array();
    }
}

