/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer;

import com.rapidminer.Process;
import com.rapidminer.ProcessListener;
import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.test_utils.RapidAssert;
import com.rapidminer.test_utils.Util;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ExecuteTestAction
extends ResourceAction {
    private static final long serialVersionUID = -2836978556530957075L;
    private final MainFrame mainFrame;

    public ExecuteTestAction(MainFrame mainFrame) {
        super("test.execute", new Object[0]);
        this.mainFrame = mainFrame;
        this.setCondition(6, -1);
        this.setCondition(9, -1);
    }

    public void actionPerformed(ActionEvent e) {
        this.mainFrame.getProcess().getRootOperator().addProcessListener(new ProcessListener(){

            public void processStarts(Process process) {
            }

            public void processStartedOperator(Process process, Operator op) {
            }

            public void processFinishedOperator(Process process, Operator op) {
            }

            public void processEnded(Process process) {
                List actual;
                List expected;
                process.getRootOperator().removeProcessListener((ProcessListener)this);
                try {
                    expected = Util.getExpectedResult((Process)process);
                    actual = process.getRootOperator().getResults().asList();
                    RapidAssert.assertSize((List)expected, (List)actual);
                }
                catch (Exception e) {
                    SwingTools.showSimpleErrorMessage((String)"test-error", (Throwable)e, (Object[])new Object[0]);
                    return;
                }
                Iterator expectedIter = expected.iterator();
                Iterator actualIter = actual.iterator();
                HashMap<Throwable, Integer> exceptions = new HashMap<Throwable, Integer>();
                int currentPort = 0;
                while (expectedIter.hasNext() && actualIter.hasNext()) {
                    IOObject expectedIOO = (IOObject)expectedIter.next();
                    IOObject actualIOO = (IOObject)actualIter.next();
                    try {
                        RapidAssert.assertEquals((IOObject)expectedIOO, (IOObject)actualIOO);
                    }
                    catch (Throwable e) {
                        exceptions.put(e, currentPort);
                    }
                    ++currentPort;
                }
                if (exceptions.isEmpty()) {
                    SwingTools.showMessageDialog((String)"test-successful", (Object[])new Object[0]);
                } else {
                    SwingTools.showSimpleErrorMessage((String)"test-error", (Throwable)((Throwable)exceptions.keySet().iterator().next()), (Object[])new Object[0]);
                }
            }
        });
        this.mainFrame.runProcess();
    }
}

