/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.util.tests;

import cc.mallet.util.search.MinHeap;
import cc.mallet.util.search.QueueElement;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestPriorityQueue
extends TestCase {
    private static final int N = 100;

    public TestPriorityQueue(String name) {
        super(name);
    }

    public void testAscending() {
        MinHeap q = new MinHeap(100);
        double[] p = new double[100];
        for (int i = 0; i < 100; ++i) {
            p[i] = i;
            Item e = new Item(i);
            q.insert(e);
        }
        int j = 0;
        double pr = Double.NEGATIVE_INFINITY;
        TestPriorityQueue.assertTrue("ascending size", q.size() == 100);
        while (q.size() > 0) {
            TestPriorityQueue.assertTrue("ascending extract", j < 100);
            QueueElement e = q.extractMin();
            TestPriorityQueue.assertTrue("ascending order", e.getPriority() > pr);
            TestPriorityQueue.assertEquals("ascending priority", e.getPriority(), p[j++], 1.0E-5);
            pr = e.getPriority();
        }
    }

    public void testDescending() {
        MinHeap q = new MinHeap(100);
        double[] p = new double[100];
        for (int i = 0; i < 100; ++i) {
            p[i] = i;
            Item e = new Item(100 - i - 1);
            q.insert(e);
        }
        int j = 0;
        double pr = Double.NEGATIVE_INFINITY;
        TestPriorityQueue.assertTrue("descending size", q.size() == 100);
        while (q.size() > 0) {
            TestPriorityQueue.assertTrue("descending extract", j < 100);
            QueueElement e = q.extractMin();
            TestPriorityQueue.assertTrue("descending order", e.getPriority() > pr);
            TestPriorityQueue.assertEquals("descending priority", e.getPriority(), p[j++], 1.0E-5);
            pr = e.getPriority();
        }
    }

    public void testChangePriority() {
        MinHeap q = new MinHeap(100);
        Item[] items = new Item[100];
        for (int i = 0; i < 100; ++i) {
            Item e = new Item(100 - i - 1);
            q.insert(e);
            items[i] = e;
        }
        q.changePriority(items[99], -2.0);
        q.changePriority(items[50], -1.0);
        q.changePriority(items[51], 200.0);
        int j = 0;
        double pr_last = Double.NEGATIVE_INFINITY;
        TestPriorityQueue.assertTrue("descending size", q.size() == 100);
        while (q.size() > 0) {
            TestPriorityQueue.assertTrue("descending extract", j < 100);
            QueueElement e = q.extractMin();
            TestPriorityQueue.assertTrue("descending order", e.getPriority() > pr_last);
            pr_last = e.getPriority();
            if (j == 0) {
                TestPriorityQueue.assertTrue("lowest elt", e.getPriority() == -2.0);
            }
            if (j == 1) {
                TestPriorityQueue.assertTrue("second-lowest elt", e.getPriority() == -1.0);
            }
            if (q.size() == 1) {
                TestPriorityQueue.assertTrue("penultimate elt", e.getPriority() == 99.0);
            }
            if (q.size() == 0) {
                TestPriorityQueue.assertTrue("final elt", e.getPriority() == 200.0);
            }
            ++j;
        }
    }

    public void testReverse() {
        int i;
        MinHeap q = new MinHeap(100);
        Item[] items = new Item[100];
        for (i = 0; i < 100; ++i) {
            Item e = new Item(100 - i - 1);
            q.insert(e);
            items[i] = e;
        }
        for (i = 0; i < 100; ++i) {
            q.changePriority(items[i], i);
        }
        int j = 0;
        double pr_last = Double.NEGATIVE_INFINITY;
        TestPriorityQueue.assertTrue("ascending size", q.size() == 100);
        while (q.size() > 0) {
            TestPriorityQueue.assertTrue("ascending extract", j < 100);
            QueueElement e = q.extractMin();
            TestPriorityQueue.assertTrue("ascending order", e.getPriority() > pr_last);
            pr_last = e.getPriority();
            TestPriorityQueue.assertEquals("ascending priority", (Object)items[j].getPriority(), (Object)e.getPriority());
            TestPriorityQueue.assertEquals("ascending identity", items[j], e);
            ++j;
        }
    }

    public void testEqualKeys() {
        QueueElement e;
        int i;
        MinHeap q = new MinHeap(100);
        Item[] items = new Item[20];
        int j = 0;
        for (i = 0; i < 5; ++i) {
            items[j] = new Item(5.0);
            q.insert(items[j]);
            ++j;
        }
        for (i = 0; i < 5; ++i) {
            items[j] = new Item(3.0);
            q.insert(items[j]);
            ++j;
        }
        for (i = 0; i < 5; ++i) {
            items[j] = new Item(4.0);
            q.insert(items[j]);
            ++j;
        }
        for (i = 0; i < 5; ++i) {
            items[j] = new Item(7.0);
            q.insert(items[j]);
            ++j;
        }
        TestPriorityQueue.assertEquals(20, q.size());
        for (i = 0; i < items.length; ++i) {
            TestPriorityQueue.assertTrue(q.contains(items[i]));
        }
        for (i = 0; i < 5; ++i) {
            e = q.extractMin();
            TestPriorityQueue.assertTrue(q.contains(q.min()));
            TestPriorityQueue.assertEquals(3.0, e.getPriority());
        }
        for (i = 0; i < 5; ++i) {
            e = q.extractMin();
            TestPriorityQueue.assertTrue(q.contains(q.min()));
            TestPriorityQueue.assertEquals(4.0, e.getPriority());
        }
        for (i = 0; i < 5; ++i) {
            e = q.extractMin();
            TestPriorityQueue.assertTrue(q.contains(q.min()));
            TestPriorityQueue.assertEquals(5.0, e.getPriority());
        }
        for (i = 0; i < 5; ++i) {
            e = q.extractMin();
            if (q.size() > 0) {
                TestPriorityQueue.assertTrue(q.contains(q.min()));
            }
            TestPriorityQueue.assertEquals(7.0, e.getPriority());
        }
    }

    public static Test suite() {
        return new TestSuite((Class<? extends TestCase>)TestPriorityQueue.class);
    }

    public static void main(String[] args) {
        TestRunner.run(TestPriorityQueue.suite());
    }

    private static class Item
    implements QueueElement {
        private int position;
        private double priority;

        private Item(double p) {
            this.priority = p;
        }

        @Override
        public double getPriority() {
            return this.priority;
        }

        @Override
        public void setPriority(double p) {
            this.priority = p;
        }

        @Override
        public int getPosition() {
            return this.position;
        }

        @Override
        public void setPosition(int p) {
            this.position = p;
        }
    }
}

