/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.ConstantMatrix;
import cc.mallet.types.Matrix;
import cc.mallet.types.Matrixn;
import cc.mallet.types.SparseVector;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class SparseMatrixn
implements Matrix,
Cloneable,
Serializable {
    private SparseVector values;
    private int numDimensions;
    private int[] sizes;
    private int singleSize;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 1;

    public SparseMatrixn(double[] vals) {
        this.numDimensions = 1;
        this.sizes = new int[1];
        this.sizes[0] = vals.length;
        this.values = new SparseVector(vals);
        this.computeSingleSIze();
    }

    public SparseMatrixn(int[] szs) {
        this.numDimensions = szs.length;
        this.sizes = (int[])szs.clone();
        int total = 1;
        for (int j = 0; j < this.numDimensions; ++j) {
            total *= this.sizes[j];
        }
        this.values = new SparseVector(new double[total]);
        this.computeSingleSIze();
    }

    public SparseMatrixn(int[] szs, double[] vals) {
        this.numDimensions = szs.length;
        this.sizes = (int[])szs.clone();
        this.values = new SparseVector(vals);
        this.computeSingleSIze();
    }

    public SparseMatrixn(int[] szs, int[] idxs, double[] vals) {
        this.numDimensions = szs.length;
        this.sizes = (int[])szs.clone();
        this.values = new SparseVector(idxs, vals, true, true);
        this.computeSingleSIze();
    }

    private void computeSingleSIze() {
        int product = 1;
        for (int i = 0; i < this.sizes.length; ++i) {
            int size = this.sizes[i];
            product *= size;
        }
        this.singleSize = product;
    }

    @Override
    public int getNumDimensions() {
        return this.numDimensions;
    }

    @Override
    public int getDimensions(int[] szs) {
        for (int i = 0; i < this.numDimensions; ++i) {
            szs[i] = this.sizes[i];
        }
        return this.numDimensions;
    }

    @Override
    public double value(int[] indices) {
        return this.values.value(this.singleIndex(indices));
    }

    @Override
    public void setValue(int[] indices, double value) {
        this.values.setValue(this.singleIndex(indices), value);
    }

    public int[] getIndices() {
        return this.values.getIndices();
    }

    @Override
    public ConstantMatrix cloneMatrix() {
        return new SparseMatrixn(this.sizes, this.values.getIndices(), this.values.getValues());
    }

    public Object clone() {
        return this.cloneMatrix();
    }

    @Override
    public int singleIndex(int[] indices) {
        return Matrixn.singleIndex(this.sizes, indices);
    }

    public static int singleIndex(int[] szs, int[] indices) {
        int idx = 0;
        for (int dim = 0; dim < indices.length; ++dim) {
            idx = idx * szs[dim] + indices[dim];
        }
        return idx;
    }

    @Override
    public void singleToIndices(int single, int[] indices) {
        Matrixn.singleToIndices(single, indices, this.sizes);
    }

    public boolean equals(Object o) {
        if (o instanceof SparseMatrixn) {
            SparseMatrixn m2 = (SparseMatrixn)o;
            return this.numDimensions == m2.numDimensions && this.sizes.equals(m2.sizes) && this.values.equals(m2.values);
        }
        return false;
    }

    public double[] toArray() {
        return this.values.getValues();
    }

    @Override
    public double singleValue(int i) {
        return this.values.singleValue(i);
    }

    @Override
    public int singleSize() {
        return this.singleSize;
    }

    @Override
    public int numLocations() {
        return this.values.numLocations();
    }

    @Override
    public int location(int index) {
        return this.values.location(index);
    }

    @Override
    public double valueAtLocation(int location) {
        return this.values.valueAtLocation(location);
    }

    @Override
    public void setValueAtLocation(int location, double value) {
        this.values.setValueAtLocation(location, value);
    }

    @Override
    public int indexAtLocation(int location) {
        return this.values.indexAtLocation(location);
    }

    @Override
    public double dotProduct(ConstantMatrix m) {
        return this.values.dotProduct(m);
    }

    @Override
    public double absNorm() {
        return this.values.absNorm();
    }

    @Override
    public double oneNorm() {
        return this.values.oneNorm();
    }

    @Override
    public double twoNorm() {
        return this.values.twoNorm();
    }

    @Override
    public double infinityNorm() {
        return this.values.infinityNorm();
    }

    @Override
    public void print() {
        this.values.print();
    }

    @Override
    public boolean isNaN() {
        return this.values.isNaN();
    }

    @Override
    public void setSingleValue(int i, double value) {
        this.values.setValue(i, value);
    }

    @Override
    public void incrementSingleValue(int i, double delta) {
        double value = this.values.value(i);
        this.values.setValue(i, value + delta);
    }

    @Override
    public void setAll(double v) {
        this.values.setAll(v);
    }

    @Override
    public void set(ConstantMatrix m) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @Override
    public void setWithAddend(ConstantMatrix m, double addend) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @Override
    public void setWithFactor(ConstantMatrix m, double factor) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @Override
    public void plusEquals(ConstantMatrix m) {
        this.plusEquals(m, 1.0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void plusEquals(ConstantMatrix m, double factor) {
        if (m instanceof SparseVector) {
            this.values.plusEqualsSparse((SparseVector)m, factor);
            return;
        } else {
            if (!(m instanceof SparseMatrixn)) throw new UnsupportedOperationException("Can't add " + m + " to " + this);
            SparseMatrixn smn = (SparseMatrixn)m;
            if (!Arrays.equals(this.sizes, smn.sizes)) throw new UnsupportedOperationException("sizes of " + m + " do not match " + this);
            this.values.plusEqualsSparse(smn.values, factor);
        }
    }

    @Override
    public void equalsPlus(double factor, ConstantMatrix m) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @Override
    public void timesEquals(double factor) {
        this.values.timesEquals(factor);
    }

    @Override
    public void elementwiseTimesEquals(ConstantMatrix m) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @Override
    public void elementwiseTimesEquals(ConstantMatrix m, double factor) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @Override
    public void divideEquals(double factor) {
        this.values.timesEquals(1.0 / factor);
    }

    @Override
    public void elementwiseDivideEquals(ConstantMatrix m) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @Override
    public void elementwiseDivideEquals(ConstantMatrix m, double factor) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @Override
    public double oneNormalize() {
        double norm = this.values.oneNorm();
        this.values.timesEquals(1.0 / norm);
        return norm;
    }

    @Override
    public double twoNormalize() {
        double norm = this.values.twoNorm();
        this.values.timesEquals(1.0 / norm);
        return norm;
    }

    @Override
    public double absNormalize() {
        double norm = this.values.absNorm();
        this.values.timesEquals(1.0 / norm);
        return norm;
    }

    @Override
    public double infinityNormalize() {
        double norm = this.values.infinityNorm();
        this.values.timesEquals(1.0 / norm);
        return norm;
    }

    private void writeObject(ObjectOutputStream out2) throws IOException {
        out2.defaultWriteObject();
        out2.writeInt(1);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int version = in.readInt();
    }
}

