/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.FeatureSelection;
import cc.mallet.types.Vector;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Random;

public final class MatrixOps {
    public static void setAll(double[] m, double v) {
        Arrays.fill(m, v);
    }

    public static void set(double[] dest, double[] source) {
        if (source.length != dest.length) {
            dest = new double[source.length];
        }
        System.arraycopy(source, 0, dest, 0, source.length);
    }

    public static void timesEquals(double[] m, double factor) {
        int i = 0;
        while (i < m.length) {
            int n = i++;
            m[n] = m[n] * factor;
        }
    }

    public static void timesEquals(double[] m1, double[] m2) {
        assert (m1.length == m2.length) : "unequal lengths\n";
        for (int i = 0; i < m1.length; ++i) {
            int n = i;
            m1[n] = m1[n] * m2[i];
        }
    }

    public static void plusEquals(double[] m, double toadd) {
        int i = 0;
        while (i < m.length) {
            int n = i++;
            m[n] = m[n] + toadd;
        }
    }

    public static void plusEquals(double[] m1, double[] m2) {
        assert (m1.length == m2.length) : "unequal lengths\n";
        for (int i = 0; i < m1.length; ++i) {
            if (Double.isInfinite(m1[i]) && Double.isInfinite(m2[i]) && m1[i] * m2[i] < 0.0) {
                m1[i] = 0.0;
                continue;
            }
            int n = i;
            m1[n] = m1[n] + m2[i];
        }
    }

    public static void plusEquals(double[] m1, double[] m2, double factor) {
        assert (m1.length == m2.length) : "unequal lengths\n";
        for (int i = 0; i < m1.length; ++i) {
            double m1i = m1[i];
            double m2i = m2[i];
            if (Double.isInfinite(m1i) && Double.isInfinite(m2i) && m1[i] * m2[i] < 0.0) {
                m1[i] = 0.0;
                continue;
            }
            int n = i;
            m1[n] = m1[n] + m2[i] * factor;
        }
    }

    public static void plusEquals(double[][] m1, double[][] m2, double factor) {
        assert (m1.length == m2.length) : "unequal lengths\n";
        for (int i = 0; i < m1.length; ++i) {
            for (int j = 0; j < m1[i].length; ++j) {
                double[] dArray = m1[i];
                int n = j;
                dArray[n] = dArray[n] + m2[i][j] * factor;
            }
        }
    }

    public static void log(double[] m) {
        for (int i = 0; i < m.length; ++i) {
            m[i] = Math.log(m[i]);
        }
    }

    public static double dot(double[] m1, double[] m2) {
        assert (m1.length == m2.length) : "m1.length != m2.length\n";
        double ret = 0.0;
        for (int i = 0; i < m1.length; ++i) {
            ret += m1[i] * m2[i];
        }
        return ret;
    }

    public static double dotProduct(double[] m1, double[] m2) {
        assert (m1.length == m2.length) : "m1.length != m2.length\n";
        double ret = 0.0;
        for (int i = 0; i < m1.length; ++i) {
            ret += m1[i] * m2[i];
        }
        return ret;
    }

    public static double absNorm(double[] m) {
        double ret = 0.0;
        for (int i = 0; i < m.length; ++i) {
            ret += Math.abs(m[i]);
        }
        return ret;
    }

    public static double twoNorm(double[] m) {
        double ret = 0.0;
        for (int i = 0; i < m.length; ++i) {
            ret += m[i] * m[i];
        }
        return Math.sqrt(ret);
    }

    public static double twoNormSquared(double[] m) {
        double ret = 0.0;
        for (int i = 0; i < m.length; ++i) {
            ret += m[i] * m[i];
        }
        return ret;
    }

    public static double oneNorm(double[] m) {
        double ret = 0.0;
        for (int i = 0; i < m.length; ++i) {
            ret += m[i];
        }
        return ret;
    }

    public static double oneNormalize(double[] m) {
        double sum = MatrixOps.oneNorm(m);
        int i = 0;
        while (i < m.length) {
            int n = i++;
            m[n] = m[n] / sum;
        }
        return sum;
    }

    public static double normalize(double[] m) {
        return MatrixOps.oneNormalize(m);
    }

    public static double infinityNorm(double[] m) {
        double ret = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < m.length; ++i) {
            if (!(Math.abs(m[i]) > ret)) continue;
            ret = Math.abs(m[i]);
        }
        return ret;
    }

    public static double absNormalize(double[] m) {
        double norm = MatrixOps.absNorm(m);
        if (norm > 0.0) {
            int i = 0;
            while (i < m.length) {
                int n = i++;
                m[n] = m[n] / norm;
            }
        }
        return norm;
    }

    public static double twoNormalize(double[] m) {
        double norm = MatrixOps.twoNorm(m);
        if (norm > 0.0) {
            int i = 0;
            while (i < m.length) {
                int n = i++;
                m[n] = m[n] / norm;
            }
        }
        return norm;
    }

    public static void substitute(double[] m, double oldValue, double newValue) {
        for (int i = m.length - 1; i >= 0; --i) {
            if (m[i] != oldValue) continue;
            m[i] = newValue;
        }
    }

    public static final void rowSetAll(double[] m, int nc, int ri, double v, FeatureSelection fselection, boolean ifSelected) {
        block3: {
            block2: {
                if (fselection != null) break block2;
                if (!ifSelected) break block3;
                for (int ci = 0; ci < nc; ++ci) {
                    m[ri * nc + ci] = v;
                }
                break block3;
            }
            for (int ci = 0; ci < nc; ++ci) {
                if (!(fselection.contains(ci) ^ !ifSelected)) continue;
                m[ri * nc + ci] = v;
            }
        }
    }

    public static double rowDotProduct(double[] m, int nc, int ri, Vector v, int maxCi, FeatureSelection selection) {
        return MatrixOps.rowDotProduct(m, nc, ri, v, 1.0, maxCi, selection);
    }

    public static double rowDotProduct(double[] m, int nc, int ri, Vector v, double factor, int maxCi, FeatureSelection selection) {
        double ret = 0.0;
        if (selection != null) {
            int size = v.numLocations();
            for (int cil = 0; cil < size; ++cil) {
                int ci = v.indexAtLocation(cil);
                if (!selection.contains(ci) || ci >= nc || ci > maxCi) continue;
                ret += m[ri * nc + ci] * v.valueAtLocation(cil) * factor;
            }
        } else {
            int size = v.numLocations();
            for (int cil = 0; cil < size; ++cil) {
                int ci = v.indexAtLocation(cil);
                if (ci > maxCi) continue;
                ret += m[ri * nc + ci] * v.valueAtLocation(cil) * factor;
            }
        }
        return ret;
    }

    public static final void rowPlusEquals(double[] m, int nc, int ri, Vector v, double factor) {
        for (int vli = 0; vli < v.numLocations(); ++vli) {
            int n = ri * nc + v.indexAtLocation(vli);
            m[n] = m[n] + v.valueAtLocation(vli) * factor;
        }
    }

    public static boolean isNaN(double[] m) {
        for (int i = 0; i < m.length; ++i) {
            if (!Double.isNaN(m[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isInfinite(double[] m) {
        for (int i = 0; i < m.length; ++i) {
            if (!Double.isInfinite(m[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isNaNOrInfinite(double[] m) {
        for (int i = 0; i < m.length; ++i) {
            if (!Double.isInfinite(m[i]) && !Double.isNaN(m[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isNonZero(double[] m) {
        for (int i = 0; i < m.length; ++i) {
            if (!(Math.abs(m[i]) > 0.0)) continue;
            return true;
        }
        return false;
    }

    public static boolean isZero(double[] m) {
        for (int i = 0; i < m.length; ++i) {
            if (Math.abs(m[i]) != 0.0) continue;
            return true;
        }
        return false;
    }

    public static double sum(double[] m) {
        double sum = 0.0;
        for (int i = 0; i < m.length; ++i) {
            sum += m[i];
        }
        return sum;
    }

    public static double sum(double[][] m) {
        double sum = 0.0;
        for (int i = 0; i < m.length; ++i) {
            for (int j = 0; j < m[i].length; ++j) {
                sum += m[i][j];
            }
        }
        return sum;
    }

    public static int sum(int[] m) {
        int sum = 0;
        for (int i = 0; i < m.length; ++i) {
            sum += m[i];
        }
        return sum;
    }

    public static double sum(Vector v) {
        double sum = 0.0;
        for (int vli = 0; vli < v.numLocations(); ++vli) {
            sum += v.valueAtLocation(vli);
        }
        return sum;
    }

    public static double mean(double[] m) {
        double sum = 0.0;
        for (int i = 0; i < m.length; ++i) {
            sum += m[i];
        }
        return sum / (double)m.length;
    }

    public static double stddev(double[] m) {
        double mean = MatrixOps.mean(m);
        double s = 0.0;
        for (int i = 0; i < m.length; ++i) {
            s += (m[i] - mean) * (m[i] - mean);
        }
        return Math.sqrt(s / (double)m.length);
    }

    public static double stderr(double[] m) {
        return MatrixOps.stddev(m) / Math.sqrt(m.length);
    }

    public static double variance(double[] m) {
        double mean = MatrixOps.mean(m);
        double s = 0.0;
        for (int i = 0; i < m.length; ++i) {
            s += (m[i] - mean) * (m[i] - mean);
        }
        return s / (double)m.length;
    }

    public static final void print(double[] m) {
        MatrixOps.print(new PrintWriter((Writer)new OutputStreamWriter(System.out), true), m);
    }

    public static final void print(PrintWriter out2, double[] m) {
        for (int i = 0; i < m.length; ++i) {
            out2.print(" " + m[i]);
        }
        out2.println("");
    }

    public static final void print(double[][] arr) {
        for (int i = 0; i < arr.length; ++i) {
            double[] doubles = arr[i];
            MatrixOps.print(doubles);
        }
    }

    public static final String toString(Object m) {
        StringBuffer sb = new StringBuffer();
        int n = Array.getLength(m) - 1;
        for (int i = 0; i < n; ++i) {
            sb.append(Array.get(m, i));
            sb.append(" ");
        }
        if (n >= 0) {
            sb.append(Array.get(m, n));
        }
        return sb.toString();
    }

    public static final void printInRows(double[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            double v = arr[i];
            System.out.println("[" + i + "]  " + arr[i]);
        }
    }

    public static void setAll(double[][][] m, double v) {
        for (int i = 0; i < m.length; ++i) {
            for (int j = 0; j < m[i].length; ++j) {
                for (int k = 0; k < m[i][j].length; ++k) {
                    m[i][j][k] = v;
                }
            }
        }
    }

    public static void setAll(double[][] m, double v) {
        for (int i = 0; i < m.length; ++i) {
            for (int j = 0; j < m[i].length; ++j) {
                m[i][j] = v;
            }
        }
    }

    public static void print(int[][] arr) {
        for (int i = 0; i < arr.length; ++i) {
            MatrixOps.print(arr[i]);
        }
    }

    public static void print(int[] m) {
        for (int i = 0; i < m.length; ++i) {
            System.out.print(" " + m[i]);
        }
        System.out.println("");
    }

    public static double[] randomVector(int n, Random r) {
        double[] ret = new double[n];
        for (int i = 0; i < n; ++i) {
            ret[i] = r.nextDouble();
        }
        return ret;
    }

    public static void timesEquals(double[][] m, double factor) {
        for (int i = 0; i < m.length; ++i) {
            int j = 0;
            while (j < m[i].length) {
                double[] dArray = m[i];
                int n = j++;
                dArray[n] = dArray[n] * factor;
            }
        }
    }

    public static double maxAbsdiff(double[] v1, double[] v2) {
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < v1.length; ++i) {
            double val = Math.abs(v1[i] - v2[i]);
            if (!(val > max)) continue;
            max = val;
        }
        return max;
    }

    public static int max(int[][] m) {
        int maxval = m[0][0];
        for (int i = 0; i < m.length; ++i) {
            for (int j = 0; j < m[i].length; ++j) {
                if (m[i][j] <= maxval) continue;
                maxval = m[i][j];
            }
        }
        return maxval;
    }

    public static int max(int[] elems) {
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < elems.length; ++i) {
            int elem = elems[i];
            if (elem <= max) continue;
            max = elem;
        }
        return max;
    }

    public static double max(double[] elems) {
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < elems.length; ++i) {
            double elem = elems[i];
            if (!(elem > max)) continue;
            max = elem;
        }
        return max;
    }

    public static double min(double[] elems) {
        double min = Double.POSITIVE_INFINITY;
        for (int i = 0; i < elems.length; ++i) {
            double elem = elems[i];
            if (!(elem < min)) continue;
            min = elem;
        }
        return min;
    }

    public static int maxIndex(double[] elems) {
        double max = Double.NEGATIVE_INFINITY;
        int maxIndex = -1;
        for (int i = 0; i < elems.length; ++i) {
            double elem = elems[i];
            if (!(elem > max)) continue;
            max = elem;
            maxIndex = i;
        }
        return maxIndex;
    }

    public static int minIndex(double[] elems) {
        double min = Double.POSITIVE_INFINITY;
        int minIndex = -1;
        for (int i = 0; i < elems.length; ++i) {
            double elem = elems[i];
            if (!(elem < min)) continue;
            min = elem;
            minIndex = i;
        }
        return minIndex;
    }

    public static double[] append(double[] original, double newValue) {
        double[] ret = new double[original.length + 1];
        System.arraycopy(original, 0, ret, 0, original.length);
        ret[original.length] = newValue;
        return ret;
    }

    public static double max(double[][] ds) {
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < ds.length; ++i) {
            for (int j = 0; j < ds[i].length; ++j) {
                if (!(ds[i][j] > max)) continue;
                max = ds[i][j];
            }
        }
        return max;
    }

    public static int[] maxIndex(double[][] ds) {
        int[] maxIndices = new int[]{-1, -1};
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < ds.length; ++i) {
            for (int j = 0; j < ds[i].length; ++j) {
                if (!(ds[i][j] > max)) continue;
                max = ds[i][j];
                maxIndices[0] = i;
                maxIndices[1] = j;
            }
        }
        return maxIndices;
    }

    public static void expNormalize(double[] scores) {
        int i;
        double max = MatrixOps.max(scores);
        double sum = 0.0;
        for (i = 0; i < scores.length; ++i) {
            scores[i] = Math.exp(scores[i] - max);
            sum += scores[i];
        }
        i = 0;
        while (i < scores.length) {
            int n = i++;
            scores[n] = scores[n] / sum;
        }
    }
}

