/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.Alphabet;
import cc.mallet.types.FeatureSequence;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class FeatureSequenceWithBigrams
extends FeatureSequence {
    public static final String deletionMark = "NextTokenDeleted";
    Alphabet biDictionary;
    int[] biFeatures;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;
    private static final int NULL_INTEGER = -1;

    public FeatureSequenceWithBigrams(Alphabet dict, Alphabet bigramDictionary, TokenSequence ts) {
        super(dict, ts.size());
        int len = ts.size();
        this.biDictionary = bigramDictionary;
        this.biFeatures = new int[len];
        Token pt = null;
        for (int i = 0; i < len; ++i) {
            Token t = (Token)ts.get(i);
            super.add(t.getText());
            this.biFeatures[i] = pt != null && pt.getProperty(deletionMark) == null ? (this.biDictionary == null ? 0 : this.biDictionary.lookupIndex(pt.getText() + "_" + t.getText(), true)) : -1;
            pt = t;
        }
    }

    public Alphabet getBiAlphabet() {
        return this.biDictionary;
    }

    public final int getBiIndexAtPosition(int pos) {
        return this.biFeatures[pos];
    }

    @Override
    public Object getObjectAtPosition(int pos) {
        return this.biFeatures[pos] == -1 ? null : (this.biDictionary == null ? null : this.biDictionary.lookupObject(this.biFeatures[pos]));
    }

    private void writeObject(ObjectOutputStream out2) throws IOException {
        out2.writeInt(0);
        out2.writeObject(this.biDictionary);
        out2.writeInt(this.biFeatures.length);
        for (int i = 0; i < this.biFeatures.length; ++i) {
            out2.writeInt(this.biFeatures[i]);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.biDictionary = (Alphabet)in.readObject();
        int featuresLength = in.readInt();
        this.biFeatures = new int[featuresLength];
        for (int i = 0; i < featuresLength; ++i) {
            this.biFeatures[i] = in.readInt();
        }
    }
}

