/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.ConstantMatrix;
import cc.mallet.types.DenseMatrix;
import cc.mallet.types.Matrix;
import cc.mallet.types.Matrix2;
import cc.mallet.types.Vector;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class DenseVector
extends DenseMatrix
implements Vector,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    public DenseVector(double[] values, boolean copy) {
        if (copy) {
            this.values = new double[values.length];
            System.arraycopy(values, 0, this.values, 0, values.length);
        } else {
            this.values = values;
        }
    }

    public DenseVector(double[] values) {
        this(values, true);
    }

    public DenseVector(int size) {
        this(new double[size], false);
    }

    @Override
    public int getNumDimensions() {
        return 1;
    }

    @Override
    public int getDimensions(int[] sizes) {
        sizes[0] = this.values.length;
        return 1;
    }

    @Override
    public double value(int[] indices) {
        assert (indices.length == 1);
        return this.values[indices[0]];
    }

    @Override
    public double value(int index) {
        return this.values[index];
    }

    @Override
    public void setValue(int[] indices, double value) {
        assert (indices.length == 1);
        this.values[indices[0]] = value;
    }

    public void setValue(int index, double value) {
        this.values[index] = value;
    }

    public void columnPlusEquals(int columnIndex, double value) {
        int n = columnIndex;
        this.values[n] = this.values[n] + value;
    }

    @Override
    public ConstantMatrix cloneMatrix() {
        return new DenseVector(this.values, true);
    }

    @Override
    public int singleIndex(int[] indices) {
        assert (indices.length == 1);
        return indices[0];
    }

    @Override
    public void singleToIndices(int i, int[] indices) {
        indices[0] = i;
    }

    public final int arrayCopyFrom(int i, Matrix m) {
        if (m instanceof DenseVector) {
            System.arraycopy(((DenseVector)m).values, 0, this.values, i, ((DenseVector)m).values.length);
            return i + ((DenseVector)m).values.length;
        }
        if (m instanceof Matrix2) {
            ((Matrix2)m).arrayCopyInto(this.values, i);
            return i + m.singleSize();
        }
        for (int j = 0; j < m.singleSize(); ++j) {
            this.values[i++] = m.singleValue(j);
        }
        return i;
    }

    public final void arrayCopyFrom(double[] a) {
        this.arrayCopyFrom(a, 0);
    }

    public final int arrayCopyFrom(double[] a, int startingArrayIndex) {
        System.arraycopy(a, startingArrayIndex, this.values, 0, this.values.length);
        return startingArrayIndex + this.values.length;
    }

    public final int arrayCopyTo(int i, Matrix m) {
        if (m instanceof DenseVector) {
            System.arraycopy(this.values, i, ((DenseVector)m).values, 0, ((DenseVector)m).values.length);
            return i + ((DenseVector)m).values.length;
        }
        if (m instanceof Matrix2) {
            ((Matrix2)m).arrayCopyFrom(this.values, i);
            return i + m.singleSize();
        }
        for (int j = 0; j < m.singleSize(); ++j) {
            m.setSingleValue(j, this.values[i++]);
        }
        return i;
    }

    public final int arrayCopyTo(int i, double[] a) {
        System.arraycopy(this.values, i, a, 0, a.length);
        return i + a.length;
    }

    public final int arrayCopyInto(double[] array, int startingArrayIndex) {
        System.arraycopy(this.values, 0, array, startingArrayIndex, this.values.length);
        return startingArrayIndex + this.values.length;
    }

    public void addTo(double[] v) {
        assert (v.length == this.values.length);
        for (int i = 0; i < this.values.length; ++i) {
            int n = i;
            v[n] = v[n] + this.values[i];
        }
    }

    public void addTo(double[] v, double factor) {
        assert (v.length == this.values.length);
        for (int i = 0; i < this.values.length; ++i) {
            int n = i;
            v[n] = v[n] + this.values[i] * factor;
        }
    }

    public static double sum(double[] v) {
        double sum = 0.0;
        for (int i = 0; i < v.length; ++i) {
            sum += v[i];
        }
        return sum;
    }

    public static double normalize(double[] v) {
        int i;
        double sum = 0.0;
        for (i = 0; i < v.length; ++i) {
            sum += v[i];
        }
        assert (sum != 0.0);
        i = 0;
        while (i < v.length) {
            int n = i++;
            v[n] = v[n] / sum;
        }
        return sum;
    }

    public static double max(double[] v) {
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < v.length; ++i) {
            if (!(v[i] > max)) continue;
            max = v[i];
        }
        return max;
    }

    public static void print(double[] v) {
        System.out.print("[");
        for (int i = 0; i < v.length; ++i) {
            System.out.print(" " + v[i]);
        }
        System.out.println("]");
    }

    public static void print(int[] v) {
        System.out.print("[");
        for (int i = 0; i < v.length; ++i) {
            System.out.print(" " + v[i]);
        }
        System.out.println("]");
    }

    private void writeObject(ObjectOutputStream out2) throws IOException {
        out2.writeInt(0);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
    }
}

