/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.topics;

import cc.mallet.topics.ParallelTopicModel;
import cc.mallet.topics.TopicAssignment;
import cc.mallet.types.FeatureSequence;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import gnu.trove.TIntIntHashMap;
import java.io.File;

public class RTopicModel
extends ParallelTopicModel {
    public InstanceList instances = null;

    public RTopicModel(double numTopics, double alpha, double beta) {
        super((int)Math.floor(numTopics), alpha, beta);
    }

    public void loadDocuments(String filename) {
        this.instances = InstanceList.load(new File(filename));
        this.addInstances(this.instances);
    }

    public void loadDocuments(InstanceList instances) {
        this.instances = instances;
        this.addInstances(instances);
    }

    public static void addInstance(InstanceList instances, String id, String text) {
        instances.addThruPipe(new Instance(text, null, id, null));
    }

    public static void addInstances(InstanceList instances, String[] ids, String[] texts) {
        for (int i = 0; i < ids.length; ++i) {
            instances.addThruPipe(new Instance(texts[i], null, ids[i], null));
        }
    }

    public void setAlphaOptimization(double frequency, double burnin) {
        this.setBurninPeriod((int)Math.floor(burnin));
        this.setOptimizeInterval((int)Math.floor(frequency));
    }

    public void train(double numIterations) {
        try {
            this.setNumIterations((int)Math.floor(numIterations));
            this.estimate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void maximize(double numIterations) {
        this.maximize((int)Math.floor(numIterations));
    }

    public double[] getAlpha() {
        return this.alpha;
    }

    public String[] getVocabulary() {
        String[] vocab = new String[this.alphabet.size()];
        for (int type = 0; type < this.numTypes; ++type) {
            vocab[type] = (String)this.alphabet.lookupObject(type);
        }
        return vocab;
    }

    public String[] getDocumentNames() {
        String[] docNames = new String[this.data.size()];
        for (int doc = 0; doc < docNames.length; ++doc) {
            docNames[doc] = (String)((TopicAssignment)this.data.get((int)doc)).instance.getName();
        }
        return docNames;
    }

    public double[][] getWordFrequencies() {
        if (this.instances == null) {
            throw new IllegalStateException("You must load instances before you can count features");
        }
        double[][] result = new double[this.numTypes][2];
        TIntIntHashMap docCounts = new TIntIntHashMap();
        for (Instance instance : this.instances) {
            FeatureSequence features = (FeatureSequence)instance.getData();
            for (int i = 0; i < features.getLength(); ++i) {
                docCounts.adjustOrPutValue(features.getIndexAtPosition(i), 1, 1);
            }
            int[] keys = docCounts.keys();
            for (int i = 0; i < keys.length - 1; ++i) {
                int feature = keys[i];
                double[] dArray = result[feature];
                dArray[0] = dArray[0] + (double)docCounts.get(feature);
                double[] dArray2 = result[feature];
                dArray2[1] = dArray2[1] + 1.0;
            }
            docCounts = new TIntIntHashMap();
        }
        return result;
    }

    public void writeState(String filename) {
        try {
            this.printState(new File(filename));
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }
}

