/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe.tsf.tests;

import cc.mallet.pipe.tsf.SequencePrintingPipe;
import cc.mallet.types.Alphabet;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.FeatureVectorSequence;
import cc.mallet.types.Instance;
import cc.mallet.types.LabelAlphabet;
import cc.mallet.types.LabelSequence;
import java.io.PrintWriter;
import java.io.StringWriter;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestSequencePrintingPipe
extends TestCase {
    public TestSequencePrintingPipe(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite((Class<? extends TestCase>)TestSequencePrintingPipe.class);
    }

    public static void testPrinting() {
        Alphabet dict = TestSequencePrintingPipe.dictOfSize(3);
        FeatureVector[] vecs = new FeatureVector[]{new FeatureVector(dict, new int[]{0, 1}), new FeatureVector(dict, new int[]{0, 2}), new FeatureVector(dict, new int[]{2}), new FeatureVector(dict, new int[]{1, 2})};
        LabelAlphabet ld = TestSequencePrintingPipe.labelDictOfSize(3);
        LabelSequence lbls = new LabelSequence(ld, new int[]{0, 2, 0, 1});
        FeatureVectorSequence fvs = new FeatureVectorSequence(vecs);
        StringWriter sw = new StringWriter();
        PrintWriter w = new PrintWriter(sw);
        SequencePrintingPipe p = new SequencePrintingPipe(w);
        p.instanceFrom(new Instance(fvs, lbls, null, null));
        FeatureVectorSequence fvs2 = new FeatureVectorSequence(new FeatureVector[]{new FeatureVector(dict, new int[]{1}), new FeatureVector(dict, new int[]{0})});
        LabelSequence lbls2 = new LabelSequence(ld, new int[]{2, 1});
        p.instanceFrom(new Instance(fvs2, lbls2, null, null));
        w.close();
        TestSequencePrintingPipe.assertEquals("LABEL0 feature0 feature1\nLABEL2 feature0 feature2\nLABEL0 feature2\nLABEL1 feature1 feature2\n\nLABEL2 feature1\nLABEL1 feature0\n\n", sw.toString());
    }

    private static Alphabet dictOfSize(int n) {
        Alphabet dict = new Alphabet();
        for (int i = 0; i < n; ++i) {
            dict.lookupIndex("feature" + i);
        }
        return dict;
    }

    private static LabelAlphabet labelDictOfSize(int n) {
        LabelAlphabet dict = new LabelAlphabet();
        for (int i = 0; i < n; ++i) {
            dict.lookupIndex("LABEL" + i);
        }
        return dict;
    }

    public static void main(String[] args) throws Throwable {
        TestSuite theSuite;
        if (args.length > 0) {
            theSuite = new TestSuite();
            for (int i = 0; i < args.length; ++i) {
                theSuite.addTest(new TestSequencePrintingPipe(args[i]));
            }
        } else {
            theSuite = (TestSuite)TestSequencePrintingPipe.suite();
        }
        TestRunner.run(theSuite);
    }
}

