/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe.tsf.tests;

import cc.mallet.pipe.Pipe;
import cc.mallet.pipe.PrintInputAndTarget;
import cc.mallet.pipe.SerialPipes;
import cc.mallet.pipe.SimpleTaggerSentence2TokenSequence;
import cc.mallet.pipe.iterator.ArrayIterator;
import cc.mallet.pipe.tsf.OffsetFeatureConjunction;
import cc.mallet.pipe.tsf.RegexMatches;
import cc.mallet.pipe.tsf.TokenText;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import cc.mallet.types.tests.TestSerializable;
import java.io.IOException;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestOffsetFeatureConjunctions
extends TestCase {
    private static String[] doc1 = new String[]{"Meet\nme\nat\n4\nPM\ntomorrow"};

    public TestOffsetFeatureConjunctions(String name) {
        super(name);
    }

    public static void testMultiTag() {
        SerialPipes mtPipe = new SerialPipes(new Pipe[]{new SimpleTaggerSentence2TokenSequence(), new TokenText(), new RegexMatches("digits", Pattern.compile("[0-9]+")), new RegexMatches("ampm", Pattern.compile("[aApP][mM]")), new OffsetFeatureConjunction("time", new String[]{"digits", "ampm"}, new int[]{0, 1}, true), new PrintInputAndTarget()});
        SerialPipes noMtPipe = new SerialPipes(new Pipe[]{new SimpleTaggerSentence2TokenSequence(), new TokenText(), new RegexMatches("digits", Pattern.compile("[0-9]+")), new RegexMatches("ampm", Pattern.compile("[aApP][mM]")), new OffsetFeatureConjunction("time", new String[]{"digits", "ampm"}, new int[]{0, 1}, false), new PrintInputAndTarget()});
        InstanceList mtLst = new InstanceList(mtPipe);
        InstanceList noMtLst = new InstanceList(noMtPipe);
        mtLst.addThruPipe(new ArrayIterator(doc1));
        noMtLst.addThruPipe(new ArrayIterator(doc1));
        Instance mtInst = (Instance)mtLst.get(0);
        Instance noMtInst = (Instance)noMtLst.get(0);
        TokenSequence mtTs = (TokenSequence)mtInst.getData();
        TokenSequence noMtTs = (TokenSequence)noMtInst.getData();
        TestOffsetFeatureConjunctions.assertEquals(6, mtTs.size());
        TestOffsetFeatureConjunctions.assertEquals(6, noMtTs.size());
        TestOffsetFeatureConjunctions.assertEquals(1.0, ((Token)mtTs.get(3)).getFeatureValue("time"), 1.0E-15);
        TestOffsetFeatureConjunctions.assertEquals(1.0, ((Token)noMtTs.get(3)).getFeatureValue("time"), 1.0E-15);
        TestOffsetFeatureConjunctions.assertEquals(1.0, ((Token)mtTs.get(4)).getFeatureValue("time"), 1.0E-15);
        TestOffsetFeatureConjunctions.assertEquals(0.0, ((Token)noMtTs.get(4)).getFeatureValue("time"), 1.0E-15);
    }

    public static void testMultiTagSerialization() throws IOException, ClassNotFoundException {
        SerialPipes origPipe = new SerialPipes(new Pipe[]{new SimpleTaggerSentence2TokenSequence(), new TokenText(), new RegexMatches("digits", Pattern.compile("[0-9]+")), new RegexMatches("ampm", Pattern.compile("[aApP][mM]")), new OffsetFeatureConjunction("time", new String[]{"digits", "ampm"}, new int[]{0, 1}, true), new PrintInputAndTarget()});
        Pipe mtPipe = (Pipe)TestSerializable.cloneViaSerialization(origPipe);
        InstanceList mtLst = new InstanceList(mtPipe);
        mtLst.addThruPipe(new ArrayIterator(doc1));
        Instance mtInst = (Instance)mtLst.get(0);
        TokenSequence mtTs = (TokenSequence)mtInst.getData();
        TestOffsetFeatureConjunctions.assertEquals(6, mtTs.size());
        TestOffsetFeatureConjunctions.assertEquals(1.0, ((Token)mtTs.get(3)).getFeatureValue("time"), 1.0E-15);
        TestOffsetFeatureConjunctions.assertEquals(1.0, ((Token)mtTs.get(4)).getFeatureValue("time"), 1.0E-15);
    }

    public static TestSuite suite() {
        return new TestSuite((Class<? extends TestCase>)TestOffsetFeatureConjunctions.class);
    }

    public static void main(String[] args) {
        TestSuite theSuite;
        if (args.length > 0) {
            theSuite = new TestSuite();
            for (int i = 0; i < args.length; ++i) {
                theSuite.addTest(new TestOffsetFeatureConjunctions(args[i]));
            }
        } else {
            theSuite = TestOffsetFeatureConjunctions.suite();
        }
        TestRunner.run(theSuite);
    }
}

