/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe.tsf;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.regex.Pattern;

public class RegexMatches
extends Pipe
implements Serializable {
    Pattern regex;
    String feature;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    public RegexMatches(String featureName, Pattern regex) {
        this.feature = featureName;
        this.regex = regex;
    }

    @Override
    public Instance pipe(Instance carrier) {
        TokenSequence ts = (TokenSequence)carrier.getData();
        for (int i = 0; i < ts.size(); ++i) {
            Token t = (Token)ts.get(i);
            String s = t.getText();
            String conS = s;
            if (conS.startsWith("(")) {
                conS = conS.substring(1);
            }
            if (conS.endsWith(")") || conS.endsWith(".")) {
                conS = conS.substring(0, conS.length() - 1);
            }
            if (this.regex.matcher(s).matches()) {
                t.setFeatureValue(this.feature, 1.0);
            }
            if (conS.compareTo(s) == 0 || !this.regex.matcher(conS).matches()) continue;
            t.setFeatureValue(this.feature, 1.0);
        }
        return carrier;
    }

    private void writeObject(ObjectOutputStream out2) throws IOException {
        out2.writeInt(0);
        out2.writeObject(this.regex);
        out2.writeObject(this.feature);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.regex = (Pattern)in.readObject();
        this.feature = (String)in.readObject();
    }
}

