/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TokenSequenceNGrams
extends Pipe
implements Serializable {
    int[] gramSizes = null;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    public TokenSequenceNGrams(int[] sizes) {
        this.gramSizes = sizes;
    }

    @Override
    public Instance pipe(Instance carrier) {
        String newTerm = null;
        TokenSequence tmpTS = new TokenSequence();
        TokenSequence ts = (TokenSequence)carrier.getData();
        for (int i = 0; i < ts.size(); ++i) {
            Token t = (Token)ts.get(i);
            for (int j = 0; j < this.gramSizes.length; ++j) {
                int len = this.gramSizes[j];
                if (len <= 0 || len > i + 1) continue;
                if (len == 1) {
                    tmpTS.add(t);
                    continue;
                }
                newTerm = new String(t.getText());
                for (int k = 1; k < len; ++k) {
                    newTerm = ((Token)ts.get(i - k)).getText() + "_" + newTerm;
                }
                tmpTS.add(newTerm);
            }
        }
        carrier.setData(tmpTS);
        return carrier;
    }

    private void writeObject(ObjectOutputStream out2) throws IOException {
        out2.writeInt(0);
        out2.writeInt(this.gramSizes.length);
        for (int i = 0; i < this.gramSizes.length; ++i) {
            out2.writeInt(this.gramSizes[i]);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        int size = in.readInt();
        this.gramSizes = new int[size];
        for (int i = 0; i < size; ++i) {
            this.gramSizes[i] = in.readInt();
        }
    }
}

