/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe;

import cc.mallet.pipe.Pipe;
import cc.mallet.pipe.iterator.EmptyInstanceIterator;
import cc.mallet.types.Alphabet;
import cc.mallet.types.Instance;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class SerialPipes
extends Pipe
implements Serializable {
    ArrayList<Pipe> pipes;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    public SerialPipes() {
        this.pipes = new ArrayList();
    }

    public SerialPipes(Pipe[] pipes) {
        this.pipes = new ArrayList(pipes.length);
        for (int i = 0; i < pipes.length; ++i) {
            this.pipes.add(pipes[i]);
        }
        this.resolveAlphabets();
    }

    public SerialPipes(Collection<Pipe> pipeList) {
        this.pipes = new ArrayList<Pipe>(pipeList);
        this.resolveAlphabets();
    }

    public SerialPipes newSerialPipesFromSuffix(Predicate testForStartingNewPipes) {
        int i = 0;
        while (i < this.pipes.size()) {
            if (!testForStartingNewPipes.predicate(this.pipes.get(i))) continue;
            return new SerialPipes(this.pipes.subList(i, this.pipes.size() - 1));
        }
        throw new IllegalArgumentException("No pipes in this SerialPipe satisfied starting predicate.");
    }

    public SerialPipes newSerialPipesFromRange(int start, int end) {
        return new SerialPipes(this.pipes.subList(start, end));
    }

    private void resolveAlphabets() {
        Alphabet da = null;
        Alphabet ta = null;
        for (Pipe p : this.pipes) {
            p.preceedingPipeDataAlphabetNotification(da);
            da = p.getDataAlphabet();
            p.preceedingPipeTargetAlphabetNotification(ta);
            ta = p.getTargetAlphabet();
        }
        this.dataAlphabet = da;
        this.targetAlphabet = ta;
    }

    @Override
    public void setTargetProcessing(boolean lookForAndProcessTarget) {
        super.setTargetProcessing(lookForAndProcessTarget);
        for (Pipe p : this.pipes) {
            p.setTargetProcessing(lookForAndProcessTarget);
        }
    }

    @Override
    public Iterator<Instance> newIteratorFrom(Iterator<Instance> source) {
        if (this.pipes.size() == 0) {
            return new EmptyInstanceIterator();
        }
        Iterator<Instance> ret = this.pipes.get(0).newIteratorFrom(source);
        for (int i = 1; i < this.pipes.size(); ++i) {
            ret = this.pipes.get(i).newIteratorFrom(ret);
        }
        return ret;
    }

    public int size() {
        return this.pipes.size();
    }

    public Pipe getPipe(int index) {
        Pipe retPipe = null;
        try {
            retPipe = this.pipes.get(index);
        }
        catch (Exception e) {
            System.err.println("Error getting pipe. Index = " + index + ".  " + e.getMessage());
        }
        return retPipe;
    }

    public ArrayList<Pipe> pipes() {
        return this.pipes;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (Pipe p : this.pipes) {
            sb.append(p.toString() + ",");
        }
        return sb.toString();
    }

    private void writeObject(ObjectOutputStream out2) throws IOException {
        out2.writeInt(0);
        out2.writeObject(this.pipes);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.pipes = (ArrayList)in.readObject();
        this.resolveAlphabets();
    }

    public abstract class Predicate {
        public abstract boolean predicate(Pipe var1);
    }
}

