/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe;

import cc.mallet.extract.StringSpan;
import cc.mallet.extract.StringTokenization;
import cc.mallet.pipe.Input2CharSequence;
import cc.mallet.pipe.Pipe;
import cc.mallet.pipe.SerialPipes;
import cc.mallet.types.Instance;
import cc.mallet.types.SingleInstanceIterator;
import cc.mallet.types.TokenSequence;
import cc.mallet.util.CharSequenceLexer;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.regex.Pattern;

public class CharSequence2TokenSequence
extends Pipe
implements Serializable {
    CharSequenceLexer lexer;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    public CharSequence2TokenSequence(CharSequenceLexer lexer) {
        this.lexer = lexer;
    }

    public CharSequence2TokenSequence(String regex) {
        this.lexer = new CharSequenceLexer(regex);
    }

    public CharSequence2TokenSequence(Pattern regex) {
        this.lexer = new CharSequenceLexer(regex);
    }

    public CharSequence2TokenSequence() {
        this(new CharSequenceLexer());
    }

    @Override
    public Instance pipe(Instance carrier) {
        CharSequence string = (CharSequence)carrier.getData();
        this.lexer.setCharSequence(string);
        StringTokenization ts = new StringTokenization(string);
        while (this.lexer.hasNext()) {
            this.lexer.next();
            ts.add(new StringSpan(string, this.lexer.getStartOffset(), this.lexer.getEndOffset()));
        }
        carrier.setData(ts);
        return carrier;
    }

    public static void main(String[] args) {
        try {
            for (int i = 0; i < args.length; ++i) {
                Instance carrier = new Instance(new File(args[i]), null, null, null);
                SerialPipes p = new SerialPipes(new Pipe[]{new Input2CharSequence(), new CharSequence2TokenSequence(new CharSequenceLexer())});
                carrier = p.newIteratorFrom(new SingleInstanceIterator(carrier)).next();
                TokenSequence ts = (TokenSequence)carrier.getData();
                System.out.println("===");
                System.out.println(args[i]);
                System.out.println(ts.toString());
            }
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }

    private void writeObject(ObjectOutputStream out2) throws IOException {
        out2.writeInt(0);
        out2.writeObject(this.lexer);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.lexer = (CharSequenceLexer)in.readObject();
    }
}

