/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class CharSequence2CharNGrams
extends Pipe
implements Serializable {
    int n;
    boolean distinguishBorders = false;
    static char startBorderChar = (char)62;
    static char endBorderChar = (char)60;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    public CharSequence2CharNGrams(int n, boolean distinguishBorders) {
        this.n = n;
        this.distinguishBorders = distinguishBorders;
    }

    protected String[] ngramify(CharSequence s) {
        if (this.distinguishBorders) {
            s = new StringBuffer().append(startBorderChar).append(s).append(endBorderChar).toString();
        }
        int count = s.length() - this.n;
        String[] ngrams = new String[count];
        for (int i = 0; i < count; ++i) {
            ngrams[i] = s.subSequence(i, i + this.n).toString();
        }
        return ngrams;
    }

    @Override
    public Instance pipe(Instance carrier) {
        if (carrier.getData() instanceof CharSequence) {
            carrier.setData(new TokenSequence(this.ngramify((CharSequence)carrier.getData())));
        } else if (carrier.getData() instanceof TokenSequence) {
            TokenSequence ts = (TokenSequence)carrier.getData();
            TokenSequence ret = new TokenSequence();
            for (int i = 0; i < ts.size(); ++i) {
                ret.add(this.ngramify(((Token)ts.get(i)).getText()).toString());
            }
            carrier.setData(ret);
        } else {
            throw new IllegalArgumentException("Unhandled type " + carrier.getData().getClass());
        }
        return carrier;
    }

    private void writeObject(ObjectOutputStream out2) throws IOException {
        out2.writeInt(0);
        out2.writeInt(this.n);
        out2.writeBoolean(this.distinguishBorders);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.n = in.readInt();
        this.distinguishBorders = in.readBoolean();
    }
}

