/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.types;

import cc.mallet.grmm.types.CPT;
import cc.mallet.grmm.types.Factor;
import cc.mallet.grmm.types.FactorGraph;
import cc.mallet.grmm.types.VarSet;
import cc.mallet.grmm.types.Variable;
import gnu.trove.THashMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import org._3pq.jgrapht.DirectedGraph;
import org._3pq.jgrapht.alg.ConnectivityInspector;
import org._3pq.jgrapht.graph.DefaultDirectedGraph;

public class DirectedModel
extends FactorGraph {
    private Map allCpts = new THashMap();
    private DirectedGraph graph = new DefaultDirectedGraph();
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 1;

    public DirectedModel() {
    }

    public DirectedModel(Variable[] vars) {
        super(vars);
    }

    public DirectedModel(int capacity) {
        super(capacity);
    }

    @Override
    protected void beforeFactorAdd(Factor factor) {
        super.beforeFactorAdd(factor);
        if (!(factor instanceof CPT)) {
            throw new IllegalArgumentException("Factors of a directed model must be an instance of CPT, was " + factor);
        }
        CPT cpt = (CPT)factor;
        Variable child = cpt.getChild();
        VarSet parents = cpt.getParents();
        if (this.graph.containsVertex(child)) {
            this.checkForNoCycle(parents, child, cpt);
        }
    }

    private void checkForNoCycle(VarSet parents, Variable child, CPT cpt) {
        ConnectivityInspector inspector = new ConnectivityInspector(this.graph);
        for (Variable rent : parents) {
            if (!inspector.pathExists(child, rent)) continue;
            throw new IllegalArgumentException("Error adding CPT: Would create directed cycleFrom: " + rent + " To:" + child + "\nCPT: " + cpt);
        }
    }

    @Override
    protected void afterFactorAdd(Factor factor) {
        super.afterFactorAdd(factor);
        CPT cpt = (CPT)factor;
        Variable child = cpt.getChild();
        VarSet parents = cpt.getParents();
        this.allCpts.put(child, cpt);
        this.graph.addVertex(child);
        this.graph.addAllVertices(parents);
        for (Variable rent : parents) {
            this.graph.addEdge(rent, child);
        }
    }

    public CPT getCptofVar(Variable node) {
        return (CPT)this.allCpts.get(node);
    }

    private void writeObject(ObjectOutputStream out2) throws IOException {
        out2.defaultWriteObject();
        out2.writeInt(1);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int version = in.readInt();
    }
}

