/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.types;

import gnu.trove.TObjectIntHashMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;

public class BidirectionalIntObjectMap
implements Serializable {
    TObjectIntHashMap map;
    ArrayList entries;
    boolean growthStopped = false;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 1;

    public BidirectionalIntObjectMap(int capacity) {
        this.map = new TObjectIntHashMap(capacity);
        this.entries = new ArrayList(capacity);
    }

    public BidirectionalIntObjectMap() {
        this(8);
    }

    public BidirectionalIntObjectMap(BidirectionalIntObjectMap other) {
        this.map = other.map.clone();
        this.entries = (ArrayList)other.entries.clone();
        this.growthStopped = other.growthStopped;
    }

    public int lookupIndex(Object entry, boolean addIfNotPresent) {
        if (entry == null) {
            throw new IllegalArgumentException("Can't lookup \"null\" in an Alphabet.");
        }
        int retIndex = -1;
        if (this.map.containsKey(entry)) {
            retIndex = this.map.get(entry);
        } else if (!this.growthStopped && addIfNotPresent) {
            retIndex = this.entries.size();
            this.map.put(entry, retIndex);
            this.entries.add(entry);
        }
        return retIndex;
    }

    public int lookupIndex(Object entry) {
        return this.lookupIndex(entry, true);
    }

    public Object lookupObject(int index) {
        return this.entries.get(index);
    }

    public Object[] toArray() {
        return this.entries.toArray();
    }

    public Object[] toArray(Object[] in) {
        return this.entries.toArray(in);
    }

    public Iterator iterator() {
        return this.entries.iterator();
    }

    public Object[] lookupObjects(int[] indices) {
        Object[] ret = new Object[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            ret[i] = this.entries.get(indices[i]);
        }
        return ret;
    }

    public Object[] lookupObjects(int[] indices, Object[] buf) {
        for (int i = 0; i < indices.length; ++i) {
            buf[i] = this.entries.get(indices[i]);
        }
        return buf;
    }

    public int[] lookupIndices(Object[] objects, boolean addIfNotPresent) {
        int[] ret = new int[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            ret[i] = this.lookupIndex(objects[i], addIfNotPresent);
        }
        return ret;
    }

    public boolean contains(Object entry) {
        return this.map.contains(entry);
    }

    public int size() {
        return this.entries.size();
    }

    public void stopGrowth() {
        this.growthStopped = true;
    }

    public void startGrowth() {
        this.growthStopped = false;
    }

    public boolean growthStopped() {
        return this.growthStopped;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.entries.size(); ++i) {
            sb.append(this.entries.get(i).toString());
            sb.append('\n');
        }
        return sb.toString();
    }

    public void dump() {
        this.dump(System.out);
    }

    public void dump(PrintStream out2) {
        this.dump(new PrintWriter((Writer)new OutputStreamWriter(out2), true));
    }

    public void dump(PrintWriter out2) {
        for (int i = 0; i < this.entries.size(); ++i) {
            out2.println(i + " => " + this.entries.get(i));
        }
    }

    private void writeObject(ObjectOutputStream out2) throws IOException {
        out2.writeInt(1);
        out2.writeInt(this.entries.size());
        for (int i = 0; i < this.entries.size(); ++i) {
            out2.writeObject(this.entries.get(i));
        }
        out2.writeBoolean(this.growthStopped);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.readInt();
        int size = in.readInt();
        this.entries = new ArrayList(size);
        this.map = new TObjectIntHashMap(size);
        for (int i = 0; i < size; ++i) {
            Object o = in.readObject();
            this.map.put(o, i);
            this.entries.add(o);
        }
        this.growthStopped = in.readBoolean();
    }
}

