/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.test;

import cc.mallet.grmm.types.BitVarSet;
import cc.mallet.grmm.types.HashVarSet;
import cc.mallet.grmm.types.ListVarSet;
import cc.mallet.grmm.types.Universe;
import cc.mallet.grmm.types.VarSet;
import cc.mallet.grmm.types.Variable;
import cc.mallet.types.tests.TestSerializable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestListVarSet
extends TestCase {
    public TestListVarSet(String name) {
        super(name);
    }

    public void testEqualsHashCode() {
        Variable[] vars = new Variable[4];
        for (int i = 0; i < vars.length; ++i) {
            vars[i] = new Variable(3);
        }
        Universe uni = vars[0].getUniverse();
        ListVarSet c1 = new ListVarSet(uni, Arrays.asList(vars));
        ListVarSet c2 = new ListVarSet(uni, Arrays.asList(vars));
        TestListVarSet.assertTrue(c1.equals(c2));
        TestListVarSet.assertTrue(c2.equals(c1));
        TestListVarSet.assertEquals(c1.hashCode(), c2.hashCode());
    }

    public void testHashCodeByHashVarSet() {
        Variable[] vars = new Variable[2];
        for (int i = 0; i < vars.length; ++i) {
            vars[i] = new Variable(3);
        }
        Universe uni = vars[0].getUniverse();
        ListVarSet c1 = new ListVarSet(uni, Arrays.asList(vars));
        HashVarSet c2 = new HashVarSet(vars);
        TestListVarSet.assertTrue(c1.equals(c2));
        TestListVarSet.assertEquals(c1.hashCode(), c2.hashCode());
    }

    public void testEquals() {
        Variable[] vars = new Variable[4];
        for (int i = 0; i < vars.length; ++i) {
            vars[i] = new Variable(3);
        }
        Universe uni = vars[0].getUniverse();
        ListVarSet c = new ListVarSet(uni, Arrays.asList(vars[0], vars[3]));
        HashVarSet c2 = new HashVarSet(c);
        TestListVarSet.assertTrue(c2.equals(c));
        TestListVarSet.assertTrue(c.equals(c2));
    }

    public void testContains() {
        Variable[] vars = new Variable[4];
        for (int i = 0; i < vars.length; ++i) {
            vars[i] = new Variable(3);
        }
        Universe uni = vars[0].getUniverse();
        ListVarSet c = new ListVarSet(uni, Arrays.asList(vars[0], vars[3]));
        TestListVarSet.assertTrue(c.contains(vars[0]));
        TestListVarSet.assertTrue(!c.contains(vars[1]));
        TestListVarSet.assertTrue(!c.contains(vars[2]));
        TestListVarSet.assertTrue(c.contains(vars[3]));
        TestListVarSet.assertEquals(vars[0], c.get(0));
        TestListVarSet.assertEquals(vars[3], c.get(1));
        TestListVarSet.assertEquals(2, c.size());
    }

    public void testSerialization() throws IOException, ClassNotFoundException {
        Variable[] vars_orig = new Variable[4];
        for (int i = 0; i < vars_orig.length; ++i) {
            vars_orig[i] = new Variable(3);
        }
        Universe uni = vars_orig[0].getUniverse();
        ListVarSet c_orig = new ListVarSet(uni, Arrays.asList(vars_orig[0], vars_orig[3]));
        ListVarSet c = (ListVarSet)TestSerializable.cloneViaSerialization(c_orig);
        Universe uni_new = c.get(0).getUniverse();
        Variable[] vars = new Variable[]{uni_new.get(0), uni_new.get(1), uni_new.get(2), uni_new.get(3)};
        TestListVarSet.assertTrue(c.contains(vars[0]));
        TestListVarSet.assertTrue(!c.contains(vars[1]));
        TestListVarSet.assertTrue(!c.contains(vars[2]));
        TestListVarSet.assertTrue(c.contains(vars[3]));
        TestListVarSet.assertEquals(vars[0], c.get(0));
        TestListVarSet.assertEquals(vars[3], c.get(1));
        TestListVarSet.assertEquals(2, c.size());
    }

    public void testAddAllOrdering() {
        for (int rep = 0; rep < 1000; ++rep) {
            Variable[] vars = new Variable[]{new Variable(2), new Variable(2)};
            Universe uni = vars[0].getUniverse();
            ListVarSet vs = new ListVarSet(uni, Arrays.asList(vars));
            this.checkOrdering(vs, vars);
        }
    }

    public void testAddAllOrdering2() {
        for (int rep = 0; rep < 1000; ++rep) {
            Variable[] vars = new Variable[]{new Variable(2), new Variable(2)};
            Universe uni = vars[0].getUniverse();
            ListVarSet vs = new ListVarSet(uni, new ArrayList());
            vs.addAll(Arrays.asList(vars));
            this.checkOrdering(vs, vars);
        }
    }

    public void testAddAllOrdering3() {
        for (int rep = 0; rep < 1000; ++rep) {
            Variable[] vars = new Variable[]{new Variable(2), new Variable(2)};
            Universe uni = vars[0].getUniverse();
            ListVarSet vsOld = new ListVarSet(uni, Arrays.asList(vars));
            ListVarSet vs = new ListVarSet(vsOld);
            this.checkOrdering(vs, vars);
        }
    }

    public void testIntersectionOrdering() {
        for (int rep = 0; rep < 1000; ++rep) {
            Variable[] varr1 = new Variable[]{new Variable(2), new Variable(2), new Variable(2)};
            Variable[] varr2 = new Variable[]{varr1[0], varr1[1]};
            Universe uni = varr1[0].getUniverse();
            ListVarSet vs1 = new ListVarSet(uni, Arrays.asList(varr1));
            ListVarSet vs2 = new ListVarSet(uni, Arrays.asList(varr2));
            HashVarSet vs_inter = new HashVarSet(vs1.intersection(vs2));
            this.checkOrdering(vs_inter, varr2);
            HashVarSet vs_inter2 = new HashVarSet(vs2.intersection(vs1));
            this.checkOrdering(vs_inter2, varr2);
        }
    }

    public void testIntersectionOrderingToHash() {
        for (int rep = 0; rep < 1000; ++rep) {
            Variable[] varr1 = new Variable[]{new Variable(2), new Variable(2), new Variable(2)};
            Variable[] varr2 = new Variable[]{varr1[0], varr1[1]};
            Universe uni = varr1[0].getUniverse();
            ListVarSet vs1 = new ListVarSet(uni, Arrays.asList(varr1));
            HashVarSet vs2 = new HashVarSet(Arrays.asList(varr2));
            HashVarSet vs_inter = new HashVarSet(vs1.intersection(vs2));
            this.checkOrdering(vs_inter, varr2);
            HashVarSet vs_inter2 = new HashVarSet(vs2.intersection(vs1));
            this.checkOrdering(vs_inter2, varr2);
        }
    }

    public void testIntersectionOrderingToBit() {
        for (int rep = 0; rep < 1000; ++rep) {
            Variable[] varr1 = new Variable[]{new Variable(2), new Variable(2), new Variable(2)};
            Variable[] varr2 = new Variable[]{varr1[0], varr1[1]};
            Universe uni = varr1[0].getUniverse();
            ListVarSet vs1 = new ListVarSet(uni, Arrays.asList(varr1));
            BitVarSet vs2 = new BitVarSet(uni, Arrays.asList(varr2));
            HashVarSet vs_inter = new HashVarSet(vs1.intersection(vs2));
            this.checkOrdering(vs_inter, varr2);
            HashVarSet vs_inter2 = new HashVarSet(vs2.intersection(vs1));
            this.checkOrdering(vs_inter2, varr2);
        }
    }

    private void checkOrdering(VarSet vs, Variable[] vars) {
        TestListVarSet.assertEquals(vars.length, vs.size());
        for (int i = 0; i < vars.length; ++i) {
            TestListVarSet.assertEquals(vars[i], vs.get(i));
        }
    }

    public static Test suite() {
        return new TestSuite((Class<? extends TestCase>)TestListVarSet.class);
    }

    public static void main(String[] args) throws Throwable {
        TestSuite theSuite;
        if (args.length > 0) {
            theSuite = new TestSuite();
            for (int i = 0; i < args.length; ++i) {
                theSuite.addTest(new TestListVarSet(args[i]));
            }
        } else {
            theSuite = (TestSuite)TestListVarSet.suite();
        }
        TestRunner.run(theSuite);
    }
}

