/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.test;

import cc.mallet.grmm.types.BitVarSet;
import cc.mallet.grmm.types.Universe;
import cc.mallet.grmm.types.VarSet;
import cc.mallet.grmm.types.Variable;
import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestBitVarSet
extends TestCase {
    public TestBitVarSet(String name) {
        super(name);
    }

    public void testEqualsHashCode() {
        Variable[] vars = new Variable[4];
        for (int i = 0; i < vars.length; ++i) {
            vars[i] = new Variable(3);
        }
        Universe uni = vars[0].getUniverse();
        BitVarSet c1 = new BitVarSet(uni, Arrays.asList(vars));
        BitVarSet c2 = new BitVarSet(uni, Arrays.asList(vars));
        TestBitVarSet.assertTrue(c1.equals(c2));
        TestBitVarSet.assertTrue(c2.equals(c1));
        TestBitVarSet.assertEquals(c1.hashCode(), c2.hashCode());
    }

    public void testAddAllOrdering() {
        for (int rep = 0; rep < 1000; ++rep) {
            Variable[] vars = new Variable[]{new Variable(2), new Variable(2)};
            Universe uni = vars[0].getUniverse();
            BitVarSet vs = new BitVarSet(uni, Arrays.asList(vars));
            this.checkOrdering(vs, vars);
        }
    }

    public void testAddAllOrdering2() {
        for (int rep = 0; rep < 1000; ++rep) {
            Variable[] vars = new Variable[]{new Variable(2), new Variable(2)};
            Universe uni = vars[0].getUniverse();
            BitVarSet vs = new BitVarSet(uni, new ArrayList());
            vs.addAll(Arrays.asList(vars));
            this.checkOrdering(vs, vars);
        }
    }

    public void testAddAllOrdering3() {
        for (int rep = 0; rep < 1000; ++rep) {
            Variable[] vars = new Variable[]{new Variable(2), new Variable(2)};
            Universe uni = vars[0].getUniverse();
            BitVarSet vsOld = new BitVarSet(uni, Arrays.asList(vars));
            BitVarSet vs = new BitVarSet(vsOld);
            this.checkOrdering(vs, vars);
        }
    }

    private void checkOrdering(VarSet vs, Variable[] vars) {
        TestBitVarSet.assertEquals(vars.length, vs.size());
        for (int i = 0; i < vars.length; ++i) {
            TestBitVarSet.assertEquals(vars[i], vs.get(i));
        }
    }

    public static Test suite() {
        return new TestSuite((Class<? extends TestCase>)TestBitVarSet.class);
    }

    public static void main(String[] args) throws Throwable {
        TestSuite theSuite;
        if (args.length > 0) {
            theSuite = new TestSuite();
            for (int i = 0; i < args.length; ++i) {
                theSuite.addTest(new TestBitVarSet(args[i]));
            }
        } else {
            theSuite = (TestSuite)TestBitVarSet.suite();
        }
        TestRunner.run(theSuite);
    }
}

