/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst;

import cc.mallet.fst.SumLatticeDefault;
import cc.mallet.fst.Transducer;
import cc.mallet.fst.TransducerEvaluator;
import cc.mallet.pipe.Pipe;
import cc.mallet.types.Alphabet;
import cc.mallet.types.FeatureSequence;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.Multinomial;
import cc.mallet.types.Sequence;
import cc.mallet.util.MalletLogger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class HMM
extends Transducer
implements Serializable {
    private static Logger logger = MalletLogger.getLogger(HMM.class.getName());
    static final String LABEL_SEPARATOR = ",";
    Alphabet inputAlphabet;
    Alphabet outputAlphabet;
    ArrayList<State> states = new ArrayList();
    ArrayList<State> initialStates = new ArrayList();
    HashMap<String, State> name2state = new HashMap();
    Multinomial.Estimator[] transitionEstimator;
    Multinomial.Estimator[] emissionEstimator;
    Multinomial.Estimator initialEstimator;
    Multinomial[] transitionMultinomial;
    Multinomial[] emissionMultinomial;
    Multinomial initialMultinomial;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 1;
    static final int NULL_INTEGER = -1;

    public HMM(Pipe inputPipe, Pipe outputPipe) {
        this.inputPipe = inputPipe;
        this.outputPipe = outputPipe;
        this.inputAlphabet = inputPipe.getDataAlphabet();
        this.outputAlphabet = inputPipe.getTargetAlphabet();
    }

    public HMM(Alphabet inputAlphabet, Alphabet outputAlphabet) {
        inputAlphabet.stopGrowth();
        logger.info("HMM input dictionary size = " + inputAlphabet.size());
        this.inputAlphabet = inputAlphabet;
        this.outputAlphabet = outputAlphabet;
    }

    public Alphabet getInputAlphabet() {
        return this.inputAlphabet;
    }

    public Alphabet getOutputAlphabet() {
        return this.outputAlphabet;
    }

    @Override
    public void print() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.numStates(); ++i) {
            State s = (State)this.getState(i);
            sb.append("STATE NAME=\"");
            sb.append(s.name);
            sb.append("\" (");
            sb.append(s.destinations.length);
            sb.append(" outgoing transitions)\n");
            sb.append("  ");
            sb.append("initialWeight= ");
            sb.append(s.initialWeight);
            sb.append('\n');
            sb.append("  ");
            sb.append("finalWeight= ");
            sb.append(s.finalWeight);
            sb.append('\n');
            sb.append("Emission distribution:\n" + this.emissionMultinomial[i] + "\n\n");
            sb.append("Transition distribution:\n" + this.transitionMultinomial[i].toString());
        }
        System.out.println(sb.toString());
    }

    public void addState(String name, double initialWeight, double finalWeight, String[] destinationNames, String[] labelNames) {
        assert (labelNames.length == destinationNames.length);
        if (this.name2state.get(name) != null) {
            throw new IllegalArgumentException("State with name `" + name + "' already exists.");
        }
        State s = new State(name, this.states.size(), initialWeight, finalWeight, destinationNames, labelNames, this);
        s.print();
        this.states.add(s);
        if (initialWeight > Double.NEGATIVE_INFINITY) {
            this.initialStates.add(s);
        }
        this.name2state.put(name, s);
    }

    public void addState(String name, String[] destinationNames) {
        this.addState(name, 0.0, 0.0, destinationNames, destinationNames);
    }

    public void addFullyConnectedStates(String[] stateNames) {
        for (int i = 0; i < stateNames.length; ++i) {
            this.addState(stateNames[i], stateNames);
        }
    }

    public void addFullyConnectedStatesForLabels() {
        String[] labels = new String[this.outputAlphabet.size()];
        for (int i = 0; i < this.outputAlphabet.size(); ++i) {
            labels[i] = (String)this.outputAlphabet.lookupObject(i);
        }
        this.addFullyConnectedStates(labels);
    }

    private boolean[][] labelConnectionsIn(InstanceList trainingSet) {
        int numLabels = this.outputAlphabet.size();
        boolean[][] connections = new boolean[numLabels][numLabels];
        for (Instance instance : trainingSet) {
            FeatureSequence output = (FeatureSequence)instance.getTarget();
            for (int j = 1; j < output.size(); ++j) {
                int sourceIndex = this.outputAlphabet.lookupIndex(output.get(j - 1));
                int destIndex = this.outputAlphabet.lookupIndex(output.get(j));
                assert (sourceIndex >= 0 && destIndex >= 0);
                connections[sourceIndex][destIndex] = true;
            }
        }
        return connections;
    }

    public void addStatesForLabelsConnectedAsIn(InstanceList trainingSet) {
        int numLabels = this.outputAlphabet.size();
        boolean[][] connections = this.labelConnectionsIn(trainingSet);
        for (int i = 0; i < numLabels; ++i) {
            int numDestinations = 0;
            for (int j = 0; j < numLabels; ++j) {
                if (!connections[i][j]) continue;
                ++numDestinations;
            }
            String[] destinationNames = new String[numDestinations];
            int destinationIndex = 0;
            for (int j = 0; j < numLabels; ++j) {
                if (!connections[i][j]) continue;
                destinationNames[destinationIndex++] = (String)this.outputAlphabet.lookupObject(j);
            }
            this.addState((String)this.outputAlphabet.lookupObject(i), destinationNames);
        }
    }

    public void addStatesForHalfLabelsConnectedAsIn(InstanceList trainingSet) {
        int numLabels = this.outputAlphabet.size();
        boolean[][] connections = this.labelConnectionsIn(trainingSet);
        for (int i = 0; i < numLabels; ++i) {
            int numDestinations = 0;
            for (int j = 0; j < numLabels; ++j) {
                if (!connections[i][j]) continue;
                ++numDestinations;
            }
            String[] destinationNames = new String[numDestinations];
            int destinationIndex = 0;
            for (int j = 0; j < numLabels; ++j) {
                if (!connections[i][j]) continue;
                destinationNames[destinationIndex++] = (String)this.outputAlphabet.lookupObject(j);
            }
            this.addState((String)this.outputAlphabet.lookupObject(i), 0.0, 0.0, destinationNames, destinationNames);
        }
    }

    public void addStatesForThreeQuarterLabelsConnectedAsIn(InstanceList trainingSet) {
        int numLabels = this.outputAlphabet.size();
        boolean[][] connections = this.labelConnectionsIn(trainingSet);
        for (int i = 0; i < numLabels; ++i) {
            int numDestinations = 0;
            for (int j = 0; j < numLabels; ++j) {
                if (!connections[i][j]) continue;
                ++numDestinations;
            }
            String[] destinationNames = new String[numDestinations];
            int destinationIndex = 0;
            for (int j = 0; j < numLabels; ++j) {
                String labelName;
                if (!connections[i][j]) continue;
                destinationNames[destinationIndex] = labelName = (String)this.outputAlphabet.lookupObject(j);
                ++destinationIndex;
            }
            this.addState((String)this.outputAlphabet.lookupObject(i), 0.0, 0.0, destinationNames, destinationNames);
        }
    }

    public void addFullyConnectedStatesForThreeQuarterLabels(InstanceList trainingSet) {
        int numLabels = this.outputAlphabet.size();
        for (int i = 0; i < numLabels; ++i) {
            String[] destinationNames = new String[numLabels];
            for (int j = 0; j < numLabels; ++j) {
                String labelName;
                destinationNames[j] = labelName = (String)this.outputAlphabet.lookupObject(j);
            }
            this.addState((String)this.outputAlphabet.lookupObject(i), 0.0, 0.0, destinationNames, destinationNames);
        }
    }

    public void addFullyConnectedStatesForBiLabels() {
        int i;
        String[] labels = new String[this.outputAlphabet.size()];
        for (i = 0; i < this.outputAlphabet.size(); ++i) {
            labels[i] = this.outputAlphabet.lookupObject(i).toString();
        }
        for (i = 0; i < labels.length; ++i) {
            for (int j = 0; j < labels.length; ++j) {
                String[] destinationNames = new String[labels.length];
                for (int k = 0; k < labels.length; ++k) {
                    destinationNames[k] = labels[j] + LABEL_SEPARATOR + labels[k];
                }
                this.addState(labels[i] + LABEL_SEPARATOR + labels[j], 0.0, 0.0, destinationNames, labels);
            }
        }
    }

    public void addStatesForBiLabelsConnectedAsIn(InstanceList trainingSet) {
        int numLabels = this.outputAlphabet.size();
        boolean[][] connections = this.labelConnectionsIn(trainingSet);
        for (int i = 0; i < numLabels; ++i) {
            for (int j = 0; j < numLabels; ++j) {
                if (!connections[i][j]) continue;
                int numDestinations = 0;
                for (int k = 0; k < numLabels; ++k) {
                    if (!connections[j][k]) continue;
                    ++numDestinations;
                }
                String[] destinationNames = new String[numDestinations];
                String[] labels = new String[numDestinations];
                int destinationIndex = 0;
                for (int k = 0; k < numLabels; ++k) {
                    if (!connections[j][k]) continue;
                    destinationNames[destinationIndex] = (String)this.outputAlphabet.lookupObject(j) + LABEL_SEPARATOR + (String)this.outputAlphabet.lookupObject(k);
                    labels[destinationIndex] = (String)this.outputAlphabet.lookupObject(k);
                    ++destinationIndex;
                }
                this.addState((String)this.outputAlphabet.lookupObject(i) + LABEL_SEPARATOR + (String)this.outputAlphabet.lookupObject(j), 0.0, 0.0, destinationNames, labels);
            }
        }
    }

    public void addFullyConnectedStatesForTriLabels() {
        int i;
        String[] labels = new String[this.outputAlphabet.size()];
        for (i = 0; i < this.outputAlphabet.size(); ++i) {
            logger.info("HMM: outputAlphabet.lookup class = " + this.outputAlphabet.lookupObject(i).getClass().getName());
            labels[i] = this.outputAlphabet.lookupObject(i).toString();
        }
        for (i = 0; i < labels.length; ++i) {
            for (int j = 0; j < labels.length; ++j) {
                for (int k = 0; k < labels.length; ++k) {
                    String[] destinationNames = new String[labels.length];
                    for (int l = 0; l < labels.length; ++l) {
                        destinationNames[l] = labels[j] + LABEL_SEPARATOR + labels[k] + LABEL_SEPARATOR + labels[l];
                    }
                    this.addState(labels[i] + LABEL_SEPARATOR + labels[j] + LABEL_SEPARATOR + labels[k], 0.0, 0.0, destinationNames, labels);
                }
            }
        }
    }

    public void addSelfTransitioningStateForAllLabels(String name) {
        String[] labels = new String[this.outputAlphabet.size()];
        String[] destinationNames = new String[this.outputAlphabet.size()];
        for (int i = 0; i < this.outputAlphabet.size(); ++i) {
            labels[i] = this.outputAlphabet.lookupObject(i).toString();
            destinationNames[i] = name;
        }
        this.addState(name, 0.0, 0.0, destinationNames, labels);
    }

    private String concatLabels(String[] labels) {
        String sep = "";
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < labels.length; ++i) {
            buf.append(sep).append(labels[i]);
            sep = LABEL_SEPARATOR;
        }
        return buf.toString();
    }

    private String nextKGram(String[] history, int k, String next) {
        int start;
        String sep = "";
        StringBuffer buf = new StringBuffer();
        for (int i = start = history.length + 1 - k; i < history.length; ++i) {
            buf.append(sep).append(history[i]);
            sep = LABEL_SEPARATOR;
        }
        buf.append(sep).append(next);
        return buf.toString();
    }

    private boolean allowedTransition(String prev, String curr, Pattern no, Pattern yes) {
        String pair = this.concatLabels(new String[]{prev, curr});
        if (no != null && no.matcher(pair).matches()) {
            return false;
        }
        return yes == null || yes.matcher(pair).matches();
    }

    private boolean allowedHistory(String[] history, Pattern no, Pattern yes) {
        for (int i = 1; i < history.length; ++i) {
            if (this.allowedTransition(history[i - 1], history[i], no, yes)) continue;
            return false;
        }
        return true;
    }

    public String addOrderNStates(InstanceList trainingSet, int[] orders, boolean[] defaults, String start, Pattern forbidden, Pattern allowed, boolean fullyConnected) {
        int s;
        boolean[][] connections = null;
        if (!fullyConnected) {
            connections = this.labelConnectionsIn(trainingSet);
        }
        int order = -1;
        if (defaults != null && defaults.length != orders.length) {
            throw new IllegalArgumentException("Defaults must be null or match orders");
        }
        if (orders == null) {
            order = 0;
        } else {
            for (int i = 0; i < orders.length; ++i) {
                if (orders[i] <= order) {
                    throw new IllegalArgumentException("Orders must be non-negative and in ascending order");
                }
                order = orders[i];
            }
            if (order < 0) {
                order = 0;
            }
        }
        if (order > 0) {
            int[] historyIndexes = new int[order];
            String[] history = new String[order];
            String label0 = (String)this.outputAlphabet.lookupObject(0);
            for (int i = 0; i < order; ++i) {
                history[i] = label0;
            }
            int numLabels = this.outputAlphabet.size();
            block2: while (historyIndexes[0] < numLabels) {
                logger.info("Preparing " + this.concatLabels(history));
                if (this.allowedHistory(history, forbidden, allowed)) {
                    String stateName = this.concatLabels(history);
                    int nt = 0;
                    String[] destNames = new String[numLabels];
                    String[] labelNames = new String[numLabels];
                    for (int nextIndex = 0; nextIndex < numLabels; ++nextIndex) {
                        String next = (String)this.outputAlphabet.lookupObject(nextIndex);
                        if (!this.allowedTransition(history[order - 1], next, forbidden, allowed) || !fullyConnected && !connections[historyIndexes[order - 1]][nextIndex]) continue;
                        destNames[nt] = this.nextKGram(history, order, next);
                        labelNames[nt] = next;
                        ++nt;
                    }
                    if (nt < numLabels) {
                        String[] newDestNames = new String[nt];
                        String[] newLabelNames = new String[nt];
                        for (int t = 0; t < nt; ++t) {
                            newDestNames[t] = destNames[t];
                            newLabelNames[t] = labelNames[t];
                        }
                        destNames = newDestNames;
                        labelNames = newLabelNames;
                    }
                    this.addState(stateName, 0.0, 0.0, destNames, labelNames);
                }
                for (int o = order - 1; o >= 0; --o) {
                    int n = o;
                    historyIndexes[n] = historyIndexes[n] + 1;
                    if (historyIndexes[n] < numLabels) {
                        history[o] = (String)this.outputAlphabet.lookupObject(historyIndexes[o]);
                        continue block2;
                    }
                    if (o <= 0) continue;
                    historyIndexes[o] = 0;
                    history[o] = label0;
                }
            }
            for (int i = 0; i < order; ++i) {
                history[i] = start;
            }
            return this.concatLabels(history);
        }
        String[] stateNames = new String[this.outputAlphabet.size()];
        for (s = 0; s < this.outputAlphabet.size(); ++s) {
            stateNames[s] = (String)this.outputAlphabet.lookupObject(s);
        }
        for (s = 0; s < this.outputAlphabet.size(); ++s) {
            this.addState(stateNames[s], 0.0, 0.0, stateNames, stateNames);
        }
        return start;
    }

    public State getState(String name) {
        return this.name2state.get(name);
    }

    @Override
    public int numStates() {
        return this.states.size();
    }

    @Override
    public Transducer.State getState(int index) {
        return this.states.get(index);
    }

    @Override
    public Iterator initialStateIterator() {
        return this.initialStates.iterator();
    }

    public boolean isTrainable() {
        return true;
    }

    private Alphabet getTransitionAlphabet() {
        Alphabet transitionAlphabet = new Alphabet();
        for (int i = 0; i < this.numStates(); ++i) {
            transitionAlphabet.lookupIndex(this.getState(i).getName(), true);
        }
        return transitionAlphabet;
    }

    @Deprecated
    public void reset() {
        this.emissionEstimator = new Multinomial.LaplaceEstimator[this.numStates()];
        this.transitionEstimator = new Multinomial.LaplaceEstimator[this.numStates()];
        this.emissionMultinomial = new Multinomial[this.numStates()];
        this.transitionMultinomial = new Multinomial[this.numStates()];
        Alphabet transitionAlphabet = this.getTransitionAlphabet();
        for (int i = 0; i < this.numStates(); ++i) {
            this.emissionEstimator[i] = new Multinomial.LaplaceEstimator(this.inputAlphabet);
            this.transitionEstimator[i] = new Multinomial.LaplaceEstimator(transitionAlphabet);
            this.emissionMultinomial[i] = new Multinomial(this.getUniformArray(this.inputAlphabet.size()), this.inputAlphabet);
            this.transitionMultinomial[i] = new Multinomial(this.getUniformArray(transitionAlphabet.size()), transitionAlphabet);
        }
        this.initialMultinomial = new Multinomial(this.getUniformArray(transitionAlphabet.size()), transitionAlphabet);
        this.initialEstimator = new Multinomial.LaplaceEstimator(transitionAlphabet);
    }

    public void initTransitions(Random random, double noise) {
        Alphabet transitionAlphabet = this.getTransitionAlphabet();
        this.initialMultinomial = new Multinomial(this.getRandomArray(transitionAlphabet.size(), random, noise), transitionAlphabet);
        this.initialEstimator = new Multinomial.LaplaceEstimator(transitionAlphabet);
        this.transitionMultinomial = new Multinomial[this.numStates()];
        this.transitionEstimator = new Multinomial.LaplaceEstimator[this.numStates()];
        for (int i = 0; i < this.numStates(); ++i) {
            this.transitionMultinomial[i] = new Multinomial(this.getRandomArray(transitionAlphabet.size(), random, noise), transitionAlphabet);
            this.transitionEstimator[i] = new Multinomial.LaplaceEstimator(transitionAlphabet);
            State s = (State)this.getState(i);
            s.setInitialWeight(this.initialMultinomial.logProbability(s.getName()));
        }
    }

    public void initEmissions(Random random, double noise) {
        this.emissionMultinomial = new Multinomial[this.numStates()];
        this.emissionEstimator = new Multinomial.LaplaceEstimator[this.numStates()];
        for (int i = 0; i < this.numStates(); ++i) {
            this.emissionMultinomial[i] = new Multinomial(this.getRandomArray(this.inputAlphabet.size(), random, noise), this.inputAlphabet);
            this.emissionEstimator[i] = new Multinomial.LaplaceEstimator(this.inputAlphabet);
        }
    }

    public void estimate() {
        Alphabet transitionAlphabet = this.getTransitionAlphabet();
        this.initialMultinomial = this.initialEstimator.estimate();
        this.initialEstimator = new Multinomial.LaplaceEstimator(transitionAlphabet);
        for (int i = 0; i < this.numStates(); ++i) {
            State s = (State)this.getState(i);
            this.emissionMultinomial[i] = this.emissionEstimator[i].estimate();
            this.transitionMultinomial[i] = this.transitionEstimator[i].estimate();
            s.setInitialWeight(this.initialMultinomial.logProbability(s.getName()));
            this.emissionEstimator[i] = new Multinomial.LaplaceEstimator(this.inputAlphabet);
            this.transitionEstimator[i] = new Multinomial.LaplaceEstimator(transitionAlphabet);
        }
    }

    public boolean train(InstanceList ilist) {
        return this.train(ilist, null, null);
    }

    public boolean train(InstanceList ilist, InstanceList validation, InstanceList testing) {
        return this.train(ilist, validation, testing, null);
    }

    public boolean train(InstanceList ilist, InstanceList validation, InstanceList testing, TransducerEvaluator eval) {
        assert (ilist.size() > 0);
        if (this.emissionEstimator == null) {
            int i;
            this.emissionEstimator = new Multinomial.LaplaceEstimator[this.numStates()];
            this.transitionEstimator = new Multinomial.LaplaceEstimator[this.numStates()];
            this.emissionMultinomial = new Multinomial[this.numStates()];
            this.transitionMultinomial = new Multinomial[this.numStates()];
            Alphabet transitionAlphabet = new Alphabet();
            for (i = 0; i < this.numStates(); ++i) {
                transitionAlphabet.lookupIndex(this.states.get(i).getName(), true);
            }
            for (i = 0; i < this.numStates(); ++i) {
                this.emissionEstimator[i] = new Multinomial.LaplaceEstimator(this.inputAlphabet);
                this.transitionEstimator[i] = new Multinomial.LaplaceEstimator(transitionAlphabet);
                this.emissionMultinomial[i] = new Multinomial(this.getUniformArray(this.inputAlphabet.size()), this.inputAlphabet);
                this.transitionMultinomial[i] = new Multinomial(this.getUniformArray(transitionAlphabet.size()), transitionAlphabet);
            }
            this.initialEstimator = new Multinomial.LaplaceEstimator(transitionAlphabet);
        }
        for (Instance instance : ilist) {
            FeatureSequence input = (FeatureSequence)instance.getData();
            FeatureSequence output = (FeatureSequence)instance.getTarget();
            new SumLatticeDefault(this, input, output, new Incrementor());
        }
        this.initialMultinomial = this.initialEstimator.estimate();
        for (int i = 0; i < this.numStates(); ++i) {
            this.emissionMultinomial[i] = this.emissionEstimator[i].estimate();
            this.transitionMultinomial[i] = this.transitionEstimator[i].estimate();
            this.getState(i).setInitialWeight(this.initialMultinomial.logProbability(this.getState(i).getName()));
        }
        return true;
    }

    public void write(File f) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(f));
            oos.writeObject(this);
            oos.close();
        }
        catch (IOException e) {
            System.err.println("Exception writing file " + f + ": " + e);
        }
    }

    private double[] getUniformArray(int size) {
        double[] ret = new double[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = 1.0 / (double)size;
        }
        return ret;
    }

    private double[] getRandomArray(int size, Random random, double noise) {
        int i;
        double[] ret = new double[size];
        double sum = 0.0;
        for (i = 0; i < size; ++i) {
            ret[i] = random == null ? 1.0 : Math.pow(1.0 + random.nextDouble(), noise);
            sum += ret[i];
        }
        i = 0;
        while (i < size) {
            int n = i++;
            ret[n] = ret[n] / sum;
        }
        return ret;
    }

    private void writeObject(ObjectOutputStream out2) throws IOException {
        int i;
        out2.writeInt(1);
        out2.writeObject(this.inputPipe);
        out2.writeObject(this.outputPipe);
        out2.writeObject(this.inputAlphabet);
        out2.writeObject(this.outputAlphabet);
        int size = this.states.size();
        out2.writeInt(size);
        for (i = 0; i < size; ++i) {
            out2.writeObject(this.states.get(i));
        }
        size = this.initialStates.size();
        out2.writeInt(size);
        for (i = 0; i < size; ++i) {
            out2.writeObject(this.initialStates.get(i));
        }
        out2.writeObject(this.name2state);
        if (this.emissionEstimator != null) {
            size = this.emissionEstimator.length;
            out2.writeInt(size);
            for (i = 0; i < size; ++i) {
                out2.writeObject(this.emissionEstimator[i]);
            }
        } else {
            out2.writeInt(-1);
        }
        if (this.emissionMultinomial != null) {
            size = this.emissionMultinomial.length;
            out2.writeInt(size);
            for (i = 0; i < size; ++i) {
                out2.writeObject(this.emissionMultinomial[i]);
            }
        } else {
            out2.writeInt(-1);
        }
        if (this.transitionEstimator != null) {
            size = this.transitionEstimator.length;
            out2.writeInt(size);
            for (i = 0; i < size; ++i) {
                out2.writeObject(this.transitionEstimator[i]);
            }
        } else {
            out2.writeInt(-1);
        }
        if (this.transitionMultinomial != null) {
            size = this.transitionMultinomial.length;
            out2.writeInt(size);
            for (i = 0; i < size; ++i) {
                out2.writeObject(this.transitionMultinomial[i]);
            }
        } else {
            out2.writeInt(-1);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        State s;
        int i;
        int version = in.readInt();
        this.inputPipe = (Pipe)in.readObject();
        this.outputPipe = (Pipe)in.readObject();
        this.inputAlphabet = (Alphabet)in.readObject();
        this.outputAlphabet = (Alphabet)in.readObject();
        int size = in.readInt();
        this.states = new ArrayList();
        for (i = 0; i < size; ++i) {
            s = (State)in.readObject();
            this.states.add(s);
        }
        size = in.readInt();
        this.initialStates = new ArrayList();
        for (i = 0; i < size; ++i) {
            s = (State)in.readObject();
            this.initialStates.add(s);
        }
        this.name2state = (HashMap)in.readObject();
        size = in.readInt();
        if (size == -1) {
            this.emissionEstimator = null;
        } else {
            this.emissionEstimator = new Multinomial.Estimator[size];
            for (i = 0; i < size; ++i) {
                this.emissionEstimator[i] = (Multinomial.Estimator)in.readObject();
            }
        }
        size = in.readInt();
        if (size == -1) {
            this.emissionMultinomial = null;
        } else {
            this.emissionMultinomial = new Multinomial[size];
            for (i = 0; i < size; ++i) {
                this.emissionMultinomial[i] = (Multinomial)in.readObject();
            }
        }
        size = in.readInt();
        if (size == -1) {
            this.transitionEstimator = null;
        } else {
            this.transitionEstimator = new Multinomial.Estimator[size];
            for (i = 0; i < size; ++i) {
                this.transitionEstimator[i] = (Multinomial.Estimator)in.readObject();
            }
        }
        size = in.readInt();
        if (size == -1) {
            this.transitionMultinomial = null;
        } else {
            this.transitionMultinomial = new Multinomial[size];
            for (i = 0; i < size; ++i) {
                this.transitionMultinomial[i] = (Multinomial)in.readObject();
            }
        }
    }

    protected static class TransitionIterator
    extends Transducer.TransitionIterator
    implements Serializable {
        State source;
        int index;
        int nextIndex;
        int inputPos;
        double[] weights;
        FeatureSequence inputSequence;
        Integer inputFeature;
        HMM hmm;
        private static final long serialVersionUID = 1L;
        private static final int CURRENT_SERIAL_VERSION = 0;
        private static final int NULL_INTEGER = -1;

        public TransitionIterator(State source, FeatureSequence inputSeq, int inputPosition, String output, HMM hmm) {
            this.source = source;
            this.hmm = hmm;
            this.inputSequence = inputSeq;
            this.inputFeature = new Integer(this.inputSequence.getIndexAtPosition(inputPosition));
            this.inputPos = inputPosition;
            this.weights = new double[source.destinations.length];
            for (int transIndex = 0; transIndex < source.destinations.length; ++transIndex) {
                if (output == null || output.equals(source.labels[transIndex])) {
                    this.weights[transIndex] = 0.0;
                    int destIndex = source.getDestinationState(transIndex).getIndex();
                    double logEmissionProb = hmm.emissionMultinomial[destIndex].logProbability(inputSeq.get(inputPosition));
                    double logTransitionProb = hmm.transitionMultinomial[source.getIndex()].logProbability(source.destinationNames[transIndex]);
                    this.weights[transIndex] = logEmissionProb + logTransitionProb;
                    assert (!Double.isNaN(this.weights[transIndex]));
                    continue;
                }
                this.weights[transIndex] = Double.NEGATIVE_INFINITY;
            }
            this.nextIndex = 0;
            while (this.nextIndex < source.destinations.length && this.weights[this.nextIndex] == Double.NEGATIVE_INFINITY) {
                ++this.nextIndex;
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < this.source.destinations.length;
        }

        @Override
        public Transducer.State nextState() {
            assert (this.nextIndex < this.source.destinations.length);
            this.index = this.nextIndex++;
            while (this.nextIndex < this.source.destinations.length && this.weights[this.nextIndex] == Double.NEGATIVE_INFINITY) {
                ++this.nextIndex;
            }
            return this.source.getDestinationState(this.index);
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public Object getInput() {
            return this.inputFeature;
        }

        @Override
        public Object getOutput() {
            return this.source.labels[this.index];
        }

        @Override
        public double getWeight() {
            return this.weights[this.index];
        }

        @Override
        public Transducer.State getSourceState() {
            return this.source;
        }

        @Override
        public Transducer.State getDestinationState() {
            return this.source.getDestinationState(this.index);
        }

        private void writeObject(ObjectOutputStream out2) throws IOException {
            out2.writeInt(0);
            out2.writeObject(this.source);
            out2.writeInt(this.index);
            out2.writeInt(this.nextIndex);
            out2.writeInt(this.inputPos);
            if (this.weights != null) {
                out2.writeInt(this.weights.length);
                for (int i = 0; i < this.weights.length; ++i) {
                    out2.writeDouble(this.weights[i]);
                }
            } else {
                out2.writeInt(-1);
            }
            out2.writeObject(this.inputSequence);
            out2.writeObject(this.inputFeature);
            out2.writeObject(this.hmm);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            int version = in.readInt();
            this.source = (State)in.readObject();
            this.index = in.readInt();
            this.nextIndex = in.readInt();
            this.inputPos = in.readInt();
            int size = in.readInt();
            if (size == -1) {
                this.weights = null;
            } else {
                this.weights = new double[size];
                for (int i = 0; i < size; ++i) {
                    this.weights[i] = in.readDouble();
                }
            }
            this.inputSequence = (FeatureSequence)in.readObject();
            this.inputFeature = (Integer)in.readObject();
            this.hmm = (HMM)in.readObject();
        }
    }

    public static class State
    extends Transducer.State
    implements Serializable {
        String name;
        int index;
        double initialWeight;
        double finalWeight;
        String[] destinationNames;
        State[] destinations;
        String[] labels;
        HMM hmm;
        private static final long serialVersionUID = 1L;
        private static final int CURRENT_SERIAL_VERSION = 0;
        private static final int NULL_INTEGER = -1;

        protected State() {
        }

        protected State(String name, int index, double initialWeight, double finalWeight, String[] destinationNames, String[] labelNames, HMM hmm) {
            assert (destinationNames.length == labelNames.length);
            this.name = name;
            this.index = index;
            this.initialWeight = initialWeight;
            this.finalWeight = finalWeight;
            this.destinationNames = new String[destinationNames.length];
            this.destinations = new State[labelNames.length];
            this.labels = new String[labelNames.length];
            this.hmm = hmm;
            for (int i = 0; i < labelNames.length; ++i) {
                hmm.outputAlphabet.lookupIndex(labelNames[i]);
                this.destinationNames[i] = destinationNames[i];
                this.labels[i] = labelNames[i];
            }
        }

        @Override
        public Transducer getTransducer() {
            return this.hmm;
        }

        @Override
        public double getFinalWeight() {
            return this.finalWeight;
        }

        @Override
        public double getInitialWeight() {
            return this.initialWeight;
        }

        @Override
        public void setFinalWeight(double c) {
            this.finalWeight = c;
        }

        @Override
        public void setInitialWeight(double c) {
            this.initialWeight = c;
        }

        public void print() {
            System.out.println("State #" + this.index + " \"" + this.name + "\"");
            System.out.println("initialWeight=" + this.initialWeight + ", finalWeight=" + this.finalWeight);
            System.out.println("#destinations=" + this.destinations.length);
            for (int i = 0; i < this.destinations.length; ++i) {
                System.out.println("-> " + this.destinationNames[i]);
            }
        }

        public State getDestinationState(int index) {
            State ret = this.destinations[index];
            if (ret == null) {
                ret = this.destinations[index] = this.hmm.name2state.get(this.destinationNames[index]);
                assert (ret != null) : index;
            }
            return ret;
        }

        @Override
        public Transducer.TransitionIterator transitionIterator(Sequence inputSequence, int inputPosition, Sequence outputSequence, int outputPosition) {
            if (inputPosition < 0 || outputPosition < 0) {
                throw new UnsupportedOperationException("Epsilon transitions not implemented.");
            }
            if (inputSequence == null) {
                throw new UnsupportedOperationException("HMMs are generative models; but this is not yet implemented.");
            }
            if (!(inputSequence instanceof FeatureSequence)) {
                throw new UnsupportedOperationException("HMMs currently expect Instances to have FeatureSequence data");
            }
            return new TransitionIterator(this, (FeatureSequence)inputSequence, inputPosition, outputSequence == null ? null : (String)outputSequence.get(outputPosition), this.hmm);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        public void incrementInitialCount(double count) {
        }

        public void incrementFinalCount(double count) {
        }

        private void writeObject(ObjectOutputStream out2) throws IOException {
            int i;
            out2.writeInt(0);
            out2.writeObject(this.name);
            out2.writeInt(this.index);
            int size = this.destinationNames == null ? -1 : this.destinationNames.length;
            out2.writeInt(size);
            if (size != -1) {
                for (i = 0; i < size; ++i) {
                    out2.writeObject(this.destinationNames[i]);
                }
            }
            size = this.destinations == null ? -1 : this.destinations.length;
            out2.writeInt(size);
            if (size != -1) {
                for (i = 0; i < size; ++i) {
                    out2.writeObject(this.destinations[i]);
                }
            }
            size = this.labels == null ? -1 : this.labels.length;
            out2.writeInt(size);
            if (size != -1) {
                for (i = 0; i < size; ++i) {
                    out2.writeObject(this.labels[i]);
                }
            }
            out2.writeObject(this.hmm);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            int i;
            int version = in.readInt();
            this.name = (String)in.readObject();
            this.index = in.readInt();
            int size = in.readInt();
            if (size != -1) {
                this.destinationNames = new String[size];
                for (i = 0; i < size; ++i) {
                    this.destinationNames[i] = (String)in.readObject();
                }
            } else {
                this.destinationNames = null;
            }
            if ((size = in.readInt()) != -1) {
                this.destinations = new State[size];
                for (i = 0; i < size; ++i) {
                    this.destinations[i] = (State)in.readObject();
                }
            } else {
                this.destinations = null;
            }
            if ((size = in.readInt()) != -1) {
                this.labels = new String[size];
                for (i = 0; i < size; ++i) {
                    this.labels[i] = (String)in.readObject();
                }
            } else {
                this.labels = null;
            }
            this.hmm = (HMM)in.readObject();
        }
    }

    public class WeightedIncrementor
    implements Transducer.Incrementor {
        double weight = 1.0;

        public WeightedIncrementor(double wt) {
            this.weight = wt;
        }

        @Override
        public void incrementFinalState(Transducer.State s, double count) {
        }

        @Override
        public void incrementInitialState(Transducer.State s, double count) {
            HMM.this.initialEstimator.increment(s.getName(), this.weight * count);
        }

        @Override
        public void incrementTransition(Transducer.TransitionIterator ti, double count) {
            int inputFtr = (Integer)ti.getInput();
            State src = (State)((TransitionIterator)ti).getSourceState();
            State dest = (State)((TransitionIterator)ti).getDestinationState();
            int index = ti.getIndex();
            HMM.this.emissionEstimator[index].increment(inputFtr, this.weight * count);
            HMM.this.transitionEstimator[src.getIndex()].increment(dest.getName(), this.weight * count);
        }
    }

    public class Incrementor
    implements Transducer.Incrementor {
        @Override
        public void incrementFinalState(Transducer.State s, double count) {
        }

        @Override
        public void incrementInitialState(Transducer.State s, double count) {
            HMM.this.initialEstimator.increment(s.getName(), count);
        }

        @Override
        public void incrementTransition(Transducer.TransitionIterator ti, double count) {
            int inputFtr = (Integer)ti.getInput();
            State src = (State)((TransitionIterator)ti).getSourceState();
            State dest = (State)((TransitionIterator)ti).getDestinationState();
            int index = ti.getIndex();
            HMM.this.emissionEstimator[index].increment(inputFtr, count);
            HMM.this.transitionEstimator[src.getIndex()].increment(dest.getName(), count);
        }
    }
}

