/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.extract.test;

import cc.mallet.extract.CRFExtractor;
import cc.mallet.extract.Extraction;
import cc.mallet.extract.LatticeViewer;
import cc.mallet.fst.CRF;
import cc.mallet.fst.CRFTrainerByLabelLikelihood;
import cc.mallet.fst.MEMM;
import cc.mallet.fst.MEMMTrainer;
import cc.mallet.fst.TokenAccuracyEvaluator;
import cc.mallet.fst.tests.TestCRF;
import cc.mallet.fst.tests.TestMEMM;
import cc.mallet.pipe.Pipe;
import cc.mallet.pipe.SerialPipes;
import cc.mallet.pipe.iterator.ArrayIterator;
import cc.mallet.types.InstanceList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestLatticeViewer
extends TestCase {
    private static File htmlFile = new File("errors.html");
    private static File latticeFile = new File("lattice.html");
    private static File htmlDir = new File("html/");

    public TestLatticeViewer(String name) {
        super(name);
    }

    public void testSpaceViewer() throws FileNotFoundException {
        Pipe pipe = TestMEMM.makeSpacePredictionPipe();
        Object[] data0 = new String[]{TestCRF.data[0]};
        Object[] data1 = new String[]{TestCRF.data[1]};
        InstanceList training = new InstanceList(pipe);
        training.addThruPipe(new ArrayIterator(data0));
        InstanceList testing = new InstanceList(pipe);
        testing.addThruPipe(new ArrayIterator(data1));
        CRF crf = new CRF(pipe, null);
        crf.addFullyConnectedStatesForLabels();
        CRFTrainerByLabelLikelihood crft = new CRFTrainerByLabelLikelihood(crf);
        crft.trainIncremental(training);
        CRFExtractor extor = TestLatticeViewer.hackCrfExtor(crf);
        Extraction extration = extor.extract(new ArrayIterator(data1));
        PrintStream out2 = new PrintStream(new FileOutputStream(htmlFile));
        LatticeViewer.extraction2html(extration, extor, out2);
        out2.close();
        out2 = new PrintStream(new FileOutputStream(latticeFile));
        LatticeViewer.extraction2html(extration, extor, out2, true);
        out2.close();
    }

    static CRFExtractor hackCrfExtor(CRF crf) {
        Pipe[] newPipes = new Pipe[3];
        SerialPipes pipes = (SerialPipes)crf.getInputPipe();
        for (int i = 0; i < 3; ++i) {
            Pipe p0;
            newPipes[i] = p0 = pipes.getPipe(0);
        }
        SerialPipes tokPipe = new SerialPipes(newPipes);
        CRFExtractor extor = new CRFExtractor(crf, tokPipe);
        return extor;
    }

    public void testDualSpaceViewer() throws IOException {
        Pipe pipe = TestMEMM.makeSpacePredictionPipe();
        Object[] data0 = new String[]{TestCRF.data[0]};
        Object[] data1 = TestCRF.data;
        InstanceList training = new InstanceList(pipe);
        training.addThruPipe(new ArrayIterator(data0));
        InstanceList testing = new InstanceList(pipe);
        testing.addThruPipe(new ArrayIterator(data1));
        CRF crf = new CRF(pipe, null);
        crf.addFullyConnectedStatesForLabels();
        CRFTrainerByLabelLikelihood crft = new CRFTrainerByLabelLikelihood(crf);
        TokenAccuracyEvaluator eval = new TokenAccuracyEvaluator(new InstanceList[]{training, testing}, new String[]{"Training", "Testing"});
        for (int i = 0; i < 5; ++i) {
            crft.train(training, 1);
            eval.evaluate(crft);
        }
        CRFExtractor extor = TestLatticeViewer.hackCrfExtor(crf);
        Extraction e1 = extor.extract(new ArrayIterator(data1));
        Pipe pipe2 = TestMEMM.makeSpacePredictionPipe();
        InstanceList training2 = new InstanceList(pipe2);
        training2.addThruPipe(new ArrayIterator(data0));
        InstanceList testing2 = new InstanceList(pipe2);
        testing2.addThruPipe(new ArrayIterator(data1));
        MEMM memm = new MEMM(pipe2, null);
        memm.addFullyConnectedStatesForLabels();
        MEMMTrainer memmt = new MEMMTrainer(memm);
        TokenAccuracyEvaluator memmeval = new TokenAccuracyEvaluator(new InstanceList[]{training2, testing2}, new String[]{"Training2", "Testing2"});
        memmt.train(training2, 5);
        memmeval.evaluate(memmt);
        CRFExtractor extor2 = TestLatticeViewer.hackCrfExtor(memm);
        Extraction e2 = extor2.extract(new ArrayIterator(data1));
        if (!htmlDir.exists()) {
            htmlDir.mkdir();
        }
        LatticeViewer.viewDualResults(htmlDir, e1, extor, e2, extor2);
    }

    public static Test suite() {
        return new TestSuite((Class<? extends TestCase>)TestLatticeViewer.class);
    }

    public static void main(String[] args) throws Throwable {
        TestSuite theSuite;
        if (args.length > 0) {
            theSuite = new TestSuite();
            for (int i = 0; i < args.length; ++i) {
                theSuite.addTest(new TestLatticeViewer(args[i]));
            }
        } else {
            theSuite = (TestSuite)TestLatticeViewer.suite();
        }
        TestRunner.run(theSuite);
    }
}

