/*
 * Decompiled with CFR 0.152.
 */
package IPVGenerateVTD;

import IPVGenerateVTD.InferenceRule;
import IPVGenerateVTD.Path;
import IPVGenerateVTD.PathNode;
import IPVGenerateVTD.PathSet;
import com.ximpleware.AutoPilot;
import com.ximpleware.ModifyException;
import com.ximpleware.NavException;
import com.ximpleware.TranscodeException;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import com.ximpleware.XMLModifier;
import com.ximpleware.XPathEvalException;
import com.ximpleware.XPathParseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import org.xml.sax.SAXException;

public class IPVGenerateVTD {
    public static String filepath = "C:\\MedicalDB";
    public static int PathNodeTypeElement = 1;
    public static int PathNodeTypeAttribute = 2;

    public static void main(String[] args) throws XPathParseException, XPathEvalException, NavException, TranscodeException, IOException, XPathExpressionException, ParserConfigurationException, SAXException, TransformerException, CloneNotSupportedException, ModifyException {
        if (args.length > 0) {
            IPVGenerateVTD.generateIPV(args[0]);
        } else {
            System.out.println("Please input the correct parameter:");
            System.out.println("filename");
        }
    }

    private static void generateIPV(String filename) throws XPathExpressionException, ParserConfigurationException, SAXException, IOException, TransformerException, CloneNotSupportedException, XPathParseException, XPathEvalException, NavException, TranscodeException, ModifyException {
        ArrayList<InferenceRule> irs = IPVGenerateVTD.ConstructInferenceRule();
        ArrayList potentialsecrets = IPVGenerateVTD.readpotentialsecretpath(filename);
        String fileName = String.valueOf(filepath) + filename + ".xml";
        String outputfilename = "";
        String resultfilename = String.valueOf(filepath) + filename + "_IPV.txt";
        File outputfile = new File(resultfilename);
        FileWriter outputfilewriter = new FileWriter(outputfile, true);
        long time1 = System.currentTimeMillis();
        boolean firststep = true;
        boolean tempfilename = true;
        ArrayList Delta = new ArrayList();
        while (true) {
            VTDGen vg = new VTDGen();
            XMLModifier xm = new XMLModifier();
            if (tempfilename) {
                outputfilename = String.valueOf(filepath) + filename + "_2.xml";
                tempfilename = false;
            } else {
                outputfilename = String.valueOf(filepath) + filename + "_3.xml";
                tempfilename = true;
            }
            FileOutputStream os = new FileOutputStream(outputfilename);
            if (vg.parseFile(fileName, true)) {
                int k;
                VTDNav vn = vg.getNav();
                xm.bind(vn);
                if (firststep) {
                    Delta = potentialsecrets;
                    firststep = false;
                } else {
                    Delta = IPVGenerateVTD.ConstructDelta(vn, irs);
                }
                ArrayList Gamma = new ArrayList();
                if (Delta.size() == 0) break;
                int j = 0;
                while (j < Delta.size()) {
                    PathSet pathset = (PathSet)Delta.get(j);
                    PathSet P = IPVGenerateVTD.func_obtaincandidate(pathset);
                    k = 0;
                    while (k < P.pathset.size()) {
                        Path p = (Path)P.pathset.get(k);
                        IPVGenerateVTD.proc_insertpath(Gamma, p);
                        ++k;
                    }
                    ++j;
                }
                IPVGenerateVTD.proc_refinepathset(Gamma);
                while (!Delta.isEmpty()) {
                    PathSet P = (PathSet)Gamma.get(0);
                    int j2 = 1;
                    while (j2 < Gamma.size()) {
                        PathSet P1 = (PathSet)Gamma.get(j2);
                        if (P1.pathset.size() > P.pathset.size()) {
                            P = P1;
                        }
                        ++j2;
                    }
                    IPVGenerateVTD.proc_weakendocument(vn, xm, P);
                    Gamma.remove(P);
                    j2 = 0;
                    while (j2 < P.pathset.size()) {
                        Path p = (Path)P.pathset.get(j2);
                        k = 0;
                        while (k < Delta.size()) {
                            PathSet delta = (PathSet)Delta.get(k);
                            if (delta.id == p.id) {
                                Delta.remove(k);
                                break;
                            }
                            ++k;
                        }
                        k = 0;
                        while (k < Gamma.size()) {
                            PathSet gamma = (PathSet)Gamma.get(k);
                            int l = 0;
                            while (l < gamma.pathset.size()) {
                                Path p1 = (Path)gamma.pathset.get(l);
                                if (p1.id == p.id) {
                                    gamma.pathset.remove(l);
                                }
                                ++l;
                            }
                            ++k;
                        }
                        ++j2;
                    }
                }
            }
            xm.output(os);
            ((OutputStream)os).close();
            fileName = outputfilename;
        }
        long time = System.currentTimeMillis() - time1;
        outputfilewriter.write(String.valueOf(filename) + ":" + time + "\r\n");
        System.out.println(String.valueOf(filename) + ":" + time);
        outputfilewriter.close();
    }

    private static void proc_weakendocument(VTDNav vn, XMLModifier xm, PathSet P) throws NavException, UnsupportedEncodingException, XPathParseException, XPathEvalException {
        AutoPilot ap = new AutoPilot();
        ap.bind(vn);
        int i = 0;
        while (i < P.pathset.size()) {
            int index;
            Path p = (Path)P.pathset.get(i);
            String xpathstring = "/MedicalDB" + IPVGenerateVTD.ConstructXPath(p, p.pnr);
            ap.selectXPath(xpathstring);
            while ((index = ap.evalXPath()) != -1) {
                if (p.pnl.type == PathNodeTypeElement) {
                    long l = vn.getContentFragment();
                    String elementcontent = vn.toString((int)l, (int)(l >> 32));
                    try {
                        xm.remove();
                        xm.insertBeforeElement(elementcontent);
                    }
                    catch (ModifyException e) {
                        e.toString();
                    }
                    continue;
                }
                String a = p.pnl.label;
                String aname = a.substring(a.indexOf(64) + 1, a.indexOf(35));
                if (aname.equals("value")) {
                    int textindex = vn.getText();
                    if (textindex == -1) continue;
                    try {
                        xm.updateToken(textindex, "");
                    }
                    catch (ModifyException e) {
                        e.toString();
                    }
                    continue;
                }
                try {
                    xm.removeAttribute(vn.getAttrVal(aname) - 1);
                }
                catch (ModifyException e) {
                    e.toString();
                }
            }
            ap.resetXPath();
            ++i;
        }
    }

    private static ArrayList<InferenceRule> ConstructInferenceRule() {
        PathNode pn4;
        PathNode pn3;
        PathNode pn2_6;
        PathNode pn2;
        PathNode pn1;
        Path path;
        int j;
        InferenceRule ir;
        ArrayList<InferenceRule> irs = new ArrayList<InferenceRule>();
        String[][] irstrings1 = new String[][]{{"Smith", "treatment2"}, {"Smith", "treatment8"}, {"Edward", "treatment20"}, {"Edward", "treatment21"}, {"Hunter", "treatment26"}, {"Hunter", "treatment28"}, {"Longman", "treatment32"}, {"Longman", "treatment33"}, {"Lee", "treatment65"}, {"Lee", "treatment41"}, {"Morley", "treatment71"}, {"Morley", "treatment48"}, {"Occam", "treatment68"}, {"Occam", "treatment51"}, {"Ralph", "treatment74"}, {"Ralph", "treatment54"}, {"Roland", "treatment67"}, {"Roland", "treatment55"}, {"Simon", "treatment70"}, {"Simon", "treatment56"}};
        String[][] irstrings2 = new String[][]{{"treatment5", "treatment4", "Hypertension"}, {"treatment8", "treatment9", "Heart Attack"}, {"treatment15", "treatment16", "Apoplexy"}, {"treatment18", "treatment17", "Apoplexy"}, {"treatment21", "treatment22", "Bronchitis"}, {"treatment25", "treatment26", "Cirrhosis"}, {"treatment29", "treatment30", "Gastric Ulcer"}, {"treatment32", "treatment34", "Influenza"}, {"treatment35", "treatment36", "Rheumatoid Arthritis"}, {"treatment39", "treatment38", "Rheumatoid Arthritis"}, {"treatment42", "treatment41", "Neurasthenia"}, {"treatment45", "treatment44", "Cataract"}, {"treatment48", "treatment49", "Heterotropia"}, {"treatment13", "treatment37", "Pharyngitis"}, {"treatment50", "treatment51", "Diabetes"}, {"treatment53", "treatment52", "Headache"}, {"treatment24", "treatment74", "Scabies"}, {"treatment47", "treatment55", "Anemia"}, {"treatment27", "treatment40", "Angina Pectoris"}, {"treatment78", "treatment56", "Arteriosclerosis"}, {"treatment36", "treatment57", "Leukemia"}, {"treatment82", "treatment58", "Malnutrition"}};
        String[][] irstrings3 = new String[][]{{"symptom1", "symptom3", "treatment4"}, {"symptom1", "symptom4", "treatment6"}, {"symptom8", "symptom10", "treatment9"}, {"symptom14", "symptom15", "treatment17"}, {"symptom18", "symptom20", "treatment26"}, {"symptom19", "symptom22", "treatment30"}, {"symptom13", "symptom23", "treatment34"}, {"symptom25", "symptom26", "treatment38"}, {"symptom11", "symptom27", "treatment41"}, {"symptom28", "symptom29", "treatment44"}, {"symptom16", "symptom30", "treatment49"}, {"symptom31", "symptom32", "treatment66"}, {"symptom6", "symptom33", "treatment51"}, {"symptom17", "symptom34", "treatment52"}, {"symptom12", "symptom59", "treatment54"}, {"symptom35", "symptom37", "treatment55"}, {"symptom55", "symptom38", "treatment40"}, {"symptom24", "symptom39", "treatment56"}, {"symptom40", "symptom41", "treatment57"}, {"symptom21", "symptom42", "treatment58"}};
        int i = 0;
        while (i < irstrings1.length) {
            ir = new InferenceRule();
            j = 0;
            while (j < 3) {
                path = new Path();
                pn1 = new PathNode();
                pn1.label = "patient";
                pn1.type = PathNodeTypeElement;
                path.pnr = pn1;
                path.PNE.add(pn1);
                path.Backbone.add(pn1);
                pn2 = new PathNode();
                pn2.label = "@pname#var_x";
                pn2.type = PathNodeTypeAttribute;
                pn2.parent = pn1;
                path.PNA.add(pn2);
                PathNode pn2_5 = new PathNode();
                PathNode pn2_62 = new PathNode();
                if (j == 0) {
                    pn2_62.label = "disease";
                    pn2_62.type = PathNodeTypeElement;
                    pn2_62.parent = pn1;
                    path.PNE.add(pn2_62);
                    path.Backbone.add(pn2_62);
                } else {
                    pn2_62.label = "treatments";
                    pn2_62.type = PathNodeTypeElement;
                    pn2_62.parent = pn1;
                    path.PNE.add(pn2_62);
                    path.Backbone.add(pn2_62);
                    if (j == 2) {
                        pn2_5.label = "experiment";
                        pn2_5.type = PathNodeTypeElement;
                        pn2_5.parent = pn2_62;
                        path.PNE.add(pn2_5);
                        path.Backbone.add(pn2_5);
                    }
                }
                PathNode pn32 = new PathNode();
                pn32.label = j == 0 ? "doctor" : "treatment";
                pn32.type = PathNodeTypeElement;
                pn32.parent = j == 2 ? pn2_5 : pn2_62;
                path.PNE.add(pn32);
                path.Backbone.add(pn32);
                PathNode pn42 = new PathNode();
                pn42.type = PathNodeTypeAttribute;
                pn42.label = j == 2 ? "@value#" + irstrings1[i][1] : "@value#" + irstrings1[i][j];
                pn42.parent = pn32;
                path.PNA.add(pn42);
                path.Backbone.add(pn42);
                path.pnl = pn42;
                if (j == 2) {
                    ir.targetpath = path;
                } else {
                    ir.conditionpart.add(path);
                }
                ++j;
            }
            irs.add(ir);
            ++i;
        }
        i = 0;
        while (i < irstrings2.length) {
            ir = new InferenceRule();
            j = 0;
            while (j < 3) {
                path = new Path();
                pn1 = new PathNode();
                pn1.label = "patient";
                pn1.type = PathNodeTypeElement;
                path.pnr = pn1;
                path.PNE.add(pn1);
                path.Backbone.add(pn1);
                pn2 = new PathNode();
                pn2.label = "@pname#var_x";
                pn2.type = PathNodeTypeAttribute;
                pn2.parent = pn1;
                path.PNA.add(pn2);
                pn2_6 = new PathNode();
                if (j != 2) {
                    pn2_6.label = "treatments";
                    pn2_6.type = PathNodeTypeElement;
                    pn2_6.parent = pn1;
                    path.PNE.add(pn2_6);
                    path.Backbone.add(pn2_6);
                }
                pn3 = new PathNode();
                pn3.label = j == 2 ? "disease" : "treatment";
                pn3.type = PathNodeTypeElement;
                pn3.parent = j == 2 ? pn1 : pn2_6;
                path.PNE.add(pn3);
                path.Backbone.add(pn3);
                pn4 = new PathNode();
                pn4.type = PathNodeTypeAttribute;
                pn4.label = j == 2 ? "@dname#" + irstrings2[i][j] : "@value#" + irstrings2[i][j];
                pn4.parent = pn3;
                path.PNA.add(pn4);
                path.Backbone.add(pn4);
                path.pnl = pn4;
                if (j == 2) {
                    ir.targetpath = path;
                } else {
                    ir.conditionpart.add(path);
                }
                ++j;
            }
            irs.add(ir);
            ++i;
        }
        i = 0;
        while (i < irstrings3.length) {
            ir = new InferenceRule();
            j = 0;
            while (j < 3) {
                path = new Path();
                pn1 = new PathNode();
                pn1.label = "patient";
                pn1.type = PathNodeTypeElement;
                path.pnr = pn1;
                path.PNE.add(pn1);
                path.Backbone.add(pn1);
                pn2 = new PathNode();
                pn2.label = "@pname#var_x";
                pn2.type = PathNodeTypeAttribute;
                pn2.parent = pn1;
                path.PNA.add(pn2);
                pn2_6 = new PathNode();
                pn2_6.label = j != 2 ? "symptoms" : "treatments";
                pn2_6.type = PathNodeTypeElement;
                pn2_6.parent = pn1;
                path.PNE.add(pn2_6);
                path.Backbone.add(pn2_6);
                pn3 = new PathNode();
                pn3.label = j == 2 ? "treatment" : "symptom";
                pn3.type = PathNodeTypeElement;
                pn3.parent = pn2_6;
                path.PNE.add(pn3);
                path.Backbone.add(pn3);
                pn4 = new PathNode();
                pn4.type = PathNodeTypeAttribute;
                pn4.label = "@value#" + irstrings3[i][j];
                pn4.parent = pn3;
                path.PNA.add(pn4);
                path.Backbone.add(pn4);
                path.pnl = pn4;
                if (j == 2) {
                    ir.targetpath = path;
                } else {
                    ir.conditionpart.add(path);
                }
                ++j;
            }
            irs.add(ir);
            ++i;
        }
        return irs;
    }

    private static ArrayList readpotentialsecretpath(String filename) throws IOException {
        ArrayList<PathSet> als = new ArrayList<PathSet>();
        String psFileName = String.valueOf(filepath) + "potentialsecret" + filename + ".txt";
        File psFile = new File(psFileName);
        BufferedReader reader = new BufferedReader(new FileReader(psFile));
        String tempString = null;
        int id = 0;
        while ((tempString = reader.readLine()) != null) {
            ArrayList al = new ArrayList();
            tempString = tempString.replace("/MedicalDB", "");
            Path path = new Path();
            PathNode pn = new PathNode();
            pn.label = "patient";
            pn.type = PathNodeTypeElement;
            path.pnr = pn;
            path.PNE.add(pn);
            path.Backbone.add(pn);
            tempString = tempString.replace("//patient", "");
            PathNode pn1 = new PathNode();
            int index = tempString.indexOf("[");
            String pnamestr = tempString.substring(tempString.indexOf("["), tempString.indexOf("]") + 1);
            pnamestr = pnamestr.replace("[", "");
            pnamestr = pnamestr.replace(" = \"", "#");
            pn1.label = pnamestr = pnamestr.replace("\"]", "");
            pn1.type = PathNodeTypeAttribute;
            pn1.parent = pn;
            path.PNA.add(pn1);
            tempString = tempString.substring(tempString.indexOf("]") + 1);
            if (tempString.indexOf("experiment") != -1) {
                PathNode pn2_5 = new PathNode();
                pn2_5.label = "treatments";
                pn2_5.type = PathNodeTypeElement;
                pn2_5.parent = pn;
                path.PNE.add(pn2_5);
                path.Backbone.add(pn2_5);
                PathNode pn2 = new PathNode();
                pn2.label = "experiment";
                pn2.type = PathNodeTypeElement;
                pn2.parent = pn2_5;
                path.PNE.add(pn2);
                path.Backbone.add(pn2);
                path.pnl = pn2;
            } else {
                PathNode pn2 = new PathNode();
                pn2.label = "disease";
                pn2.type = PathNodeTypeElement;
                pn2.parent = pn;
                path.PNE.add(pn2);
                path.Backbone.add(pn2);
                PathNode pn3 = new PathNode();
                String diseasestr = tempString.substring(tempString.indexOf("["), tempString.indexOf("]") + 1);
                diseasestr = diseasestr.replace("[", "");
                diseasestr = diseasestr.replace("@dname = \"", "@dname#");
                pn3.label = diseasestr = diseasestr.replace("\"]", "");
                pn3.parent = pn2;
                pn3.type = PathNodeTypeAttribute;
                path.PNA.add(pn3);
                path.Backbone.add(pn3);
                path.pnl = pn3;
            }
            PathSet pathset = new PathSet();
            pathset.id = ++id;
            pathset.pathset.add(path);
            als.add(pathset);
        }
        reader.close();
        return als;
    }

    private static PathSet func_obtaincandidate(PathSet pathset) throws CloneNotSupportedException {
        PathNode pe;
        Enumeration e;
        Path path;
        Enumeration e2;
        Path path2;
        String[][] availableelementtype = new String[][]{{"MedicalDB", "100"}, {"patient", "11"}, {"treatments", "10"}, {"symptoms", "9"}, {"symptom", "8"}, {"disease", "7"}, {"treatment", "6"}, {"doctor", "5"}, {"experiment", "4"}};
        PathSet candidates = new PathSet();
        candidates.id = pathset.id;
        int i = 0;
        while (i < pathset.pathset.size()) {
            path2 = (Path)pathset.pathset.get(i);
            e2 = Collections.enumeration(path2.PNA);
            while (e2.hasMoreElements()) {
                PathNode pa = (PathNode)e2.nextElement();
                Enumeration e1 = Collections.enumeration(path2.PNE);
                while (e1.hasMoreElements()) {
                    PathNode pe2 = (PathNode)e1.nextElement();
                    if (!pe2.equals(pa.parent)) continue;
                    boolean aetype = false;
                    int j = 0;
                    while (j < availableelementtype.length) {
                        if (pe2.label.equals(availableelementtype[j][0])) {
                            aetype = true;
                            break;
                        }
                        ++j;
                    }
                    if (aetype) continue;
                    Path newpath = IPVGenerateVTD.copypath(path2);
                    newpath.id = pathset.id;
                    newpath.Backbone.clear();
                    newpath.pnl = pa;
                    newpath.Backbone.add(pa);
                    newpath.Backbone.add(pe2);
                    if (pe2.parent != null) {
                        block4: do {
                            Enumeration e22 = Collections.enumeration(path2.PNE);
                            while (e22.hasMoreElements()) {
                                PathNode pe1 = (PathNode)e22.nextElement();
                                if (!pe1.equals(pe2.parent)) continue;
                                newpath.Backbone.add(pe1);
                                pe2 = pe1;
                                continue block4;
                            }
                        } while (pe2.parent != null);
                    }
                    candidates.pathset.add(newpath);
                }
            }
            ++i;
        }
        if (candidates.pathset.size() == 0) {
            i = 0;
            while (i < pathset.pathset.size()) {
                path2 = (Path)pathset.pathset.get(i);
                e2 = Collections.enumeration(path2.PNE);
                while (e2.hasMoreElements()) {
                    PathNode pe3 = (PathNode)e2.nextElement();
                    boolean aetype = false;
                    int j = 0;
                    while (j < availableelementtype.length) {
                        if (pe3.label.equals(availableelementtype[j][0])) {
                            aetype = true;
                            break;
                        }
                        ++j;
                    }
                    if (aetype) continue;
                    Path newpath = IPVGenerateVTD.copypath(path2);
                    newpath.id = pathset.id;
                    newpath.Backbone.clear();
                    newpath.pnl = pe3;
                    newpath.Backbone.add(pe3);
                    if (pe3.parent != null) {
                        block9: do {
                            Enumeration e23 = Collections.enumeration(path2.PNE);
                            while (e23.hasMoreElements()) {
                                PathNode pe1 = (PathNode)e23.nextElement();
                                if (!pe1.equals(pe3.parent)) continue;
                                newpath.Backbone.add(pe1);
                                pe3 = pe1;
                                continue block9;
                            }
                        } while (pe3.parent != null);
                    }
                    candidates.pathset.add(newpath);
                }
                ++i;
            }
        }
        int smallestnumber = 100;
        if (candidates.pathset.size() == 0) {
            int i2 = 0;
            while (i2 < pathset.pathset.size()) {
                path = (Path)pathset.pathset.get(i2);
                e = Collections.enumeration(path.PNE);
                block12: while (e.hasMoreElements()) {
                    pe = (PathNode)e.nextElement();
                    int j = 0;
                    while (j < availableelementtype.length) {
                        if (pe.label.equals(availableelementtype[j][0])) {
                            int num = Integer.valueOf(availableelementtype[j][1]);
                            if (smallestnumber <= num) continue block12;
                            smallestnumber = num;
                            continue block12;
                        }
                        ++j;
                    }
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < pathset.pathset.size()) {
                path = (Path)pathset.pathset.get(i2);
                e = Collections.enumeration(path.PNA);
                block15: while (e.hasMoreElements()) {
                    PathNode pa = (PathNode)e.nextElement();
                    Enumeration e1 = Collections.enumeration(path.PNE);
                    while (e1.hasMoreElements()) {
                        PathNode pe4 = (PathNode)e1.nextElement();
                        if (!pe4.equals(pa.parent)) continue;
                        int j = 0;
                        while (j < availableelementtype.length) {
                            if (pe4.label.equals(availableelementtype[j][0])) {
                                if (smallestnumber != Integer.valueOf(availableelementtype[j][1])) continue block15;
                                Path newpath = IPVGenerateVTD.copypath(path);
                                newpath.id = pathset.id;
                                newpath.Backbone.clear();
                                newpath.pnl = pa;
                                newpath.Backbone.add(pa);
                                newpath.Backbone.add(pe4);
                                if (pe4.parent != null) {
                                    block18: do {
                                        Enumeration e24 = Collections.enumeration(path.PNE);
                                        while (e24.hasMoreElements()) {
                                            PathNode pe1 = (PathNode)e24.nextElement();
                                            if (!pe1.equals(pe4.parent)) continue;
                                            newpath.Backbone.add(pe1);
                                            pe4 = pe1;
                                            continue block18;
                                        }
                                    } while (pe4.parent != null);
                                }
                                candidates.pathset.add(newpath);
                                continue block15;
                            }
                            ++j;
                        }
                        continue block15;
                    }
                }
                ++i2;
            }
        }
        if (candidates.pathset.size() == 0) {
            int i3 = 0;
            while (i3 < pathset.pathset.size()) {
                path = (Path)pathset.pathset.get(i3);
                e = Collections.enumeration(path.PNE);
                block21: while (e.hasMoreElements()) {
                    pe = (PathNode)e.nextElement();
                    int j = 0;
                    while (j < availableelementtype.length) {
                        if (pe.label.equals(availableelementtype[j][0])) {
                            if (smallestnumber != Integer.valueOf(availableelementtype[j][1])) continue block21;
                            Path newpath = IPVGenerateVTD.copypath(path);
                            newpath.id = pathset.id;
                            newpath.Backbone.clear();
                            newpath.pnl = pe;
                            newpath.Backbone.add(pe);
                            if (pe.parent != null) {
                                block23: do {
                                    Enumeration e25 = Collections.enumeration(path.PNE);
                                    while (e25.hasMoreElements()) {
                                        PathNode pe1 = (PathNode)e25.nextElement();
                                        if (!pe1.equals(pe.parent)) continue;
                                        newpath.Backbone.add(pe1);
                                        pe = pe1;
                                        continue block23;
                                    }
                                } while (pe.parent != null);
                            }
                            candidates.pathset.add(newpath);
                            continue block21;
                        }
                        ++j;
                    }
                }
                ++i3;
            }
        }
        return candidates;
    }

    private static void proc_insertpath(ArrayList Gamma, Path p) {
        boolean getbackboneequ = false;
        int i = 0;
        while (i < Gamma.size()) {
            Path p1;
            PathSet ps = (PathSet)Gamma.get(i);
            if (!ps.pathset.isEmpty() && IPVGenerateVTD.backboneequ(p, p1 = (Path)ps.pathset.get(0))) {
                ps.pathset.add(p);
                getbackboneequ = true;
            }
            ++i;
        }
        if (!getbackboneequ) {
            PathSet ps = new PathSet();
            ps.pathset.add(p);
            ps.id = p.id;
            Gamma.add(ps);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static boolean backboneequ(Path p1, Path p2) {
        pn1_1 = p1.pnl;
        pn2_1 = p2.pnl;
        if (!pn1_1.label.equals(pn2_1.label) || pn1_1.type != pn2_1.type) {
            return false;
        }
        block0: while (true) {
            e = Collections.enumeration(p1.Backbone);
            if (pn1_1.parent != null) ** GOTO lbl25
            return pn2_1.parent == null;
lbl-1000:
            // 1 sources

            {
                pn1_2 = (PathNode)e.nextElement();
                if (!pn1_2.equals(pn1_1.parent)) continue;
                e1 = Collections.enumeration(p2.Backbone);
                pn2_2 = null;
                while (e1.hasMoreElements()) {
                    pn2_2 = (PathNode)e1.nextElement();
                    if (pn2_2.equals(pn2_1.parent)) break;
                }
                if (pn2_2 == null) {
                    return false;
                }
                if (!pn2_2.label.equals(pn1_2.label) || pn2_2.type != pn1_2.type) {
                    return false;
                }
                pn1_1 = pn1_2;
                pn2_1 = pn2_2;
                continue block0;
lbl25:
                // 2 sources

                ** while (e.hasMoreElements())
            }
lbl26:
            // 1 sources

        }
    }

    private static void proc_refinepathset(ArrayList Gamma) {
        int i = 0;
        while (i < Gamma.size()) {
            boolean found;
            PathSet ps = (PathSet)Gamma.get(i);
            block1: do {
                found = false;
                int j = 0;
                while (j < ps.pathset.size()) {
                    Path p = (Path)ps.pathset.get(j);
                    int k = j + 1;
                    while (k < ps.pathset.size()) {
                        Path p1 = (Path)ps.pathset.get(k);
                        if (p1.id == p.id) {
                            found = true;
                            ps.pathset.remove(p1);
                            break;
                        }
                        ++k;
                    }
                    if (found) continue block1;
                    ++j;
                }
            } while (found);
            ++i;
        }
    }

    private static void testmodify() throws XPathParseException, XPathEvalException, NavException, ModifyException, TranscodeException, IOException {
        String filename = "C:\\MedicalDB2500.xml";
        String outputfilename = "C:\\MedicalDB25000_1.xml";
        VTDGen vg = new VTDGen();
        AutoPilot ap = new AutoPilot();
        AutoPilot ap1 = new AutoPilot();
        AutoPilot ap2 = new AutoPilot();
        XMLModifier xm = new XMLModifier();
        FileOutputStream os = new FileOutputStream(outputfilename);
        if (vg.parseFile(filename, true)) {
            int index;
            VTDNav vn = vg.getNav();
            ap.bind(vn);
            xm.bind(vn);
            String xpathstring = "/MedicalDB/patient/treatments/experiment";
            ap.selectXPath(xpathstring);
            while ((index = ap.evalXPath()) != -1) {
                System.out.println(vn.getAttrCount());
                System.out.println(vn.getContentFragment());
                System.out.println(vn.getTokenCount());
                System.out.println(vn.getTokenDepth(vn.getCurrentIndex()));
                System.out.println(vn.getTokenOffset(vn.getCurrentIndex()));
                System.out.println(vn.getTokenLength(vn.getCurrentIndex()));
                System.out.println(vn.getNormalizedStringLength(vn.getCurrentIndex()));
                System.out.println(vn.toString(vn.getCurrentIndex()));
                long l = vn.getContentFragment();
                System.out.println(l);
                System.out.println(l >> 32);
                System.out.println(vn.toString((int)l, (int)(l >> 32)));
                String elementcontent = vn.toString((int)l, (int)(l >> 32));
                xm.remove();
                xm.insertBeforeElement(elementcontent);
            }
            xm.output(os);
        }
        ((OutputStream)os).close();
    }

    private static Path copypath(Path p) {
        PathNode pn;
        Path newp = new Path();
        newp.pnr = p.pnr;
        newp.pnl = p.pnl;
        newp.id = p.id;
        Enumeration e = Collections.enumeration(p.PNE);
        while (e.hasMoreElements()) {
            pn = (PathNode)e.nextElement();
            PathNode pn1 = new PathNode();
            newp.PNE.add(pn);
        }
        e = Collections.enumeration(p.PNA);
        while (e.hasMoreElements()) {
            pn = (PathNode)e.nextElement();
            newp.PNA.add(pn);
        }
        e = Collections.enumeration(p.Backbone);
        while (e.hasMoreElements()) {
            pn = (PathNode)e.nextElement();
            newp.Backbone.add(pn);
        }
        return newp;
    }

    private static ArrayList ConstructDelta(VTDNav vn, ArrayList irs) throws CloneNotSupportedException, XPathExpressionException, XPathParseException, XPathEvalException, NavException {
        ArrayList<PathSet> Delta = new ArrayList<PathSet>();
        AutoPilot ap = new AutoPilot();
        AutoPilot ap1 = new AutoPilot();
        AutoPilot ap2 = new AutoPilot();
        ap.bind(vn);
        ap1.bind(vn);
        ap2.bind(vn);
        int id = 0;
        int i = 0;
        while (i < irs.size()) {
            InferenceRule ir = (InferenceRule)irs.get(i);
            ArrayList conditionpart = ir.conditionpart;
            Path condition1 = (Path)ir.conditionpart.get(0);
            Path path = IPVGenerateVTD.copypath(condition1);
            Enumeration e = Collections.enumeration(path.PNA);
            String attributename = "";
            while (e.hasMoreElements()) {
                PathNode pn = (PathNode)e.nextElement();
                if (!pn.label.contains("var_")) continue;
                attributename = pn.label.substring(pn.label.indexOf("@") + 1, pn.label.indexOf("#"));
                Enumeration e1 = Collections.enumeration(path.PNE);
                PathNode pn1 = null;
                while (e1.hasMoreElements()) {
                    pn1 = (PathNode)e1.nextElement();
                    if (pn1.equals(pn.parent)) break;
                }
                if (pn1 != null) {
                    path.pnl = pn1;
                }
                path.Backbone.clear();
                path.Backbone.add(pn1);
                path.PNA.remove(pn);
                while (pn1.parent != null) {
                    e1 = Collections.enumeration(path.PNE);
                    PathNode pn2 = null;
                    while (e1.hasMoreElements()) {
                        pn2 = (PathNode)e1.nextElement();
                        if (pn2.equals(pn1.parent)) break;
                    }
                    if (pn2 == null) continue;
                    path.Backbone.add(pn2);
                    pn1 = pn2;
                }
                break block1;
            }
            condition1 = (Path)ir.conditionpart.get(0);
            ArrayList<String> avaluelist = new ArrayList<String>();
            String xpathstring = "/MedicalDB" + IPVGenerateVTD.ConstructXPath(path, path.pnr);
            ap.selectXPath(xpathstring);
            while (ap.evalXPath() != -1) {
                long l;
                String attributevalue = "";
                if (attributename.equals("value")) {
                    l = vn.getText();
                    avaluelist.add(vn.toString((int)l));
                    continue;
                }
                l = vn.getAttrVal(attributename);
                avaluelist.add(vn.toString((int)l));
            }
            ap.resetXPath();
            int k = 0;
            while (k < avaluelist.size()) {
                String attributevalue = (String)avaluelist.get(k);
                PathSet pathset = new PathSet();
                boolean violated = true;
                int j = 0;
                while (j < conditionpart.size()) {
                    Path pp = (Path)conditionpart.get(j);
                    Path p = IPVGenerateVTD.copypath(pp);
                    pathset.pathset.add(p);
                    Enumeration e1 = Collections.enumeration(p.PNA);
                    while (e1.hasMoreElements()) {
                        PathNode pn = (PathNode)e1.nextElement();
                        if (pn.label.indexOf("var_") == -1) continue;
                        PathNode newpn = new PathNode();
                        newpn.type = pn.type;
                        newpn.parent = pn.parent;
                        newpn.label = pn.label.replace("var_x", attributevalue);
                        p.PNA.remove(pn);
                        p.PNA.add(newpn);
                        if (!p.Backbone.contains(pn)) break;
                        p.Backbone.remove(pn);
                        p.Backbone.add(newpn);
                        break;
                    }
                    if (j > 0) {
                        xpathstring = "/MedicalDB" + IPVGenerateVTD.ConstructXPath(p, p.pnr);
                        ap1.selectXPath(xpathstring);
                        if (ap1.evalXPath() == -1) {
                            violated = false;
                            break;
                        }
                        ap1.resetXPath();
                    }
                    ++j;
                }
                if (violated) {
                    Path p = IPVGenerateVTD.copypath(ir.targetpath);
                    Enumeration e1 = Collections.enumeration(p.PNA);
                    while (e1.hasMoreElements()) {
                        PathNode pn = (PathNode)e1.nextElement();
                        if (pn.label.indexOf("var_") == -1) continue;
                        PathNode newpn = new PathNode();
                        newpn.type = pn.type;
                        newpn.parent = pn.parent;
                        newpn.label = pn.label.replace("var_x", attributevalue);
                        p.PNA.remove(pn);
                        p.PNA.add(newpn);
                        if (!p.Backbone.contains(pn)) break;
                        p.Backbone.remove(pn);
                        p.Backbone.add(newpn);
                        break;
                    }
                    xpathstring = "/MedicalDB" + IPVGenerateVTD.ConstructXPath(p, p.pnr);
                    ap2.selectXPath(xpathstring);
                    violated = ap2.evalXPath() == -1;
                    ap2.resetXPath();
                }
                if (violated) {
                    pathset.id = ++id;
                    Delta.add(pathset);
                }
                ++k;
            }
            ++i;
        }
        return Delta;
    }

    private static String ConstructXPath(Path path, PathNode pn) {
        PathNode pn1;
        String xpath = pn.label;
        xpath = pn.label.equals("treatment") ? "//" + xpath : "/" + xpath;
        boolean thefirstbranch = true;
        PathNode pn_backbonechild = null;
        Enumeration e = Collections.enumeration(path.Backbone);
        while (e.hasMoreElements()) {
            pn1 = (PathNode)e.nextElement();
            if (pn1.parent == null || !pn1.parent.equals(pn)) continue;
            if (!path.PNE.contains(pn1)) break;
            pn_backbonechild = pn1;
            break;
        }
        e = Collections.enumeration(path.PNE);
        while (e.hasMoreElements()) {
            pn1 = (PathNode)e.nextElement();
            if (pn1.parent == null || !pn1.parent.equals(pn) || pn_backbonechild != null && pn1.equals(pn_backbonechild)) continue;
            if (thefirstbranch) {
                xpath = String.valueOf(xpath) + "[." + IPVGenerateVTD.ConstructXPathBranch(path, pn1);
                thefirstbranch = false;
                continue;
            }
            xpath = String.valueOf(xpath) + " and ." + IPVGenerateVTD.ConstructXPathBranch(path, pn1);
        }
        e = Collections.enumeration(path.PNA);
        while (e.hasMoreElements()) {
            pn1 = (PathNode)e.nextElement();
            if (!pn1.parent.equals(pn)) continue;
            String xpath_branch = "";
            xpath_branch = pn1.label.contains("@value#") ? pn1.label.replace("@value#", ". = \"") : pn1.label.replace("#", " = \"");
            xpath_branch = String.valueOf(xpath_branch) + "\"";
            if (thefirstbranch) {
                xpath = String.valueOf(xpath) + "[" + xpath_branch;
                thefirstbranch = false;
                continue;
            }
            xpath = String.valueOf(xpath) + " and " + xpath_branch;
        }
        if (!thefirstbranch) {
            xpath = String.valueOf(xpath) + "]";
        }
        if (pn_backbonechild != null) {
            xpath = String.valueOf(xpath) + IPVGenerateVTD.ConstructXPath(path, pn_backbonechild);
        }
        return xpath;
    }

    private static String ConstructXPathBranch(Path path, PathNode pn) {
        String xpath_branch;
        PathNode pn1;
        String xpath = pn.label;
        xpath = pn.label.equals("treatment") ? "//" + xpath : "/" + xpath;
        boolean hasbackbonechild = false;
        boolean thefirstbranch = true;
        PathNode pn_backbonechild = null;
        Enumeration e = Collections.enumeration(path.PNE);
        while (e.hasMoreElements()) {
            pn1 = (PathNode)e.nextElement();
            if (pn1.parent == null || !pn1.parent.equals(pn)) continue;
            if (!hasbackbonechild) {
                pn_backbonechild = pn1;
                continue;
            }
            xpath_branch = IPVGenerateVTD.ConstructXPathBranch(path, pn1);
            if (thefirstbranch) {
                xpath = String.valueOf(xpath) + "[" + xpath_branch;
                thefirstbranch = false;
                continue;
            }
            xpath = String.valueOf(xpath) + " and " + xpath_branch;
        }
        e = Collections.enumeration(path.PNA);
        while (e.hasMoreElements()) {
            pn1 = (PathNode)e.nextElement();
            if (!pn1.parent.equals(pn)) continue;
            xpath_branch = "";
            xpath_branch = pn1.label.contains("@value#") ? pn1.label.replace("@value#", ". = \"") : pn1.label.replace("#", " = \"");
            xpath_branch = String.valueOf(xpath_branch) + "\"";
            if (thefirstbranch) {
                xpath = String.valueOf(xpath) + "[" + xpath_branch;
                thefirstbranch = false;
                continue;
            }
            xpath = String.valueOf(xpath) + " and " + xpath_branch;
        }
        if (!thefirstbranch) {
            xpath = String.valueOf(xpath) + "]";
        }
        if (pn_backbonechild != null) {
            xpath = String.valueOf(xpath) + IPVGenerateVTD.ConstructXPathBranch(path, pn_backbonechild);
        }
        return xpath;
    }
}

