function [y1] = BQ70_TS30TS20Li(x1)
% BQ70_TS30TS20Li is neural network simulation function.
% It predicts TI BQ25570 efficiency according to the input voltage and
% current in addition to the storage voltage.
% 
% [y] = BQ70_TS30TS20Li(x) takes these arguments as:
%   x = [Vin, Vstr, Ii]'
%       Voltage values in V (Volt)
%       Current value in uA (micro Ampere)
% and returns:
%   y = efficiency (in percent)
% 
% This model has two hidden layers:
% first hidden layer including 30 neurons with tangent sigmoid transfer function 
% second hidden layer including 20 neurons with tangent sigmoid transfer function 
% and  a single neuron linear transfer function output layer.

% Coperight: Mojtaba Masoudinejad, 2018, Dortmund
% mojtaba.masoudinejad@tu-dortmund.de

% ===== NEURAL NETWORK CONSTANTS =====

% Input 1
x1_step1.xoffset = [0.328;1.5999;0.5];
x1_step1.gain = [0.447727781508843;0.769201184569824;1.99005965203807e-05];
x1_step1.ymin = -1;

% Layer 1
b1 = [86.814912152773928256;-46.249191130046291676;0.32939363583818470627;-4.5534684471054438504;19.255367717715838438;-7.4695454316951925833;-35.930822781310297387;2.2275647406605467715;-37.968297292558212064;18.722154975066480631;4.0047752636872306908;-0.05161067069924719225;-0.68683582189094849468;-4.6604529372745346905;0.5957672734650484303;2.1883993518401165801;0.0035571153706175106558;3.774322079347327108;-20.927639300368010566;1.0332788830888275378;42.084283028483199018;0.93559405710049847738;65.042369280849413826;-15.988497066428971394;11.034599383729782218;-8.5528269618028325283;-120.77312572303902982;-3.2612958232464945851;-92.907012323911146723;12.467949103336506411];
IW1_1 = [-1.5467767178610869472 -0.55812996263558067866 88.118405528239520663;0.054938391685480092441 -0.34895200535443471335 -45.81405140009632504;-1.8577507554374828036 -0.39923017693633944258 0.25319165916447178288;-0.83601925212413230604 -2.7507432040442885146 -0.10628881209530537111;-4.4891285491706902633 16.485091056025783729 7.4452161378396759517;11.035005652449209279 10.074053259101800606 -3.2326778510370566266;37.4412669632717936 -44.399545822762490843 -13.420952149514498331;-8.9867863990258580742 6.6103077961271869967 -0.097447962657976686107;19.364752411390842468 -12.348809641087287403 -40.937806882895081628;-11.083457497871256336 -36.598928994323756569 -9.0839768017337441108;-17.025240687686363117 11.079774224831696827 -1.8204414899219090174;-16.411169009832160981 9.4170197076478014964 2.1069196711220223861;15.604235603281333411 -6.2387254493270951627 -1.2456363300541364314;-2.7353280547501359621 13.304308795480773497 -15.065842911565070494;-0.6902900806281446755 0.11120797060416515167 1.3923153193911854686;-6.3819291173365249037 7.3922498899625814772 1.8431177039568289455;-17.322099583041534743 8.9250825496931458503 -0.15464452802899275596;0.8054945385471841135 29.216325096445341813 -23.569611701116940594;20.350495304069362135 -27.572021692217433042 -24.416980102409176823;3.5408173394493998032 -10.279179750920333092 7.4593924471523340713;64.977018903893593915 -39.009430151059490299 28.922835528085006018;-8.6164123187981722651 -0.59585129409880255302 9.4324979274635207815;1.2640758552486344168 0.33159667740299048067 65.141636215359881135;13.021762711472531393 32.714203768356057367 7.4387770267118238365;16.648788275601880571 -9.6999346540716171461 8.8766348141478097489;0.91265555286717647832 -11.060365273033591293 0.12819975336965647172;-1.7394363454990604545 0.53557975267564617017 -119.48835557647943517;-1.1005451252896683023 1.7422344330945409574 -2.5539561988865391307;1.5675336033387661239 -0.47060523388757957708 -94.079410306956930299;13.93231097331898205 0.31527680777847355564 -1.1542495358674287331];

% Layer 2
b2 = [6.9502712693853183623;-25.442658619868090852;-1.2607535774406659623;18.158806967991782955;7.4097048254489559227;-5.7445493328760361962;6.095982532929329345;6.7647847337953717073;0.10222877754862069732;-4.4539817838445854292;16.256332711439572591;16.714364621167970171;-4.9156756531639924646;-41.94823873841838946;21.993337913737896372;-12.256931009485528605;-6.0633602182745560683;1.1088680177766723212;9.6483021169715890153;13.600568739922573869];
LW2_1 = [3.8089152318507881745 -11.158573019178207986 8.1216677042459313185 11.235184781211932759 -0.53059447019511785104 0.073919762569917349393 -1.5074911199055383015 -4.2335196748978134451 0.36013739978831732502 -0.015844508960638870737 1.4721606015026438286 0.14738222242526768935 0.051387077879157819216 -0.0008192906154808545123 2.3310586861611737319 0.17283201367673897697 1.1429018788460063583 -0.05324504427004097401 -0.067440555831733126069 -0.08353908391420930557 -0.27417057658994858915 0.081187909990744572264 8.1214859262859420141 -0.0024904706366017572566 0.28553678917883545951 -0.34170828922707568998 12.084315224950252343 0.086926163473712139695 16.821438004303534086 -0.18575508885705102613;-0.032655003905873371262 0.073637933075916817138 0.033131289438524905155 -3.1188374836923467015 2.7331650046362723216 -0.0057585580400127105855 -2.9767060906145696997 -2.8822691569798490896 -0.6508282554614958082 -0.064576901859510330017 7.5795002310293950742 -0.10279145008225348823 0.10183356657474681994 4.4284266263167957334 -0.79679708261738102504 2.6069940032419602893 -0.11530307155879634951 1.5807384470806919996 -0.07767229394340056936 4.657343447122319624 0.048943031593980959593 0.22783522676637671389 -0.032255639228663035567 -0.06657679824099164978 -0.66151798132248951223 3.2207080696448211476 -0.23762128613858299331 0.038114221840649831208 -0.079901742932441024991 9.0282997052820164186;5.2025932409281709923 -6.9642228726682180451 4.2117448818552629675 -1.1227500895605433406 -1.0504213713672818642 2.5019253327922656993 -2.5703804315913321155 -4.163844252273393387 -0.34443203434013436315 0.1662263293557130206 -7.8397216125979696244 31.880030967227920513 5.5953752698184349157 -4.5563606467086277263 -7.6590875637157926903 2.3128848998720576979 4.4237870544407869033 4.2152204840683102915 0.31634323829953575613 1.6181939955533242159 -10.853583036211084334 -5.8229765066617531488 -4.6628136802045432319 1.2899426498359047866 26.106455846795473263 -2.0074427796988705275 -6.2769253928822967836 -6.8126815457127216646 4.2592039548556739348 -1.4928844570441843764;22.347678407311036608 -0.41649950729420159856 16.239645818248479969 0.95592026460173573632 -8.783638089376303526 11.017762687754833806 0.35874880313890461503 -10.537157595300689295 7.1850498207037318821 10.959321234085690477 0.88122670139559156066 17.822382941307136406 0.65481458793134816876 6.7207270462068260386 3.2053485623376292146 5.2976806104482152548 17.38064212226148797 -11.739361645878910068 -0.86271864269512887891 5.0542884692885143849 -28.047575929179167531 -9.6206484919982564463 -1.7364926526366606385 1.3376733006246503965 -4.9301972257229635943 3.4728045381192242935 7.5100101689157012785 -8.2851288667012976674 -3.0048156475535066079 18.62847592357625004;-11.804039414576548594 -4.2467342997785699765 -10.425898304353365731 -8.4440816650548828903 7.108589466733448603 -7.3794959703131830508 6.6741470390457440232 6.717471038536375616 -5.6009153949865284616 -6.3440826677504569275 -7.4629045642311204745 -6.4080379492074683867 26.330290593273346644 -20.426708099474673475 -22.46721405990201248 2.2840509091545260212 -29.17685565931316205 5.9971305855602050627 16.367318562094165912 -21.347494570641533329 10.107011748021340836 3.5865964105040384347 -21.29134887428963907 -7.2262917853707770988 -12.713117563351911343 2.6726837538145771234 36.555331346170945039 3.1690535652139826261 -0.91244834802652163841 2.9371342376275135777;1.7170911156151096311 -5.9588928942132479705 -0.55307709642637581382 8.0338251491339178756 17.20404300511076201 3.9539720161435569779 6.7489269390070871779 4.965690057039129357 -11.560512673997225264 2.0022951272826872149 -7.6957985787726865823 -12.224392723886012391 4.404144095348843102 -1.1962923534869289721 -2.9088740460722948278 -2.9840525344680690623 -8.7518906505027835863 5.9180725807477960743 -11.549100852840361142 10.238268174948718325 0.38341723296596430526 2.4622546516355976465 -0.51483687846049397407 1.5810835123743756103 5.4833946911830562243 0.039278309081760491572 -10.08427439842915696 -10.815782154919190816 6.7356476592086131916 -0.59706129768563498406;-0.91170380748881685307 10.450090566154486282 -14.89428654992127754 -2.4167776336948243454 -4.727329075150239035 -2.7224283391028762935 -24.452041337359574413 1.7402658415809908465 8.3703828471789929466 -1.8089417353484733564 -18.673844286322513142 4.5017361822275079319 -8.5781496132996277737 0.40085729181141349642 4.5552822650763111767 1.5046397454439106589 7.9393031067576593784 -6.5732592964903711064 10.669427435344791988 -12.461446856542510275 -0.089557082738128290789 -0.5610498004032770103 1.0695370778298824987 -2.9153546512534940227 -9.2266196601032834934 10.163038588724086608 3.8102937267107126473 -1.3753441442690137464 -5.8490329250541028827 0.34473824135665087631;1.7203657015706672606 -6.8480858857843696086 -8.6621260141305320701 1.5908542640987055616 24.510515100612124684 10.065507647590635543 12.41516985244364335 -6.8227517403196777934 -7.0204868072434676307 -0.48120935937562536733 -0.35387934807513371505 -8.3818969403606260471 2.0716162810124489901 -11.875348942244269068 16.296191628624288938 -0.90665662250093415064 1.6516146617643232553 5.381569954945629064 0.27124012614319487069 -0.95326124227594311034 5.6847162160293365218 -0.08721133768768844774 -2.2537608292763700035 -6.3062736658177680482 -8.8956148901643459226 -5.67706156449388466 -5.4470052937963195916 0.71958801074809652931 3.299040528747198664 1.1146957805138144604;-3.9370840030968969891 18.788024876602847257 7.8299286274335413438 -1.2462002094801609697 11.088069145289003004 1.3022270698021587432 -1.0466293093238892009 -5.6446937318062051503 12.75963450322840842 4.5272103654762982927 3.4317194693969108599 6.2387980933635942549 -1.9163366749563037761 -5.9529518813264479249 2.0035095066140762299 1.0182521754562259275 9.3056841169496440358 -10.616306882080680296 -6.2316981271200662107 -14.466515296795021683 0.62291061980602169257 -10.913962575814377232 14.699609231922725172 6.0732647730755360271 -13.918189204856824759 3.5368487881652614924 17.88309572895128241 -2.8136290419799294682 -9.1126748948798361738 -0.39878815234217784846;-1.6567123851744205432 15.605086612590042705 -6.8260718439665941659 -4.9751147081151056994 1.8626796854226870259 3.9416990226497650163 0.43375881407712912896 10.920540662192665948 1.9536770614707854588 5.1518002588606837122 11.803418114800940941 4.0210186517816275398 21.019205835145903905 6.5325789865887040619 -0.47182305044814132344 -5.8269122458919460072 -9.7048465810874233739 -2.7047475378038075 -2.1228452763236234091 0.34381565832221772094 12.835020826834703911 0.053075847355865540811 -3.1355250075346590144 9.9976631434791940478 10.528430238977581013 -4.0906495707051497845 2.1454026791214055869 11.673600787855420435 -10.036194044492283695 10.632124930570283183;-13.766717887953143773 33.27693120290724238 11.289722180928770001 1.425219330505919979 -5.3740290341546339548 3.7138017177360294063 -11.507357419765201101 4.2513668019177153212 0.9161473901453818236 -1.9277101457020200392 -3.1695307947808433191 9.0111177381862663793 2.9177496985524848938 3.0439383699965825159 -3.7639574546682843526 -2.0812819728802178787 9.9657600934299956918 -1.3425627739367349545 -0.58994193588875587508 8.8935832713624769497 2.6514266152511742902 0.79105043478891556852 -0.86251848063786307197 -6.0456490918710947824 -1.1600022731142956012 -1.2554572660443890086 -6.7678822601889390143 -0.18863848394761928429 -21.140094775505826163 0.31864906308210827479;6.7118945041125694928 -54.687969216028378128 -4.9767151019003605938 18.711184289394996227 4.8355537183944576896 -0.11803585482691278385 5.5437015970205019144 11.149869442990125279 1.8146846570753638606 0.042356163338925841011 3.0702286195996695284 -22.593292633377799916 -1.0770213073491559097 -1.7536796176417570603 4.7677922639930114812 -0.42564962896323754737 -1.9752044687027288106 -36.129768910923871772 0.26724092305967012129 6.9438561913426832817 -0.57639340077040290833 3.4233210720859621468 -16.807523842673013803 0.0582675023652819285 -23.905569102832298967 -4.9944623897617699271 47.256053957637135454 -2.7358757180337582859 64.282936313102055692 2.4392325533287677608;-1.4119442740317280638 -25.501532579986243121 -8.3311271118907530564 -10.206567610407205393 -1.6831765386805246365 4.126655428016722027 17.365180132377059152 8.794176249516130639 -1.2731438211677477135 -0.16797330346565134129 -7.6796774276845694018 -3.8104216995249080568 4.4033002323931604849 3.6831727040147539398 0.46322653212260433975 -2.4372154362012206086 2.0921490928335058079 -3.4077586374363542099 0.39043543536762836954 -0.37657463309004735041 2.7714957426524207129 1.1954586974000227517 -11.552515577241155853 2.4664303730397723058 10.79867094181852849 2.8393843063054524656 -3.5990211617952034828 5.8440477320744328438 -0.50930894707042073666 3.2101670457819997395;29.22129299513671441 3.0950302942128411487 -3.3074308409873132142 0.79446766026229664881 -7.3697470049577882278 7.2742071909050753931 -3.5771196037732599926 5.7273406596750238151 4.0984161164453905002 12.789934988351832956 -5.2077763007867874379 -11.703487153876379168 -13.497877983081213671 9.3783889055282774194 20.009762040849818021 9.1075435958286359295 -7.0200176493812351808 -12.465913329398793152 4.1873104825246496574 -6.4041924128000200511 2.7253203384632564976 -4.4604263070593397345 -17.577035233009581816 -1.9979587804270591 -0.1891579591615602518 -4.417352046013293787 26.555515257721651778 -7.758748111454517371 -32.855909999468337901 -1.550635298233632664;39.608794447718061349 -33.421793656792090133 6.5493274408897423911 -15.328933018138874544 3.2437387457713446892 -0.55786770579439215467 12.263188250147326386 -16.999733968711314702 -7.8896698520093178075 -4.5430540278061197768 22.850657100421969403 -3.2343190458819948141 2.7512592376652302839 12.287562569578378557 10.487318131648651232 3.9917836310719185811 9.3899057457407710814 19.116175550446342868 -2.4655171437876495233 -19.408208876517491603 -66.613947589815865058 -18.266028582943295788 22.790823373991173639 -3.7162863670235104507 11.038749319691254058 19.881411066235262552 0.57913267077460828247 -14.503437558260632301 -43.289656739515507411 22.057368934164106378;0.047807153988583338255 5.3979193419746618332 -1.690568203707484507 -7.8701827369990953187 -7.0738497466449699047 0.2053603987469915515 -5.7625707675454362899 0.91607526129703897855 -0.57126082071312322963 -0.084288221456154624467 -0.029859535596952382908 -0.68833569691206819563 0.58398793739064758235 -0.18908700949093970589 -1.4530763655990706074 0.4654158226896757955 0.98380941172160418784 -0.086501401600665953073 0.47426155329504987579 -0.24039668257945270846 0.038132256250022186772 0.29652539791358833998 0.83705550911106241241 -0.075160263730347662281 0.16704072918374121559 0.057881187871848920057 -3.1937101560419445256 -4.0882899392866098864 -0.60319712930743840662 3.3016750571527238023;-8.174907377897277172 -17.319750728267379714 -6.4665435181427168843 3.6792725204518226256 -4.4539376710657911929 2.5935553880916306646 -7.9029541916194219198 12.210495766136510554 10.69698907654920994 -13.246728871974013941 -2.7884224658381673301 4.7665403197862108442 11.595144786986359975 13.534292581523409638 12.580588552788031009 -9.1009828564059489509 6.8997425506061222933 5.5697672876928638885 0.40556034590244649518 -3.8533676182577543123 3.8617137179892013776 -1.5462203169800845526 -2.6744297058297790137 -5.7831282309875744474 -6.4332396635729471868 -4.2077404957431836507 -8.1291037772879377599 -6.74221160727267943 -30.146751613257919189 8.388140726471389641;-3.8846773845531989977 -20.464739188944690795 5.9812907181599630491 -5.3554529652860338729 -11.048163484395793432 -1.2921483099034687392 7.8710401668215395077 11.394758268424212133 3.2718506758866525708 -13.39847079844962785 0.2824876253352301414 2.2983725799764416209 -3.006631706171973395 -9.8401759060105558063 3.308959368989741634 8.6357609130388102159 21.222181949766230957 -0.51799215490262873196 2.1908716664478258274 5.8617865095950190124 0.043871221535964441407 5.5457495857264422767 -4.170421845241433445 -16.35414246572047503 4.923784200470979755 14.957254635122417596 2.8235532154428510943 19.764189782357096448 -4.8454911811462428872 4.0451391116766375333;-36.264550447936706234 -16.777563417838013748 -10.027617780000310788 -0.23052133600906823951 12.242438912017618691 0.89316536816493330431 21.847474240188574868 -8.8614778951554757924 0.13177042585650655671 1.1103496166935973299 14.45621974317425007 16.047463275828125262 -9.1620852738392084547 -7.9927146143264673483 -9.5252698135051456774 0.091355880590290358678 24.740171483029904209 -0.50917106040615478513 -0.12010945291207321406 -10.830878450727450257 1.9795333581319574101 1.066268993865638004 -11.231639337144107671 0.10787802555286193917 -0.038221409870227589234 -17.110374954506717415 -13.411301192218902045 -13.735722321884910713 -16.022392756012120429 4.31550439463670088;86.800054056696836824 -15.751418550203579727 7.5076310220196971201 -0.075172605779920895208 22.35048392868892364 -8.7601178276393003586 19.31236898620213438 15.346003924610020164 1.6888192569129014675 37.318988707072989541 0.16648800882775485754 2.6640510379226389759 -5.4294323963358461782 -9.860363042175992021 34.44743531625862687 9.9600757885273392134 -6.3792501444136187061 3.5090296917769556728 5.1530985059422160788 -3.9970305754071655535 -53.896794658809646705 -0.24122229966893873887 16.863740897705238098 -4.2690197814562713674 0.33373443193871082935 4.2928299527521520673 -62.837097934434474666 59.536283989597883703 28.331233062658796484 10.400325588325763704];

% Layer 3
b3 = 60.211673817523475805;
LW3_2 = [-17.69766904137348007 32.053497748123184863 -2.1126593883163153897 1.1770974802925755487 -0.37866902234066357469 -3.8818484350183490861 -3.7058544139759677094 2.7945200812913473243 0.6375274037287639306 2.2516464238124056507 -0.68068932088138300873 -33.19573319653288479 -2.718334605595228215 -0.60157847906808481486 0.52374790540977389508 5.8264635677017482251 -2.4861515077165790011 -0.84316005454065645619 7.4787747211921642432 -0.34924145245952992189];

% ===== SIMULATION ========

% Dimensions
Q = size(x1,2); % samples

% Input 1
xp1 = mapminmax_apply(x1,x1_step1);

% Layer 1
a1 = tansig_apply(repmat(b1,1,Q) + IW1_1*xp1);

% Layer 2
a2 = tansig_apply(repmat(b2,1,Q) + LW2_1*a1);

% Layer 3
a3 = repmat(b3,1,Q) + LW3_2*a2;

% Output 1
y1 = a3;
end

% ===== MODULE FUNCTIONS ========

% Map Minimum and Maximum Input Processing Function
function y = mapminmax_apply(x,settings)
  y = bsxfun(@minus,x,settings.xoffset);
  y = bsxfun(@times,y,settings.gain);
  y = bsxfun(@plus,y,settings.ymin);
end

% Sigmoid Symmetric Transfer Function
function a = tansig_apply(n,~)
  a = 2 ./ (1 + exp(-2*n)) - 1;
end
